/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.internal.Logger;

public class StringUtils {
    protected static final String AMPERSTAND = "&";
    protected static final String AMPERSTAND_ENTITY = "&&;";
    protected static final String CARRIAGE_RETURN = "\r";
    protected static final String CARRIAGE_RETURN_ENTITY = "\\r";
    protected static final String CR = "\r";
    protected static final String CRLF = "\r\n";
    protected static final String DELIMITERS = " \t\n\r\f";
    protected static final String DOUBLE_QUOTE = "\"";
    protected static final char DOUBLE_QUOTE_CHAR = '\"';
    protected static final String DOUBLE_QUOTE_ENTITY = "&quot;";
    protected static final String EQUAL_SIGN = "=";
    protected static final String EQUAL_SIGN_ENTITY = "&#61;";
    private static final String FALSE = "false";
    protected static final String GREATER_THAN = ">";
    protected static final String GREATER_THAN_ENTITY = "&gt;";
    protected static final String LESS_THAN = "<";
    protected static final String LESS_THAN_ENTITY = "&lt;";
    protected static final String LF = "\n";
    protected static final String LINE_FEED = "\n";
    protected static final String LINE_FEED_ENTITY = "\\n";
    protected static final String LINE_FEED_TAG = "<dl>";
    protected static final String LINE_TAB = "\t";
    protected static final String LINE_TAB_ENTITY = "\\t";
    protected static final String LINE_TAB_TAG = "<dd>";
    protected static final String SINGLE_QUOTE = "'";
    protected static final char SINGLE_QUOTE_CHAR = '\'';
    protected static final String SINGLE_QUOTE_ENTITY = "&#039;";
    protected static final String SPACE = " ";
    protected static final String SPACE_ENTITY = "&nbsp;";
    private static final String TRUE = "true";

    public static String appendIfNotEndWith(String aString, String appendString) {
        if (aString != null && appendString != null) {
            if (aString.endsWith(appendString)) {
                return aString;
            }
            return String.valueOf(aString) + appendString;
        }
        return aString;
    }

    public static String[] asArray(String value) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer stok = new StringTokenizer(value);
        while (stok.hasMoreTokens()) {
            list.add(stok.nextToken());
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String[] asArray(String value, String delim) {
        return StringUtils.asArray(value, delim, false);
    }

    public static String[] asArray(String value, String delim, boolean returnTokens) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer stok = new StringTokenizer(value, delim, returnTokens);
        while (stok.hasMoreTokens()) {
            list.add(stok.nextToken());
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String[] asFixedArray(String value, String delim) {
        String[] array = StringUtils.asArray(value, delim, true);
        int arrayLength = array.length;
        boolean stringFound = false;
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < arrayLength) {
            String token = array[i];
            if (token.compareTo(delim) == 0) {
                if (!stringFound) {
                    list.add(null);
                }
                stringFound = false;
            } else {
                list.add(token);
                stringFound = true;
            }
            ++i;
        }
        if (!stringFound) {
            list.add(null);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String chop(String source) {
        return StringUtils.chop(source, "/");
    }

    public static String chop(String source, String delimiter) {
        return source.substring(0, source.lastIndexOf(delimiter));
    }

    public static boolean contains(String[] arrayOfStrings, String needle, boolean caseSensitive) {
        boolean result = false;
        if (needle == null) {
            return false;
        }
        if (arrayOfStrings == null) {
            return false;
        }
        if (caseSensitive) {
            int i = 0;
            while (i < arrayOfStrings.length) {
                if (needle.equals(arrayOfStrings[i])) {
                    result = true;
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < arrayOfStrings.length) {
                if (needle.equalsIgnoreCase(arrayOfStrings[i])) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean containsLetters(String fullValue) {
        if (fullValue == null || fullValue.length() == 0) {
            return false;
        }
        char[] chars = fullValue.toCharArray();
        int i = 0;
        while (i < fullValue.length()) {
            if (Character.isLetter(chars[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLineDelimiter(String aString) {
        return StringUtils.indexOfLineDelimiter(aString) != -1;
    }

    public static String convertLineDelimiters(String allText, String lineDelimiterToUse) {
        Document tempDoc = new Document(allText);
        if (lineDelimiterToUse == null) {
            lineDelimiterToUse = System.getProperty("line.separator");
        }
        String newText = "";
        int lineCount = tempDoc.getNumberOfLines();
        int i = 0;
        while (i < lineCount) {
            try {
                IRegion lineInfo = tempDoc.getLineInformation(i);
                int lineStartOffset = lineInfo.getOffset();
                int lineLength = lineInfo.getLength();
                int lineEndOffset = lineStartOffset + lineLength;
                newText = String.valueOf(newText) + allText.substring(lineStartOffset, lineEndOffset);
                if (i < lineCount - 1 && tempDoc.getLineDelimiter(i) != null) {
                    newText = String.valueOf(newText) + lineDelimiterToUse;
                }
            }
            catch (BadLocationException e) {
                Logger.log(1, e.getMessage());
            }
            ++i;
        }
        return newText;
    }

    public static String convertToHTMLContent(String content) {
        content = StringUtils.replace(content, AMPERSTAND, AMPERSTAND_ENTITY);
        content = StringUtils.replace(content, LESS_THAN, LESS_THAN_ENTITY);
        content = StringUtils.replace(content, GREATER_THAN, GREATER_THAN_ENTITY);
        content = StringUtils.replace(content, "\n", LINE_FEED_TAG);
        content = StringUtils.replace(content, LINE_TAB, LINE_TAB_TAG);
        content = StringUtils.replace(content, SINGLE_QUOTE, SINGLE_QUOTE_ENTITY);
        content = StringUtils.replace(content, DOUBLE_QUOTE, DOUBLE_QUOTE_ENTITY);
        content = StringUtils.replace(content, "  ", "&nbsp;&nbsp;");
        return content;
    }

    public static String escape(String normalString) {
        if (normalString == null) {
            return null;
        }
        StringBuffer escapedBuffer = new StringBuffer();
        StringTokenizer toker = new StringTokenizer(normalString, "=\n\r\t", true);
        String chunk = null;
        while (toker.hasMoreTokens()) {
            chunk = toker.nextToken();
            if (chunk.equals(EQUAL_SIGN)) {
                escapedBuffer.append(EQUAL_SIGN_ENTITY);
                continue;
            }
            if (chunk.equals("\n")) {
                escapedBuffer.append(LINE_FEED_ENTITY);
                continue;
            }
            if (chunk.equals("\r")) {
                escapedBuffer.append(CARRIAGE_RETURN_ENTITY);
                continue;
            }
            if (chunk.equals(LINE_TAB)) {
                escapedBuffer.append(LINE_TAB_ENTITY);
                continue;
            }
            escapedBuffer.append(chunk);
        }
        return escapedBuffer.toString();
    }

    public static String firstLineOf(String text) {
        if (text == null || text.length() < 1) {
            return text;
        }
        Document doc = new Document(text);
        try {
            int lineNumber = doc.getLineOfOffset(0);
            IRegion line = doc.getLineInformation(lineNumber);
            return doc.get(line.getOffset(), line.getLength());
        }
        catch (BadLocationException badLocationException) {
            return text;
        }
    }

    public static int indexOfLastLineDelimiter(String aString) {
        return StringUtils.indexOfLastLineDelimiter(aString, aString.length());
    }

    public static int indexOfLastLineDelimiter(String aString, int offset) {
        int index = -1;
        if (aString != null && aString.length() > 0 && (index = aString.lastIndexOf(CRLF, offset)) == -1 && (index = aString.lastIndexOf("\r", offset)) == -1) {
            index = aString.lastIndexOf("\n", offset);
        }
        return index;
    }

    public static int indexOfLineDelimiter(String aString) {
        return StringUtils.indexOfLineDelimiter(aString, 0);
    }

    public static int indexOfLineDelimiter(String aString, int offset) {
        int index = -1;
        if (aString != null && aString.length() > 0 && (index = aString.indexOf(CRLF, offset)) == -1 && (index = aString.indexOf("\r", offset)) == -1) {
            index = aString.indexOf("\n", offset);
        }
        return index;
    }

    public static int indexOfNonblank(String aString) {
        return StringUtils.indexOfNonblank(aString, 0);
    }

    public static int indexOfNonblank(String aString, int offset) {
        int index = -1;
        if (aString != null && aString.length() > 0) {
            int i = offset;
            while (i < aString.length()) {
                if (DELIMITERS.indexOf(aString.substring(i, i + 1)) == -1) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    public static String insertIfNotStartWith(String aString, String insertString) {
        if (aString != null && insertString != null) {
            if (aString.startsWith(insertString)) {
                return aString;
            }
            return String.valueOf(insertString) + aString;
        }
        return aString;
    }

    public static boolean isQuoted(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        int lastIndex = string.length() - 1;
        char firstChar = string.charAt(0);
        char lastChar = string.charAt(lastIndex);
        return firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"';
    }

    public static void main(String[] args) {
        StringUtils.testStripNonLetterDigits();
    }

    public static String merge(String newStart, String newEnd) {
        String[] regions = StringUtils.overlapRegions(newStart, newEnd);
        return String.valueOf(regions[0]) + regions[1] + regions[2];
    }

    public static int occurrencesOf(String searchString, char targetChar) {
        int result = 0;
        int len = searchString.length();
        int i = 0;
        while (i < len) {
            if (targetChar == searchString.charAt(i)) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private static String[] overlapRegions(String start, String end) {
        String[] results = null;
        if (start != null && end == null) {
            results = new String[]{start, "", ""};
        } else if (start == null && end != null) {
            results = new String[]{"", "", end};
        } else if (start == null && end == null) {
            results = new String[]{"", "", ""};
        } else if (start != null && end != null) {
            int startLength = start.length();
            int endLength = end.length();
            if (startLength == 0 || endLength == 0) {
                results = new String[]{"", "", ""};
            } else {
                results = new String[3];
                String testStart = "";
                String testEnd = "";
                int mergeLength = Math.min(startLength, endLength);
                boolean finished = false;
                while (mergeLength > 0 && !finished) {
                    testStart = start.substring(startLength - mergeLength);
                    if (testStart.equals(testEnd = end.substring(0, mergeLength))) {
                        finished = true;
                        results[0] = start.substring(0, startLength - mergeLength);
                        results[1] = start.substring(startLength - mergeLength);
                        results[2] = end.substring(mergeLength);
                    }
                    --mergeLength;
                }
                if (!finished) {
                    results[0] = start;
                    results[1] = "";
                    results[2] = end;
                }
            }
        }
        return results;
    }

    public static String pack(String[] strings) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            buf.append(StringUtils.replace(strings[i], ",", "&comma;"));
            if (i < strings.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        return buf.toString();
    }

    public static String paste(String oldText, String newText, int start, int length) {
        String result = null;
        StringBuffer sb = new StringBuffer();
        int startIndex = start;
        int endIndex = start + length;
        if (startIndex > oldText.length()) {
            startIndex = oldText.length();
        }
        sb.append(oldText.substring(0, startIndex));
        if (newText != null) {
            sb.append(newText);
        }
        if (endIndex < oldText.length()) {
            sb.append(oldText.substring(endIndex));
        }
        result = sb.toString();
        return result;
    }

    public static String replace(String aString, String source, String target) {
        if (aString == null) {
            return null;
        }
        String normalString = "";
        int length = aString.length();
        int position = 0;
        int previous = 0;
        int spacer = source.length();
        while (position + spacer - 1 < length && aString.indexOf(source, position) > -1) {
            position = aString.indexOf(source, previous);
            normalString = String.valueOf(normalString) + aString.substring(previous, position) + target;
            previous = position += spacer;
        }
        normalString = String.valueOf(normalString) + aString.substring(position, aString.length());
        return normalString;
    }

    public static String restoreMarkers(String text) {
        String content = text;
        content = StringUtils.replace(content, AMPERSTAND, AMPERSTAND_ENTITY);
        content = StringUtils.replace(content, LESS_THAN, LESS_THAN_ENTITY);
        content = StringUtils.replace(content, GREATER_THAN, GREATER_THAN_ENTITY);
        return content;
    }

    public static String strip(String quotedString) {
        if (quotedString == null || quotedString.length() == 0) {
            return quotedString;
        }
        String trimmed = quotedString.trim();
        if (trimmed.length() < 2) {
            return quotedString;
        }
        char first = trimmed.charAt(0);
        char nextToLast = trimmed.charAt(trimmed.length() - 2);
        char last = trimmed.charAt(trimmed.length() - 1);
        if (first == '\"' && last == '\"' && nextToLast != '\\' || first == '\'' && last == '\'' && nextToLast != '\\') {
            return trimmed.substring(1, trimmed.length() - 1);
        }
        return trimmed;
    }

    public static String stripNonLetterDigits(String fullValue) {
        if (fullValue == null || fullValue.length() == 0) {
            return fullValue;
        }
        int fullValueLength = fullValue.length();
        int firstPos = 0;
        while (firstPos < fullValueLength && !Character.isLetterOrDigit(fullValue.charAt(firstPos))) {
            ++firstPos;
        }
        int lastPos = fullValueLength - 1;
        while (lastPos > firstPos && !Character.isLetterOrDigit(fullValue.charAt(lastPos))) {
            --lastPos;
        }
        String result = fullValue;
        if (firstPos != 0 || lastPos != fullValueLength) {
            result = fullValue.substring(firstPos, lastPos + 1);
        }
        return result;
    }

    public static String stripQuotes(String quotedValue) {
        if (quotedValue == null) {
            return null;
        }
        return StringUtils.stripQuotesLeaveInsideSpace(quotedValue).trim();
    }

    public static String stripQuotesLeaveInsideSpace(String quotedValue) {
        if (quotedValue == null) {
            return null;
        }
        String result = quotedValue.trim();
        int len = result.length();
        if (len > 0) {
            char lastChar;
            char firstChar = result.charAt(0);
            if (firstChar == '\'' || firstChar == '\"') {
                result = result.substring(1, len);
            }
            if ((len = result.length()) > 0 && ((lastChar = result.charAt(len - 1)) == '\'' || lastChar == '\"')) {
                result = result.substring(0, len - 1);
            }
        }
        return result;
    }

    public static void testPaste() {
        String testString = "The quick brown fox ...";
        System.out.println(StringUtils.paste(testString, null, 4, 5));
        System.out.println(StringUtils.paste(testString, null, 4, 6));
        System.out.println(StringUtils.paste(testString, "", 4, 6));
        System.out.println(StringUtils.paste(testString, "fast", 4, 6));
        System.out.println(StringUtils.paste(testString, "fast ", 4, 6));
        System.out.println(StringUtils.paste(testString, "But ", 0, 0));
        System.out.println(StringUtils.paste("", "burp", 4, 6));
    }

    public static void testStripNonLetterDigits() {
        String testString = "abc";
        System.out.println(String.valueOf(testString) + " -->" + StringUtils.stripNonLetterDigits(testString) + "<--");
        testString = "";
        System.out.println(String.valueOf(testString) + " -->" + StringUtils.stripNonLetterDigits(testString) + "<--");
        testString = "\"abc\"";
        System.out.println(String.valueOf(testString) + " -->" + StringUtils.stripNonLetterDigits(testString) + "<--");
        testString = "\"ab-c1?";
        System.out.println(String.valueOf(testString) + " -->" + StringUtils.stripNonLetterDigits(testString) + "<--");
        testString = "+++";
        System.out.println(String.valueOf(testString) + " -->" + StringUtils.stripNonLetterDigits(testString) + "<--");
        testString = "abc=";
        System.out.println(String.valueOf(testString) + " -->" + StringUtils.stripNonLetterDigits(testString) + "<--");
        testString = "abc ";
        System.out.println(String.valueOf(testString) + " -->" + StringUtils.stripNonLetterDigits(testString) + "<--");
    }

    public static String toString(boolean booleanValue) {
        if (booleanValue) {
            return TRUE;
        }
        return FALSE;
    }

    public static String unescape(String aString) {
        if (aString == null) {
            return null;
        }
        String normalString = StringUtils.replace(aString, EQUAL_SIGN_ENTITY, EQUAL_SIGN);
        normalString = StringUtils.replace(normalString, LINE_FEED_ENTITY, "\n");
        normalString = StringUtils.replace(normalString, CARRIAGE_RETURN_ENTITY, "\r");
        normalString = StringUtils.replace(normalString, LINE_TAB_ENTITY, LINE_TAB);
        return normalString;
    }

    public static String uniqueEndOf(String newStart, String newEnd) {
        String[] regions = StringUtils.overlapRegions(newStart, newEnd);
        return regions[2];
    }

    public static String[] unpack(String s) {
        if (s == null) {
            return new String[0];
        }
        StringTokenizer toker = new StringTokenizer(s, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (toker.hasMoreTokens()) {
            list.add(StringUtils.replace(toker.nextToken(), "&comma;", ",").trim());
        }
        return list.toArray(new String[0]);
    }

    private StringUtils() {
    }
}

