/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.internal.IMemento;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.jst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.core.IRuntime;

public abstract class RuntimeClasspathProviderDelegate {
    private List sourceAttachments;
    private String extensionId;

    public final void initialize(String id) {
        this.extensionId = id;
    }

    public abstract String getClasspathContainerLabel(IRuntime var1, String var2);

    public abstract IClasspathEntry[] resolveClasspathContainer(IRuntime var1, String var2);

    private void load() {
        this.sourceAttachments = new ArrayList();
        String id = this.extensionId;
        String filename = JavaServerPlugin.getInstance().getStateLocation().append(String.valueOf(id) + ".xml").toOSString();
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] children = memento.getChildren("source-attachment");
            int size = children.length;
            int i = 0;
            while (i < size) {
                try {
                    IMemento[] attrChildren;
                    SourceAttachmentUpdate sau = new SourceAttachmentUpdate();
                    sau.runtimeId = children[i].getString("runtime-id");
                    sau.id = children[i].getString("id");
                    String temp = children[i].getString("entry");
                    if (temp != null) {
                        sau.entry = new Path(temp);
                    }
                    if ((temp = children[i].getString("source-attachment-path")) != null) {
                        sau.sourceAttachmentPath = new Path(temp);
                    }
                    if ((temp = children[i].getString("source-attachment-root-path")) != null) {
                        sau.sourceAttachmentRootPath = new Path(temp);
                    }
                    if ((attrChildren = children[i].getChildren("attribute")) != null) {
                        int size2 = attrChildren.length;
                        sau.attributes = new IClasspathAttribute[size2];
                        int j = 0;
                        while (j < size2) {
                            String name = attrChildren[j].getString("name");
                            String value = attrChildren[j].getString("value");
                            sau.attributes[j] = JavaCore.newClasspathAttribute((String)name, (String)value);
                            ++j;
                        }
                    }
                    this.sourceAttachments.add(sau);
                }
                catch (Exception e) {
                    Trace.trace(Trace.WARNING, "Could not load monitor: " + e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load source path info: " + e.getMessage());
        }
    }

    public IClasspathEntry[] resolveClasspathContainerImpl(IRuntime runtime, String id) {
        IClasspathEntry[] entries = this.resolveClasspathContainer(runtime, id);
        if (entries == null) {
            entries = new IClasspathEntry[]{};
        }
        if (this.sourceAttachments == null) {
            this.load();
        }
        int size = entries.length;
        int size2 = this.sourceAttachments.size();
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size2) {
                SourceAttachmentUpdate sau = (SourceAttachmentUpdate)this.sourceAttachments.get(j);
                if ((id != null && sau.id.equals(id) || id == null && sau.id == null) && sau.runtimeId.equals(runtime.getId()) && sau.entry.equals((Object)entries[i].getPath())) {
                    entries[i] = JavaCore.newLibraryEntry((IPath)entries[i].getPath(), (IPath)sau.sourceAttachmentPath, (IPath)sau.sourceAttachmentRootPath, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])sau.attributes, (boolean)false);
                }
                ++j;
            }
            ++i;
        }
        return entries;
    }

    private static void addJarFiles(File dir, List list, boolean includeSubdirectories) {
        int depth = 0;
        if (includeSubdirectories) {
            depth = 2;
        }
        RuntimeClasspathProviderDelegate.addJarFiles(dir, list, depth);
    }

    private static void addJarFiles(File dir, List list, int depth) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        File[] files = dir.listFiles();
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (files[i].isDirectory() && depth > 0) {
                    RuntimeClasspathProviderDelegate.addJarFiles(files[i], list, depth - 1);
                } else if (files[i].getAbsolutePath().endsWith(".jar") || files[i].getAbsolutePath().endsWith(".zip")) {
                    Path path = new Path(files[i].getAbsolutePath());
                    list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                }
                ++i;
            }
        }
    }

    protected static void addLibraryEntries(List list, File dir, boolean includeSubdirectories) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        RuntimeClasspathProviderDelegate.addJarFiles(dir, list, includeSubdirectories);
    }

    public void requestClasspathContainerUpdate(IRuntime runtime, String id, IClasspathEntry[] entries) {
        if (runtime == null || entries == null) {
            return;
        }
        this.sourceAttachments = new ArrayList();
        int size = entries.length;
        int i = 0;
        while (i < size) {
            if (entries[i].getSourceAttachmentPath() != null || entries[i].getExtraAttributes() != null) {
                SourceAttachmentUpdate sau = new SourceAttachmentUpdate();
                sau.runtimeId = runtime.getId();
                sau.id = id;
                sau.entry = entries[i].getPath();
                sau.sourceAttachmentPath = entries[i].getSourceAttachmentPath();
                sau.sourceAttachmentRootPath = entries[i].getSourceAttachmentRootPath();
                sau.attributes = entries[i].getExtraAttributes();
                this.sourceAttachments.add(sau);
            }
            ++i;
        }
        this.save();
    }

    private void save() {
        if (this.sourceAttachments == null) {
            return;
        }
        String id = this.extensionId;
        String filename = JavaServerPlugin.getInstance().getStateLocation().append(String.valueOf(id) + ".xml").toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("classpath");
            Iterator iterator = this.sourceAttachments.iterator();
            while (iterator.hasNext()) {
                SourceAttachmentUpdate sau = (SourceAttachmentUpdate)iterator.next();
                IMemento child = memento.createChild("source-attachment");
                child.putString("runtime-id", sau.runtimeId);
                if (sau.id != null) {
                    child.putString("id", sau.id);
                }
                if (sau.entry != null) {
                    child.putString("entry", sau.entry.toPortableString());
                }
                if (sau.sourceAttachmentPath != null) {
                    child.putString("source-attachment-path", sau.sourceAttachmentPath.toPortableString());
                }
                if (sau.sourceAttachmentRootPath != null) {
                    child.putString("source-attachment-root-path", sau.sourceAttachmentRootPath.toPortableString());
                }
                if (sau.attributes == null) continue;
                int size = sau.attributes.length;
                int i = 0;
                while (i < size) {
                    IClasspathAttribute attr = sau.attributes[i];
                    IMemento attrChild = child.createChild("attribute");
                    attrChild.putString("name", attr.getName());
                    attrChild.putString("value", attr.getValue());
                    ++i;
                }
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error saving source path info", e);
        }
    }

    private class SourceAttachmentUpdate {
        String runtimeId;
        String id;
        IPath entry;
        IPath sourceAttachmentPath;
        IPath sourceAttachmentRootPath;
        IClasspathAttribute[] attributes;

        SourceAttachmentUpdate() {
        }
    }
}

