/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.jst.server.core.internal.RuntimeFacetMapping;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.wst.server.core.IRuntimeType;

public class JavaServerPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.server.core";
    private static JavaServerPlugin singleton;
    private static List runtimeClasspathProviders;
    private static List runtimeFacetMappings;

    public JavaServerPlugin() {
        singleton = this;
    }

    public static JavaServerPlugin getInstance() {
        return singleton;
    }

    public static void log(IStatus status) {
        JavaServerPlugin.getInstance().getLog().log(status);
    }

    public static void log(Throwable t) {
        JavaServerPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "Internal error", t));
    }

    public static RuntimeClasspathProviderWrapper[] getRuntimeClasspathProviders() {
        if (runtimeClasspathProviders == null) {
            JavaServerPlugin.loadRuntimeClasspathProviders();
        }
        RuntimeClasspathProviderWrapper[] rth = new RuntimeClasspathProviderWrapper[runtimeClasspathProviders.size()];
        runtimeClasspathProviders.toArray(rth);
        return rth;
    }

    public static RuntimeClasspathProviderWrapper findRuntimeClasspathProvider(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeClasspathProviders == null) {
            JavaServerPlugin.loadRuntimeClasspathProviders();
        }
        Iterator iterator = runtimeClasspathProviders.iterator();
        while (iterator.hasNext()) {
            RuntimeClasspathProviderWrapper runtimeClasspathProvider = (RuntimeClasspathProviderWrapper)iterator.next();
            if (!runtimeClasspathProvider.supportsRuntimeType(runtimeType)) continue;
            return runtimeClasspathProvider;
        }
        return null;
    }

    public static RuntimeClasspathProviderWrapper findRuntimeClasspathProvider(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeClasspathProviders == null) {
            JavaServerPlugin.loadRuntimeClasspathProviders();
        }
        Iterator iterator = runtimeClasspathProviders.iterator();
        while (iterator.hasNext()) {
            RuntimeClasspathProviderWrapper runtimeClasspathProvider = (RuntimeClasspathProviderWrapper)iterator.next();
            if (!id.equals(runtimeClasspathProvider.getId())) continue;
            return runtimeClasspathProvider;
        }
        return null;
    }

    private static synchronized void loadRuntimeClasspathProviders() {
        if (runtimeClasspathProviders != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "->- Loading .runtimeClasspathProviders extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "runtimeClasspathProviders");
        int size = cf.length;
        runtimeClasspathProviders = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                RuntimeClasspathProviderWrapper runtimeClasspathProvider = new RuntimeClasspathProviderWrapper(cf[i]);
                runtimeClasspathProviders.add(runtimeClasspathProvider);
                Trace.trace(Trace.CONFIG, "  Loaded runtimeClasspathProviders: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load runtimeClasspathProviders: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        Trace.trace(Trace.CONFIG, "-<- Done loading .runtimeClasspathProviders extension point -<-");
    }

    public static RuntimeFacetMapping[] getRuntimeFacetMapping() {
        if (runtimeFacetMappings == null) {
            JavaServerPlugin.loadRuntimeFacetMapping();
        }
        RuntimeFacetMapping[] rfm = new RuntimeFacetMapping[runtimeFacetMappings.size()];
        runtimeFacetMappings.toArray(rfm);
        return rfm;
    }

    private static synchronized void loadRuntimeFacetMapping() {
        if (runtimeFacetMappings != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "->- Loading .runtimeFacetMapping extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "runtimeFacetMappings");
        int size = cf.length;
        runtimeFacetMappings = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                RuntimeFacetMapping rfm = new RuntimeFacetMapping(cf[i]);
                runtimeFacetMappings.add(rfm);
                Trace.trace(Trace.CONFIG, "  Loaded runtimeFacetMapping: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load runtimeFacetMapping: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        Trace.trace(Trace.CONFIG, "-<- Done loading .runtimeFacetMapping extension point -<-");
    }
}

