/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.jst.server.core.internal.RuntimeFacetMapping;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeBridge;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Runtime;

public class RuntimeBridge
implements IRuntimeBridge {
    protected static final String CLASSPATH = "classpath";
    protected static Map mappings = new HashMap();

    static {
        RuntimeBridge.initialize();
    }

    private static void addMapping(String id, String id2, String version) {
        try {
            mappings.put(id, RuntimeManager.getRuntimeComponentType((String)id2).getVersion(version));
        }
        catch (Exception exception) {}
    }

    private static void initialize() {
        RuntimeFacetMapping[] rfms = JavaServerPlugin.getRuntimeFacetMapping();
        int size = rfms.length;
        int i = 0;
        while (i < size) {
            RuntimeBridge.addMapping(rfms[i].getRuntimeTypeId(), rfms[i].getRuntimeComponent(), rfms[i].getVersion());
            ++i;
        }
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.weblogic81", "org.eclipse.jst.server.generic.runtime.weblogic", "8.1");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.weblogic90", "org.eclipse.jst.server.generic.runtime.weblogic", "9.0");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.jboss323", "org.eclipse.jst.server.generic.runtime.jboss", "3.2.3");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.jonas4", "org.eclipse.jst.server.generic.runtime.jonas", "4.0");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.oracle1013", "org.eclipse.jst.server.generic.runtime.oracle", "10.1.3");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.websphere.6", "org.eclipse.jst.server.generic.runtime.websphere", "6.0");
    }

    public Set getExportedRuntimeNames() throws CoreException {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        HashSet<String> result = new HashSet<String>(runtimes.length);
        int i = 0;
        while (i < runtimes.length) {
            IRuntime runtime = runtimes[i];
            IRuntimeType runtimeType = runtime.getRuntimeType();
            if (runtimeType != null && mappings.containsKey(runtimeType.getId())) {
                result.add(runtime.getName());
            }
            ++i;
        }
        return result;
    }

    public IRuntimeBridge.IStub bridge(String name) throws CoreException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (runtimes[i].getName().equals(name)) {
                return new Stub(runtimes[i]);
            }
            ++i;
        }
        return null;
    }

    private static class Stub
    implements IRuntimeBridge.IStub {
        private IRuntime runtime;
        protected int timestamp = -1;
        protected IVMInstall vmInstall;
        protected String jvmver;
        static /* synthetic */ Class class$0;

        public Stub(IRuntime runtime) {
            this.runtime = runtime;
        }

        /*
         * WARNING - void declaration
         */
        public List getRuntimeComponents() {
            IJavaRuntime javaRuntime;
            ArrayList<IRuntimeComponent> components = new ArrayList<IRuntimeComponent>(2);
            if (this.runtime == null) {
                return components;
            }
            String typeId = this.runtime.getRuntimeType().getId();
            IRuntimeComponentVersion mapped = (IRuntimeComponentVersion)mappings.get(typeId);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (this.runtime.getLocation() != null) {
                properties.put("location", this.runtime.getLocation().toPortableString());
            } else {
                properties.put("location", "");
            }
            properties.put("name", this.runtime.getName());
            properties.put("type", this.runtime.getRuntimeType().getName());
            properties.put("id", this.runtime.getId());
            RuntimeClasspathProviderWrapper rcpw = JavaServerPlugin.findRuntimeClasspathProvider(this.runtime.getRuntimeType());
            if (rcpw != null) {
                Path path = new Path("org.eclipse.jst.server.core.container");
                path = path.append(rcpw.getId()).append(this.runtime.getId());
                properties.put(RuntimeBridge.CLASSPATH, path.toPortableString());
            }
            components.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)mapped, properties));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IJavaRuntime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((javaRuntime = (IJavaRuntime)this.runtime.loadAdapter((Class)clazz, null)) != null) {
                void var7_7;
                IRuntimeComponentVersion rcv;
                if (this.timestamp != ((Runtime)this.runtime).getTimestamp()) {
                    this.vmInstall = null;
                    this.jvmver = null;
                    this.timestamp = ((Runtime)this.runtime).getTimestamp();
                }
                if (this.vmInstall == null) {
                    this.vmInstall = javaRuntime.getVMInstall();
                }
                if (this.jvmver == null) {
                    IVMInstall2 vmInstall2 = (IVMInstall2)this.vmInstall;
                    this.jvmver = vmInstall2.getJavaVersion();
                }
                if (this.jvmver == null || this.jvmver.startsWith("1.4")) {
                    rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("1.4");
                } else if (this.jvmver.startsWith("1.3")) {
                    rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("1.3");
                } else if (this.jvmver.startsWith("1.5")) {
                    rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("5.0");
                } else {
                    throw new IllegalStateException();
                }
                properties = new HashMap();
                properties.put("name", this.vmInstall.getName());
                Path path = new Path(JavaRuntime.JRE_CONTAINER);
                path = path.append(this.vmInstall.getVMInstallType().getId()).append(this.vmInstall.getName());
                properties.put(RuntimeBridge.CLASSPATH, path.toPortableString());
                components.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)var7_7, properties));
            }
            return components;
        }

        public Map getProperties() {
            if (this.runtime == null) {
                return new HashMap(0);
            }
            return Collections.singletonMap("id", this.runtime.getId());
        }
    }
}

