/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.wst.server.core.IRuntime;

public class RuntimeClasspathContainer
implements IClasspathContainer {
    public static final String SERVER_CONTAINER = "org.eclipse.jst.server.core.container";
    private IPath path;
    private RuntimeClasspathProviderWrapper delegate;
    private IRuntime runtime;
    private String id;

    public RuntimeClasspathContainer(IPath path, RuntimeClasspathProviderWrapper delegate, IRuntime runtime, String id) {
        this.path = path;
        this.delegate = delegate;
        this.runtime = runtime;
        this.id = id;
    }

    public IClasspathEntry[] getClasspathEntries() {
        IClasspathEntry[] entries = null;
        if (this.delegate != null && this.runtime != null) {
            entries = this.delegate.resolveClasspathContainerImpl(this.runtime, this.id);
        }
        if (entries == null) {
            return new IClasspathEntry[0];
        }
        return entries;
    }

    public String getDescription() {
        String s;
        if (this.runtime != null && this.delegate != null && (s = this.delegate.getClasspathContainerLabel(this.runtime, this.id)) != null) {
            return s;
        }
        return Messages.classpathContainerDescription;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }
}

