/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.server.core.RuntimeClasspathProviderDelegate;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;

public class RuntimeClasspathProviderWrapper {
    private IConfigurationElement element;
    private RuntimeClasspathProviderDelegate delegate;

    public RuntimeClasspathProviderWrapper(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getOrder() {
        try {
            String o = this.element.getAttribute("order");
            return Integer.parseInt(o);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String[] getRuntimeTypeIds() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.element.getAttribute("runtimeTypeIds"), ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (str == null || str.length() <= 0) continue;
                list.add(str.trim());
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Could not parse runtime type ids: " + this.element);
            return null;
        }
    }

    public boolean supportsRuntimeType(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            return false;
        }
        String id = runtimeType.getId();
        if (id == null || id.length() == 0) {
            return false;
        }
        String[] s = this.getRuntimeTypeIds();
        if (s == null) {
            return false;
        }
        int size = s.length;
        int i = 0;
        while (i < size) {
            if (s[i].endsWith("*") ? id.length() >= s[i].length() && id.startsWith(s[i].substring(0, s[i].length() - 1)) : id.equals(s[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public RuntimeClasspathProviderDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (RuntimeClasspathProviderDelegate)this.element.createExecutableExtension("class");
                this.delegate.initialize(this.getId());
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "Could not create delegate " + this.toString() + ": " + t.getMessage());
            }
        }
        return this.delegate;
    }

    public IClasspathEntry[] resolveClasspathContainerImpl(IRuntime runtime, String id) {
        if (runtime == null) {
            return null;
        }
        try {
            return this.getDelegate().resolveClasspathContainerImpl(runtime, id);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate " + this.toString() + ": " + e.getMessage());
            return null;
        }
    }

    public String getClasspathContainerLabel(IRuntime runtime, String id) {
        if (runtime == null) {
            return "n/a";
        }
        try {
            return this.getDelegate().getClasspathContainerLabel(runtime, id);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate " + this.toString() + ": " + e.getMessage());
            return "n/a";
        }
    }

    public void requestClasspathContainerUpdate(IRuntime runtime, String id, IClasspathEntry[] entries) {
        if (runtime == null) {
            return;
        }
        try {
            this.getDelegate().requestClasspathContainerUpdate(runtime, id, entries);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate " + this.toString() + ": " + e.getMessage());
        }
    }

    public String toString() {
        return "RuntimeClasspathProviderWrapper[" + this.getId() + "]";
    }
}

