/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.actions.SyncAction;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.CompareParticipant;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class CompareWithTagAction
extends WorkspaceTraversalAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        CVSCompareSubscriber compareSubscriber;
        IResource[] resources = this.getSelectedResources();
        CVSTag tag = this.promptForTag(resources);
        if (tag == null) {
            return;
        }
        if (CompareWithTagAction.isLogicalModel(this.getCVSResourceMappings())) {
            compareSubscriber = new CVSCompareSubscriber(CompareWithTagAction.getProjects(resources), tag);
            resources = this.getResourcesToCompare((Subscriber)compareSubscriber);
            compareSubscriber.dispose();
        }
        compareSubscriber = new CVSCompareSubscriber(resources, tag);
        if (SyncAction.isSingleFile(resources)) {
            SyncAction.showSingleFileComparison(this.getShell(), (Subscriber)compareSubscriber, resources[0], this.getTargetPage());
            compareSubscriber.dispose();
        } else {
            try {
                compareSubscriber.primeRemoteTree();
            }
            catch (CVSException cVSException) {}
            CompareParticipant participant = CompareParticipant.getMatchingParticipant(resources, tag);
            if (participant == null) {
                CVSCompareSubscriber s = compareSubscriber;
                participant = new CompareParticipant(s);
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            }
            participant.refresh(resources, null, null, null);
        }
    }

    protected CVSTag promptForTag(IResource[] resources) {
        CVSTag tag = TagSelectionDialog.getTagToCompareWith(this.getShell(), TagSource.create(resources), 31);
        return tag;
    }

    protected boolean isEnabledForNonExistantResources() {
        return true;
    }
}

