/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.ui.internal.editor.IOrdered;
import org.eclipse.wst.server.ui.internal.wizard.page.TasksComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class TasksWizardFragment
extends WizardFragment {
    protected TasksComposite comp;
    protected List tasks;
    protected boolean hasOptionalTasks;
    protected Map selectedTaskMap = new HashMap();

    public void enter() {
        this.updateTasks();
        if (this.comp != null) {
            this.comp.createControl();
        }
    }

    public List getChildFragments() {
        this.updateTasks();
        return super.getChildFragments();
    }

    public void setTaskModel(TaskModel taskModel) {
        super.setTaskModel(taskModel);
        this.updateTasks();
    }

    public void updateTasks() {
        this.tasks = null;
        if (this.getTaskModel() == null) {
            return;
        }
        IServer server = (IServer)this.getTaskModel().getObject("server");
        ArrayList modules = (ArrayList)this.getTaskModel().getObject("modules");
        if (server != null && modules == null) {
            final ArrayList moduleList = new ArrayList();
            ((Server)server).visit(new IModuleVisitor(){

                public boolean visit(IModule[] module2) {
                    moduleList.add(module2);
                    return true;
                }
            }, null);
            modules = moduleList;
        }
        if (server != null && modules != null) {
            this.tasks = new ArrayList();
            this.createTasks(server, modules);
        }
        if (this.comp != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    TasksWizardFragment.this.comp.setTasks(TasksWizardFragment.this.tasks);
                }
            });
        }
    }

    protected void createTasks(IServer server, List modules) {
        if (server == null) {
            return;
        }
        List enabledTasks = ((Server)server).getEnabledOptionalPublishOperationIds();
        List disabledTasks = ((Server)server).getDisabledPreferredPublishOperationIds();
        PublishOperation[] tasks2 = ((Server)server).getAllTasks(modules);
        int j = 0;
        while (j < tasks2.length) {
            int kind = tasks2[j].getKind();
            String id = ((Server)server).getPublishOperationId(tasks2[j]);
            if (kind == 0 || kind == 1) {
                this.hasOptionalTasks = true;
            }
            tasks2[j].setTaskModel(this.getTaskModel());
            boolean selected = true;
            if (kind == 0) {
                if (!enabledTasks.contains(id)) {
                    selected = false;
                }
            } else if (kind == 1 && disabledTasks.contains(id)) {
                selected = false;
            }
            this.addServerTask(server, tasks2[j], selected);
            ++j;
        }
    }

    public void addServerTask(IServer server, PublishOperation task2, boolean selected) {
        TaskInfo sti = new TaskInfo();
        sti.task2 = task2;
        sti.kind = task2.getKind();
        sti.id = ((Server)server).getPublishOperationId(task2);
        sti.setDefaultSelected(selected);
        this.tasks.add(sti);
    }

    public boolean hasComposite() {
        return this.hasTasks();
    }

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        this.comp = new TasksComposite(parent, wizard);
        return this.comp;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (!this.hasOptionalTasks) {
            return;
        }
        if (this.tasks == null || this.tasks.isEmpty()) {
            return;
        }
        TaskModel taskModel = this.getTaskModel();
        IServer server = (IServer)taskModel.getObject("server");
        if (server == null) {
            return;
        }
        boolean createdWC = false;
        ServerWorkingCopy wc = null;
        if (server instanceof ServerWorkingCopy) {
            wc = (ServerWorkingCopy)server;
        } else {
            wc = (ServerWorkingCopy)server.createWorkingCopy();
            createdWC = true;
        }
        wc.resetPreferredPublishOperations();
        wc.resetOptionalPublishOperations();
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            TaskInfo task = (TaskInfo)iterator.next();
            if (2 == task.kind) continue;
            if (1 == task.kind) {
                if (task.isSelected()) continue;
                wc.disablePreferredPublishOperations(task.task2);
                continue;
            }
            if (task.kind != 0 || !task.isSelected()) continue;
            wc.enableOptionalPublishOperations(task.task2);
        }
        if (createdWC && wc.isDirty()) {
            wc.save(true, monitor);
        }
        monitor.done();
    }

    public boolean hasTasks() {
        return this.tasks == null || !this.tasks.isEmpty();
    }

    public boolean hasOptionalTasks() {
        return this.hasOptionalTasks;
    }

    public class TaskInfo
    implements IOrdered {
        public int kind;
        public String id;
        public PublishOperation task2;
        private static final String DEFAULT = "default:";

        public boolean isSelected() {
            if (this.id == null) {
                return false;
            }
            if (TasksWizardFragment.this.selectedTaskMap.containsKey(this.id)) {
                return (Boolean)TasksWizardFragment.this.selectedTaskMap.get(this.id);
            }
            if (TasksWizardFragment.this.selectedTaskMap.containsKey(DEFAULT + this.id)) {
                return (Boolean)TasksWizardFragment.this.selectedTaskMap.get(DEFAULT + this.id);
            }
            return false;
        }

        public void setDefaultSelected(boolean sel) {
            TasksWizardFragment.this.selectedTaskMap.put(DEFAULT + this.getId(), new Boolean(sel));
        }

        public boolean getDefaultSelected() {
            return (Boolean)TasksWizardFragment.this.selectedTaskMap.get(DEFAULT + this.id);
        }

        public void setSelected(boolean sel) {
            TasksWizardFragment.this.selectedTaskMap.put(this.getId(), new Boolean(sel));
        }

        public int getOrder() {
            return this.task2.getOrder();
        }

        protected String getId() {
            return this.id;
        }
    }
}

