/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.web.operations.ProjectSupportResourceHandler;

public class RelationData {
    protected Hashtable inLinksTable = new Hashtable(100);
    protected Hashtable anchorsTable = new Hashtable(10);
    private static final int INIT_HASH_TABLE_SIZE = 100;
    private static final int INIT_ANCHORS_HASH_TABLE_SIZE = 10;
    private boolean fileOk = false;
    private static final String LINK_STATE_FILE_NAME = "link_table_states.txt";
    private static final String LINK_SERVERCONTEXTROOT_FILE_NAME = "link_scr_states.txt";
    public static final String LINK_MISSING_FILE = "-";
    public static final String LINK_INDEX_SEPARATOR = "+";
    public static final String ANCHOR_INDEX_SEPARATOR = "#";
    public static final String LINK_OCCURENCE_SEPARATOR = "/";
    public static final String ANCHOR_SEPARATOR = "#### ANCHORS ####";

    public Link addInLink(String file_path, String parent_path, int occurence) {
        Vector in_links = (Vector)this.inLinksTable.get(file_path);
        if (in_links == null) {
            return null;
        }
        int i = 0;
        while (i < in_links.size()) {
            Link inlnk = (Link)in_links.elementAt(i);
            String url = inlnk.getURL();
            if (url.compareTo(parent_path) == 0) {
                inlnk.addOccurrence(occurence);
                return inlnk;
            }
            ++i;
        }
        Link inlnk = new Link(parent_path, occurence);
        in_links.addElement(inlnk);
        return inlnk;
    }

    public void changeInLink(String filePath, boolean missing) {
        if (missing) {
            Vector inlinks = (Vector)this.inLinksTable.remove(filePath);
            this.inLinksTable.put(LINK_MISSING_FILE + filePath, inlinks);
        } else {
            Vector inlinks = (Vector)this.inLinksTable.remove(LINK_MISSING_FILE + filePath);
            this.inLinksTable.put(filePath, inlinks);
        }
    }

    public Collection getDependentProjects(String file_path) {
        Hashtable<String, String> outProjects = new Hashtable<String, String>();
        Vector in_links = (Vector)this.inLinksTable.get(file_path);
        if (in_links != null) {
            int i = 0;
            while (i < in_links.size()) {
                Link inlnk = (Link)in_links.elementAt(i);
                String url = inlnk.getURL();
                if (url.length() > 0) {
                    int index = 0;
                    int offset = 1;
                    if (url.charAt(0) == '-') {
                        index = url.indexOf(47, 2);
                        offset = 2;
                    } else {
                        index = url.indexOf(47, 1);
                        offset = 1;
                    }
                    if (index != -1) {
                        String projName = url.substring(offset, index);
                        outProjects.put(projName, projName);
                    }
                }
                ++i;
            }
        }
        return outProjects.values();
    }

    public Collection getDependentProjectFiles(String projName) {
        Hashtable<String, String> outProjects = new Hashtable<String, String>();
        Enumeration aenum = this.inLinksTable.keys();
        while (aenum.hasMoreElements()) {
            String currentProjName;
            int index;
            String path = (String)aenum.nextElement();
            if (path.length() <= 0 || path.charAt(0) == '-' || (index = path.indexOf(47, 1)) == -1 || (currentProjName = path.substring(1, index)).equals(projName)) continue;
            outProjects.put(path, path);
        }
        return outProjects.values();
    }

    public void createInLinkEntry(String file_path, String parent_path, int occurence) {
        Vector<Link> in_links = new Vector<Link>();
        Link inlnk = new Link(parent_path, occurence);
        in_links.addElement(inlnk);
        this.inLinksTable.put(file_path, in_links);
    }

    public void dump() {
    }

    public void dump(boolean dump) {
        if (dump && this.inLinksTable != null) {
            Enumeration aenum = this.inLinksTable.keys();
            while (aenum.hasMoreElements()) {
                StringBuffer St = new StringBuffer();
                String key = (String)aenum.nextElement();
                St.append("\nKey=" + key + "\n");
                Vector in_links = (Vector)this.inLinksTable.get(key);
                int nb_of_links = in_links.size();
                int i = 0;
                while (i < nb_of_links) {
                    Link lnk = (Link)in_links.elementAt(i);
                    St.append("\tValue=" + lnk.getURL() + "[" + lnk.getOccurrences() + "]");
                    ++i;
                }
                Logger.getLogger().logError(St.toString());
            }
        }
    }

    public void dump2() {
        if (this.inLinksTable != null) {
            Enumeration aenum = this.inLinksTable.keys();
            while (aenum.hasMoreElements()) {
                StringBuffer St = new StringBuffer();
                String key = (String)aenum.nextElement();
                Vector in_links = (Vector)this.inLinksTable.get(key);
                int nb_of_links = in_links.size();
                St.append("\nKey=" + key + " -- num:" + nb_of_links + "\n");
                int i = 0;
                while (i < nb_of_links) {
                    Link lnk = (Link)in_links.elementAt(i);
                    St.append("\tValue=" + lnk.getURL() + "[" + lnk.getOccurrences() + "]");
                    ++i;
                }
                System.out.println(St.toString());
            }
        }
        System.out.println("************************************************\n\n\n\n************************************\n");
    }

    public Vector getInLinks(String filePath) {
        return (Vector)this.inLinksTable.get(filePath);
    }

    public void getInLinks(String filePath, Vector vectInLinks) {
        if (this.inLinksTable != null) {
            this.dump();
            Vector in_links = (Vector)this.inLinksTable.get(filePath);
            if (in_links != null) {
                int i = 0;
                while (i < in_links.size()) {
                    Link inlnk = (Link)((Link)in_links.elementAt(i)).clone();
                    vectInLinks.addElement(inlnk);
                    ++i;
                }
            }
        }
    }

    public Hashtable getAnchorsTable() {
        return this.anchorsTable;
    }

    public static File getPreviousSCRFile(IProject project) {
        return new Path(String.valueOf(J2EEPlugin.getDefault().getStateLocation().toString()) + File.separator + project.getName() + File.separator + LINK_SERVERCONTEXTROOT_FILE_NAME).toFile();
    }

    private File getStateFile(IProject project) {
        return new Path(String.valueOf(J2EEPlugin.getDefault().getStateLocation().toString()) + File.separator + project.getName() + File.separator + LINK_STATE_FILE_NAME).toFile();
    }

    public boolean hasInLinkEntry(String path) {
        return this.inLinksTable.containsKey(path);
    }

    public Vector getPossibleMissingEndingMatches(IPath classPath) {
        Vector<String> v = new Vector<String>();
        String match = classPath.lastSegment();
        match = match.substring(0, match.length() - 6);
        String classPathStr = classPath.toString();
        String matchingClassPath = classPathStr.toString().substring(0, classPathStr.length() - 6);
        Enumeration aenum = this.inLinksTable.keys();
        while (aenum.hasMoreElements()) {
            int index;
            String linkPath;
            String closeMatch;
            String path = (String)aenum.nextElement();
            if (!path.startsWith(LINK_MISSING_FILE) || !path.endsWith(match) || !matchingClassPath.endsWith(closeMatch = (linkPath = (index = path.lastIndexOf(47)) != -1 && index < path.length() - 1 ? path.substring(index + 1) : path).replace('.', '/'))) continue;
            Vector in_links = (Vector)this.inLinksTable.get(path);
            String nonMissingPath = path.substring(1, path.length());
            this.changeInLink(nonMissingPath, false);
            if (in_links == null) continue;
            int i = 0;
            while (i < in_links.size()) {
                Link inlnk = (Link)in_links.elementAt(i);
                String url = inlnk.getURL();
                v.add(url);
                ++i;
            }
        }
        return v;
    }

    public Vector getPossibleExistingEndingMatches(IPath classPath) {
        Vector<String> v = new Vector<String>();
        String match = classPath.lastSegment();
        match = match.substring(0, match.length() - 6);
        String classPathStr = classPath.toString();
        String matchingClassPath = classPathStr.toString().substring(0, classPathStr.length() - 6);
        Enumeration aenum = this.inLinksTable.keys();
        while (aenum.hasMoreElements()) {
            int index;
            String linkPath;
            String closeMatch;
            String path = (String)aenum.nextElement();
            if (!path.endsWith(match) || path.startsWith(LINK_MISSING_FILE) || !matchingClassPath.endsWith(closeMatch = (linkPath = (index = path.lastIndexOf(47)) != -1 && index < path.length() - 1 ? path.substring(index + 1) : path).replace('.', '/'))) continue;
            Vector in_links = (Vector)this.inLinksTable.get(path);
            this.changeInLink(path, true);
            if (in_links == null) continue;
            int i = 0;
            while (i < in_links.size()) {
                Link inlnk = (Link)in_links.elementAt(i);
                String url = inlnk.getURL();
                v.add(url);
                ++i;
            }
        }
        return v;
    }

    public void removeInLinksPossibleExistingEndingMatches(IPath classPath) {
        String match = classPath.lastSegment();
        match = match.substring(0, match.length() - 6);
        String classPathStr = classPath.toString();
        String matchingClassPath = classPathStr.toString().substring(0, classPathStr.length() - 6);
        Enumeration aenum = this.inLinksTable.keys();
        while (aenum.hasMoreElements()) {
            int index;
            String linkPath;
            String closeMatch;
            String path = (String)aenum.nextElement();
            if (!path.endsWith(match) || path.startsWith(LINK_MISSING_FILE) || !matchingClassPath.endsWith(closeMatch = (linkPath = (index = path.lastIndexOf(47)) != -1 && index < path.length() - 1 ? path.substring(index + 1) : path).replace('.', '/'))) continue;
            this.removeInLinks(path);
        }
    }

    public void initialize() {
        this.inLinksTable = new Hashtable(100);
        this.anchorsTable = new Hashtable(10);
    }

    public void initializeAnchors() {
        this.anchorsTable = new Hashtable(10);
    }

    public void initializeInLinks() {
        this.inLinksTable = new Hashtable(100);
    }

    public boolean isFileOk() {
        return this.fileOk;
    }

    public boolean isInitialized() {
        return this.inLinksTable != null;
    }

    public void newInLinkEntry(String path) {
        if (!this.inLinksTable.containsKey(path)) {
            this.inLinksTable.put(path, new Vector());
        }
    }

    public void removeInLinks(String file_path) {
        Enumeration aenum = this.inLinksTable.keys();
        while (aenum.hasMoreElements()) {
            String key = (String)aenum.nextElement();
            Vector in_links = (Vector)this.inLinksTable.get(key);
            int i = 0;
            while (i < in_links.size()) {
                Link inlnk = (Link)in_links.elementAt(i);
                String url = inlnk.getURL();
                if (url.compareTo(file_path) == 0) {
                    in_links.removeElementAt(i);
                    break;
                }
                ++i;
            }
            if (!in_links.isEmpty() || !key.startsWith(LINK_MISSING_FILE)) continue;
            this.inLinksTable.remove(key);
        }
    }

    public List getOutLinks(String file_path) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration aenum = this.inLinksTable.keys();
        block0: while (aenum.hasMoreElements()) {
            String key = (String)aenum.nextElement();
            Vector in_links = (Vector)this.inLinksTable.get(key);
            int i = 0;
            while (i < in_links.size()) {
                Link inlnk = (Link)in_links.elementAt(i);
                String url = inlnk.getURL();
                if (url.compareTo(file_path) == 0) {
                    list.add(key);
                    continue block0;
                }
                ++i;
            }
        }
        return list;
    }

    public boolean referencedByOtherLinks(String file_path) {
        boolean referenced = false;
        Enumeration aenum = this.inLinksTable.keys();
        block0: while (!referenced && aenum.hasMoreElements()) {
            String key = (String)aenum.nextElement();
            Vector in_links = (Vector)this.inLinksTable.get(key);
            int i = 0;
            while (i < in_links.size()) {
                Link inlnk = (Link)in_links.elementAt(i);
                String url = inlnk.getURL();
                if (url.compareTo(file_path) == 0) {
                    referenced = true;
                    continue block0;
                }
                ++i;
            }
        }
        return referenced;
    }

    public Collection removeInLinksForProjects(String file_path) {
        Hashtable<String, String> projects = new Hashtable<String, String>();
        Enumeration aenum = this.inLinksTable.keys();
        while (aenum.hasMoreElements()) {
            String key = (String)aenum.nextElement();
            Vector in_links = (Vector)this.inLinksTable.get(key);
            int i = 0;
            while (i < in_links.size()) {
                Link inlnk = (Link)in_links.elementAt(i);
                String url = inlnk.getURL();
                if (url.compareTo(file_path) == 0) {
                    if (key.length() > 0) {
                        int index = 0;
                        int offset = 1;
                        if (key.charAt(0) == '-') {
                            index = key.indexOf(47, 2);
                            offset = 2;
                        } else {
                            index = key.indexOf(47, 1);
                            offset = 1;
                        }
                        if (index != -1) {
                            String projName = key.substring(offset, index);
                            projects.put(projName, projName);
                        }
                    }
                    in_links.removeElementAt(i);
                    break;
                }
                ++i;
            }
            if (!in_links.isEmpty() || !key.startsWith(LINK_MISSING_FILE)) continue;
            this.inLinksTable.remove(key);
        }
        return projects.values();
    }

    public Collection removeInLinksAndGetDependentProjects(String file_path) {
        Hashtable<String, String> projects = new Hashtable<String, String>();
        Enumeration aenum = this.inLinksTable.keys();
        while (aenum.hasMoreElements()) {
            String key = (String)aenum.nextElement();
            Vector in_links = (Vector)this.inLinksTable.get(key);
            if (key.equals(LINK_MISSING_FILE + file_path)) {
                int index = -1;
                int i = 0;
                while (i < in_links.size()) {
                    int projindex;
                    Link inlnk = (Link)in_links.elementAt(i);
                    String url = inlnk.getURL();
                    if (url.compareTo(file_path) == 0) {
                        index = i;
                    }
                    if (url.length() > 1 && (projindex = url.indexOf(47, 1)) != -1) {
                        String projName = url.substring(1, projindex);
                        projects.put(projName, projName);
                    }
                    ++i;
                }
                if (index != -1) {
                    in_links.removeElementAt(index);
                }
            } else {
                int i = 0;
                while (i < in_links.size()) {
                    Link inlnk = (Link)in_links.elementAt(i);
                    String url = inlnk.getURL();
                    if (url.compareTo(file_path) == 0) {
                        in_links.removeElementAt(i);
                        break;
                    }
                    ++i;
                }
            }
            if (!in_links.isEmpty() || !key.startsWith(LINK_MISSING_FILE)) continue;
            this.inLinksTable.remove(key);
        }
        return projects.values();
    }

    public void removeInLinks(String inLinkEntry, String inLinkReference, boolean removeOrphan) {
        String key = inLinkEntry;
        Vector in_links = (Vector)this.inLinksTable.get(key);
        int i = 0;
        while (i < in_links.size()) {
            Link inlnk = (Link)in_links.elementAt(i);
            String url = inlnk.getURL();
            if (url.compareTo(inLinkReference) == 0) {
                in_links.removeElementAt(i);
                break;
            }
            ++i;
        }
        if (in_links.isEmpty() && removeOrphan) {
            this.inLinksTable.remove(key);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean restore(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 249->252)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void save(IProject project) {
        File stateFile = this.getStateFile(project);
        if (this.inLinksTable == null) {
            stateFile.delete();
        } else {
            Vector index_vector = new Vector(this.inLinksTable.size());
            Enumeration aenum = this.inLinksTable.keys();
            while (aenum.hasMoreElements()) {
                index_vector.addElement(aenum.nextElement());
            }
            try {
                File parentFolder = stateFile.getParentFile();
                if (!parentFolder.exists()) {
                    parentFolder.mkdirs();
                }
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(stateFile)));
                Enumeration aenum2 = this.inLinksTable.keys();
                while (aenum2.hasMoreElements()) {
                    String key = (String)aenum2.nextElement();
                    out.print(key);
                    out.println();
                    out.print(LINK_INDEX_SEPARATOR);
                    Vector in_links = (Vector)this.inLinksTable.get(key);
                    int nb_of_links = in_links.size();
                    Link lnk = null;
                    int nb_lnks = 0;
                    if (nb_of_links > 0) {
                        lnk = (Link)in_links.elementAt(0);
                        out.print(index_vector.indexOf(lnk.getURL()));
                        nb_lnks = lnk.getOccurrences();
                        if (nb_lnks > 1) {
                            out.print(LINK_OCCURENCE_SEPARATOR);
                            out.print(nb_lnks);
                        }
                        int i = 1;
                        while (i < nb_of_links) {
                            out.print(LINK_INDEX_SEPARATOR);
                            lnk = (Link)in_links.elementAt(i);
                            out.print(index_vector.indexOf(lnk.getURL()));
                            nb_lnks = lnk.getOccurrences();
                            if (nb_lnks > 1) {
                                out.print(LINK_OCCURENCE_SEPARATOR);
                                out.print(nb_lnks);
                            }
                            ++i;
                        }
                    }
                    out.println();
                }
                out.flush();
                out.close();
            }
            catch (IOException iOException) {
                Logger.getLogger().logError(ProjectSupportResourceHandler.Error_while_saving_links_s_EXC_);
            }
        }
    }

    void setFileOk(boolean newFileOk) {
        this.fileOk = newFileOk;
    }

    public class Link
    implements Cloneable {
        private String url;
        private int occurrences = 0;

        public Link(String newUrl, int occ) {
            this.url = newUrl;
            this.occurrences = occ;
        }

        public Object clone() {
            return new Link(this.url, this.occurrences);
        }

        public String getURL() {
            return this.url;
        }

        public int getOccurrences() {
            return this.occurrences;
        }

        private int addOccurrence(int add) {
            this.occurrences += add;
            return this.occurrences;
        }

        public String toString() {
            return this.url;
        }
    }
}

