/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public interface IFacetedProject {
    public IProject getProject();

    public Set getProjectFacets();

    public boolean hasProjectFacet(IProjectFacet var1);

    public boolean hasProjectFacet(IProjectFacetVersion var1);

    public IProjectFacetVersion getInstalledVersion(IProjectFacet var1);

    public void installProjectFacet(IProjectFacetVersion var1, Object var2, IProgressMonitor var3) throws CoreException;

    public void uninstallProjectFacet(IProjectFacetVersion var1, Object var2, IProgressMonitor var3) throws CoreException;

    public void modify(Set var1, IProgressMonitor var2) throws CoreException;

    public Set getFixedProjectFacets();

    public void setFixedProjectFacets(Set var1) throws CoreException;

    public IRuntime getRuntime();

    public void setRuntime(IRuntime var1, IProgressMonitor var2) throws CoreException;

    public void addListener(IFacetedProjectListener var1);

    public void removeListener(IFacetedProjectListener var1);

    public static final class Action {
        private final Type type;
        private final IProjectFacetVersion fv;
        private final Object config;

        public Action(Type type, IProjectFacetVersion fv, Object config) {
            if (type == null || fv == null) {
                throw new IllegalArgumentException();
            }
            this.type = type;
            this.fv = fv;
            this.config = config;
        }

        public Type getType() {
            return this.type;
        }

        public IProjectFacetVersion getProjectFacetVersion() {
            return this.fv;
        }

        public Object getConfig() {
            return this.config;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Action)) {
                return false;
            }
            Action action = (Action)obj;
            return this.type == action.type && this.fv.equals(action.fv);
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.fv.hashCode();
        }

        public String toString() {
            return String.valueOf(this.type.toString()) + "[" + this.fv.toString() + "]";
        }

        public static final class Type {
            public static final Type INSTALL = new Type("INSTALL");
            public static final Type UNINSTALL = new Type("UNINSTALL");
            public static final Type VERSION_CHANGE = new Type("VERSION_CHANGE");
            private final String code;

            private Type(String code) {
                this.code = code;
            }

            public String toString() {
                return this.code;
            }
        }
    }
}

