/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.ValidationProblem;
import org.eclipse.wst.common.project.facet.core.internal.VersionMatchExpr;

public final class Constraint
implements IConstraint {
    private final IProjectFacetVersion fv;
    private final IConstraint.Type type;
    private final List operands;

    Constraint(IProjectFacetVersion fv, IConstraint.Type type, Object[] operands) {
        this.fv = fv;
        this.type = type;
        ArrayList<Object> temp = new ArrayList<Object>();
        int i = 0;
        while (i < operands.length) {
            temp.add(operands[i]);
            ++i;
        }
        this.operands = Collections.unmodifiableList(temp);
    }

    public IConstraint.Type getType() {
        return this.type;
    }

    public List getOperands() {
        return this.operands;
    }

    public Object getOperand(int index) {
        return this.operands.get(index);
    }

    public IStatus check(Collection facets) {
        return this.check(facets, false);
    }

    public IStatus check(Collection facets, boolean validateSoftDeps) {
        MultiStatus result = Constraint.createMultiStatus();
        if (this.type == IConstraint.Type.AND) {
            Iterator itr = this.operands.iterator();
            while (itr.hasNext()) {
                IConstraint operand = (IConstraint)itr.next();
                IStatus st = operand.check(facets, validateSoftDeps);
                if (st.getSeverity() == 0) continue;
                result.addAll(st);
            }
        } else if (this.type == IConstraint.Type.OR) {
            boolean someBranchWorks = false;
            Iterator itr = this.operands.iterator();
            while (itr.hasNext()) {
                IConstraint operand = (IConstraint)itr.next();
                if (!operand.check(facets, validateSoftDeps).isOK()) continue;
                someBranchWorks = true;
                break;
            }
            if (!someBranchWorks) {
                ValidationProblem problem = new ValidationProblem(ValidationProblem.Type.COMPLEX, this.fv);
                result.add((IStatus)problem);
            }
        } else if (this.type == IConstraint.Type.REQUIRES) {
            String name = (String)this.operands.get(0);
            String vexprstr = (String)this.operands.get(1);
            boolean soft = (Boolean)this.operands.get(2);
            if (!soft || validateSoftDeps) {
                VersionMatchExpr vexpr;
                IProjectFacet rf = ProjectFacetsManager.getProjectFacet(name);
                try {
                    vexpr = new VersionMatchExpr(rf, vexprstr);
                }
                catch (CoreException e) {
                    FacetCorePlugin.log((Exception)((Object)e));
                    return result;
                }
                boolean found = false;
                Iterator itr = facets.iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                    if (fv.getProjectFacet() != rf) continue;
                    try {
                        if (!vexpr.evaluate((IVersion)((Object)fv))) break;
                        found = true;
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log((Exception)((Object)e));
                    }
                    break;
                }
                if (!found) {
                    String vstr;
                    ValidationProblem.Type ptype;
                    if (vexpr.isSingleVersionMatch()) {
                        ptype = ValidationProblem.Type.REQUIRES_EXACT;
                        vstr = vexpr.toString();
                    } else if (vexpr.isSimpleAllowNewer()) {
                        ptype = ValidationProblem.Type.REQUIRES_ALLOW_NEWER;
                        vstr = vexpr.getFirstVersion();
                    } else {
                        ptype = ValidationProblem.Type.REQUIRES_EXPR;
                        vstr = vexpr.toString();
                    }
                    ValidationProblem problem = new ValidationProblem(ptype, this.fv, rf.getLabel(), vstr);
                    result.add((IStatus)problem);
                }
            }
        } else if (this.type == IConstraint.Type.CONFLICTS) {
            String gid = (String)this.operands.get(0);
            IGroup group = ProjectFacetsManager.getGroup(gid);
            Iterator itr = group.getMembers().iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion member = (IProjectFacetVersion)itr.next();
                if (member == this.fv || !facets.contains(member)) continue;
                ValidationProblem.Type t = ValidationProblem.Type.CONFLICTS;
                ValidationProblem problem = new ValidationProblem(t, this.fv, member);
                result.add((IStatus)problem);
            }
        } else {
            throw new IllegalStateException();
        }
        return result;
    }

    static MultiStatus createMultiStatus() {
        return Constraint.createMultiStatus(new IStatus[0]);
    }

    static MultiStatus createMultiStatus(IStatus[] children) {
        return new MultiStatus("org.eclipse.wst.common.project.facet.core", 0, children, Resources.validationProblems, null);
    }

    private static final class Resources
    extends NLS {
        public static String validationProblems;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.Constraint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.Constraint$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        Resources() {
        }
    }
}

