/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class CopyOnWriteSet
extends AbstractSet {
    private Set base = new HashSet();
    private Set baseReadOnly = null;

    public boolean add(Object obj) {
        this.copy();
        return this.base.add(obj);
    }

    public boolean addAll(Collection collection) {
        this.copy();
        return this.base.addAll(collection);
    }

    public boolean remove(Object obj) {
        this.copy();
        return this.base.remove(obj);
    }

    public boolean removeAll(Collection collection) {
        this.copy();
        return this.base.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        this.copy();
        return this.base.retainAll(collection);
    }

    public void clear() {
        if (this.baseReadOnly != null) {
            this.base = new HashSet();
            this.baseReadOnly = null;
        } else {
            this.base.clear();
        }
    }

    public int size() {
        return this.base.size();
    }

    public Iterator iterator() {
        return new CopyOnWriteIterator(this.base.iterator());
    }

    public Set getReadOnlySet() {
        if (this.baseReadOnly == null) {
            this.baseReadOnly = Collections.unmodifiableSet(this.base);
        }
        return this.baseReadOnly;
    }

    private void copy() {
        if (this.baseReadOnly != null) {
            this.base = new HashSet(this.base);
            this.baseReadOnly = null;
        }
    }

    private final class CopyOnWriteIterator
    implements Iterator {
        private final Iterator itr;
        private Object current;

        public CopyOnWriteIterator(Iterator itr) {
            this.itr = itr;
            this.current = null;
        }

        public void remove() {
            CopyOnWriteSet.this.remove(this.current);
        }

        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            this.current = this.itr.next();
            return this.current;
        }
    }
}

