/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IActionConfig;
import org.eclipse.wst.common.project.facet.core.IActionConfigFactory;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.Constraint;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.internal.Versionable;
import org.osgi.framework.Bundle;

public final class ProjectFacetVersion
implements IProjectFacetVersion,
IVersion {
    private ProjectFacet facet;
    private String version;
    private IConstraint constraint;
    private String plugin;
    private final HashMap delegates = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    ProjectFacetVersion() {
    }

    public IProjectFacet getProjectFacet() {
        return this.facet;
    }

    void setProjectFacet(ProjectFacet facet) {
        this.facet = facet;
    }

    public String getVersionString() {
        return this.version;
    }

    void setVersionString(String version) {
        this.version = version;
    }

    public Versionable getVersionable() {
        return this.facet;
    }

    public IConstraint getConstraint() {
        if (this.constraint == null) {
            this.constraint = new Constraint(this, IConstraint.Type.AND, new Object[0]);
        }
        return this.constraint;
    }

    void setConstraint(IConstraint constraint) {
        this.constraint = constraint;
    }

    void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public boolean supports(IFacetedProject.Action.Type type) {
        try {
            return this.facet.getActionDefinition(this, IDelegate.Type.get(type)) != null;
        }
        catch (CoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
            return false;
        }
    }

    public Object createActionConfig(IFacetedProject.Action.Type type, String pjname) throws CoreException {
        if (!this.supports(type)) {
            String msg = NLS.bind((String)Resources.actionNotSupported, (Object)this.toString(), (Object)type.toString());
            throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
        }
        ProjectFacet.ActionDefinition def = this.facet.getActionDefinition(this, IDelegate.Type.get(type));
        if (def == null || def.configFactoryClassName == null) {
            return null;
        }
        String clname = def.configFactoryClassName;
        Object temp = this.create(clname);
        if (!(temp instanceof IActionConfigFactory)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.IActionConfigFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String msg = NLS.bind((String)Resources.notInstanceOf, (Object)clname, (Object)clazz.getName());
            throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
        }
        Object config = ((IActionConfigFactory)temp).create();
        IActionConfig cfg = null;
        if (config instanceof IActionConfig) {
            cfg = (IActionConfig)config;
        } else {
            IAdapterManager m = Platform.getAdapterManager();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.IActionConfig");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            cfg = (IActionConfig)m.loadAdapter(config, clazz.getName());
        }
        if (cfg != null) {
            cfg.setProjectName(pjname);
            cfg.setVersion(this);
        }
        return config;
    }

    public boolean isSameActionConfig(IFacetedProject.Action.Type type, IProjectFacetVersion fv) throws CoreException {
        IDelegate.Type t = IDelegate.Type.get(type);
        return this.facet.getActionDefinition(fv, t) == this.facet.getActionDefinition(this, t);
    }

    IDelegate getDelegate(IDelegate.Type type) throws CoreException {
        Object delegate = this.delegates.get(type);
        if (delegate == null) {
            ProjectFacet.ActionDefinition def = this.facet.getActionDefinition(this, type);
            if (def == null) {
                return null;
            }
            String clname = def.delegateClassName;
            delegate = this.create(clname);
            if (!(delegate instanceof IDelegate)) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.wst.common.project.facet.core.IDelegate");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String msg = NLS.bind((String)Resources.notInstanceOf, (Object)clname, (Object)clazz.getName());
                throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
            }
            this.delegates.put(type, delegate);
        }
        return (IDelegate)delegate;
    }

    private Object create(String clname) throws CoreException {
        Bundle bundle = Platform.getBundle((String)this.plugin);
        try {
            Class cl = bundle.loadClass(clname);
            return cl.newInstance();
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failedToCreate, (Object)clname);
            IStatus st = FacetCorePlugin.createErrorStatus(msg, e);
            throw new CoreException(st);
        }
    }

    public String toString() {
        return String.valueOf(this.facet.getLabel()) + " " + this.version;
    }

    private static final class Resources
    extends NLS {
        public static String actionNotSupported;
        public static String notInstanceOf;
        public static String failedToCreate;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        Resources() {
        }
    }
}

