/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;

public final class ConflictingFacetsFilter {
    private final Set fixed;

    public ConflictingFacetsFilter(Set fixed) {
        this.fixed = fixed;
    }

    public boolean check(IProjectFacetVersion fv) {
        Iterator itr = this.fixed.iterator();
        while (itr.hasNext()) {
            IProjectFacet f = (IProjectFacet)itr.next();
            if (!f.getVersions().contains(fv)) continue;
            return true;
        }
        return this.check(fv.getConstraint());
    }

    private boolean check(IConstraint op) {
        if (op.getType() == IConstraint.Type.AND) {
            Iterator itr = op.getOperands().iterator();
            while (itr.hasNext()) {
                if (this.check((IConstraint)itr.next())) continue;
                return false;
            }
            return true;
        }
        if (op.getType() == IConstraint.Type.OR) {
            Iterator itr = op.getOperands().iterator();
            while (itr.hasNext()) {
                if (!this.check((IConstraint)itr.next())) continue;
                return true;
            }
            return false;
        }
        if (op.getType() == IConstraint.Type.CONFLICTS) {
            String gid = (String)op.getOperand(0);
            IGroup group = ProjectFacetsManager.getGroup(gid);
            Iterator itr = this.fixed.iterator();
            while (itr.hasNext()) {
                IProjectFacet f = (IProjectFacet)itr.next();
                if (!group.getMembers().containsAll(f.getVersions())) continue;
                return false;
            }
            return true;
        }
        if (op.getType() == IConstraint.Type.REQUIRES) {
            String name = (String)op.getOperand(0);
            String vexpr = (String)op.getOperand(1);
            boolean soft = (Boolean)op.getOperand(2);
            if (soft) {
                return true;
            }
            IProjectFacet rf = ProjectFacetsManager.getProjectFacet(name);
            try {
                Iterator itr = rf.getVersions(vexpr).iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                    if (!this.check(fv)) continue;
                    return true;
                }
            }
            catch (CoreException e) {
                FacetCorePlugin.log((Exception)((Object)e));
                return false;
            }
            return false;
        }
        throw new IllegalStateException();
    }
}

