/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.client.internal.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.common.internal.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.model.translator.client.ApplicationClientTranslator;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class ApplicationClientResourceImpl
extends XMLResourceImpl
implements ApplicationClientResource {
    public ApplicationClientResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public ApplicationClientResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    public ApplicationClient getApplicationClient() {
        return (ApplicationClient)this.getRootObject();
    }

    public int getType() {
        return 1;
    }

    public String getJ2EE_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/application-client_1_2.dtd";
    }

    public String getJ2EE_1_3_SystemID() {
        return "http://java.sun.com/dtd/application-client_1_3.dtd";
    }

    public String getJ2EE_1_2_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
    }

    public String getJ2EE_1_3_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN";
    }

    public String getDoctype() {
        switch (this.getJ2EEVersionID()) {
            case 12: 
            case 13: {
                return "application-client";
            }
        }
        return null;
    }

    public Translator getRootTranslator() {
        return ApplicationClientTranslator.INSTANCE;
    }

    public int getJ2EEVersionID() {
        return this.getModuleVersionID();
    }

    public void setModuleVersionID(int id) {
        super.setVersionID(id);
        switch (id) {
            case 14: {
                super.setDoctypeValues(null, null);
                break;
            }
            case 13: {
                super.setDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
                break;
            }
            case 12: {
                super.setDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
            }
        }
        this.syncVersionOfRootObject();
    }

    public void setJ2EEVersionID(int id) {
        this.primSetVersionID(id);
        switch (id) {
            case 14: {
                this.primSetDoctypeValues(null, null);
                break;
            }
            case 13: {
                this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
                break;
            }
            case 12: {
                this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
            }
        }
        this.syncVersionOfRootObject();
    }

    protected void syncVersionOfRootObject() {
        ApplicationClient clt = this.getApplicationClient();
        if (clt == null) {
            return;
        }
        String version = clt.getVersion();
        String newVersion = this.getModuleVersionString();
        if (!newVersion.equals(version)) {
            clt.setVersion(newVersion);
        }
    }
}

