/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.context;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.ws.internal.context.ScenarioContext;
import org.eclipse.jst.ws.internal.context.ScenarioDefaults;
import org.eclipse.jst.ws.internal.context.TransientScenarioContext;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestRegistry;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.context.PersistentContext;

public class PersistentScenarioContext
extends PersistentContext
implements ScenarioContext {
    public PersistentScenarioContext() {
        super((Plugin)WebServicePlugin.getInstance());
    }

    public void load() {
        ScenarioDefaults defaults = new ScenarioDefaults();
        String[] ids = defaults.getWebServiceTestTypes();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ids.length) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(ids[i]);
            ++i;
        }
        String nonJavaTestService = defaults.getNonJavaTestServiceDefault();
        this.setDefaultStringIfNoDefault("webServiceTestTypes", sb.toString());
        this.setDefaultStringIfNoDefault("nonJavaTestService", nonJavaTestService);
        this.setDefaultStringIfNoDefault("clientWebServiceType", defaults.webserviceClientTypeDefault());
        this.setDefaultStringIfNoDefault("webServiceType", defaults.webserviceTypeIdDefault());
        this.setDefaultBooleanIfNoDefault("generateProxy", defaults.generateProxyDefault());
        this.setDefaultBooleanIfNoDefault("launchWebServiceExplorer", defaults.launchWebserviceExplorerDefault());
        this.setDefaultBooleanIfNoDefault("installWebService", defaults.installWebserviceDefault());
        this.setDefaultBooleanIfNoDefault("installClient", defaults.installClientDefault());
        this.setDefaultBooleanIfNoDefault("startWebService", defaults.startWebserviceDefault());
        this.setDefaultBooleanIfNoDefault("testWebService", defaults.testWebserviceDefault());
        this.setDefaultBooleanIfNoDefault("monitorWebService", defaults.getMonitorWebServiceDefault());
        this.setDefaultBooleanIfNoDefault("launchSample", defaults.launchSample());
    }

    public String[] getNonJavaTestService() {
        WebServiceTestRegistry registry = WebServiceTestRegistry.getInstance();
        String[] testTypes = this.getWebServiceTestTypes();
        Vector<String> newTestCases = new Vector<String>();
        int i = 0;
        while (i < testTypes.length) {
            WebServiceTestExtension wse = (WebServiceTestExtension)registry.getWebServiceExtensionsByName(testTypes[i]);
            if (wse.testWSDL()) {
                newTestCases.addElement(testTypes[i]);
            }
            ++i;
        }
        String[] wsdlTestArray = new String[newTestCases.size()];
        Enumeration e = newTestCases.elements();
        int i2 = 0;
        while (e.hasMoreElements()) {
            wsdlTestArray[i2] = (String)e.nextElement();
            ++i2;
        }
        return wsdlTestArray;
    }

    public void setWebServiceTestTypes(String[] ids) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ids.length) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(ids[i]);
            ++i;
        }
        this.setValue("webServiceTestTypes", sb.toString());
    }

    public String[] getWebServiceTestTypes() {
        StringTokenizer st = new StringTokenizer(this.getValueAsString("webServiceTestTypes"), ",");
        String[] s = new String[st.countTokens()];
        int i = 0;
        while (i < s.length) {
            s[i] = st.nextToken();
            ++i;
        }
        return s;
    }

    public ScenarioContext copy() {
        TransientScenarioContext context = new TransientScenarioContext();
        context.setWebServiceTestTypes(this.getWebServiceTestTypes());
        context.setNonJavaTestService(this.getNonJavaTestService());
        context.setClientWebServiceType(this.getClientWebServiceType());
        context.setWebServiceType(this.getWebServiceType());
        context.setLaunchWebServiceExplorer(this.getLaunchWebServiceExplorer());
        context.setStartWebService(this.getStartWebService());
        context.setGenerateProxy(this.getGenerateProxy());
        context.setTestWebService(this.getTestWebService());
        context.setMonitorWebService(this.getMonitorWebService());
        context.setLaunchSampleEnabled(this.isLaunchSampleEnabled());
        return context;
    }

    public String getClientWebServiceType() {
        return this.getValueAsString("clientWebServiceType");
    }

    public String getClientWebServiceTypeDefault() {
        return this.getDefaultString("clientWebServiceType");
    }

    public boolean getGenerateProxy() {
        return this.getValueAsBoolean("generateProxy");
    }

    public boolean getGenerateProxyDefault() {
        return this.getDefaultBoolean("generateProxy");
    }

    public boolean getLaunchWebServiceExplorer() {
        return this.getValueAsBoolean("launchWebServiceExplorer");
    }

    public boolean getLaunchWebServiceExplorerDefault() {
        return this.getDefaultBoolean("launchWebServiceExplorer");
    }

    public boolean getStartWebService() {
        return this.getValueAsBoolean("startWebService");
    }

    public boolean getStartWebServiceDefault() {
        return this.getDefaultBoolean("startWebService");
    }

    public boolean getInstallWebService() {
        return this.getValueAsBoolean("installWebService");
    }

    public boolean getInstallWebServiceDefault() {
        return this.getDefaultBoolean("installWebService");
    }

    public boolean getInstallClient() {
        return this.getValueAsBoolean("installClient");
    }

    public boolean getInstallClientDefault() {
        return this.getDefaultBoolean("installClient");
    }

    public boolean getTestWebService() {
        return this.getValueAsBoolean("testWebService");
    }

    public boolean getTestWebServiceDefault() {
        return this.getDefaultBoolean("testWebService");
    }

    public String getWebServiceType() {
        return this.getValueAsString("webServiceType");
    }

    public String getWebServiceTypeDefault() {
        return this.getDefaultString("webServiceType");
    }

    public void setClientWebServiceType(String value) {
        this.setValue("clientWebServiceType", value);
    }

    public void setGenerateProxy(boolean value) {
        this.setValue("generateProxy", value);
    }

    public void setLaunchWebServiceExplorer(boolean value) {
        this.setValue("launchWebServiceExplorer", value);
    }

    public void setInstallWebService(boolean value) {
        this.setValue("installWebService", value);
    }

    public void setInstallClient(boolean value) {
        this.setValue("installClient", value);
    }

    public void setStartWebService(boolean value) {
        this.setValue("startWebService", value);
    }

    public void setTestWebService(boolean value) {
        this.setValue("testWebService", value);
    }

    public void setWebServiceType(String value) {
        this.setValue("webServiceType", value);
    }

    public boolean getMonitorWebService() {
        return this.getValueAsBoolean("monitorWebService");
    }

    public boolean getMonitorWebServiceDefault() {
        return this.getDefaultBoolean("monitorWebService");
    }

    public void setMonitorWebService(boolean value) {
        this.setValue("monitorWebService", value);
    }

    public boolean getLaunchSampleEnabledDefault() {
        return this.getDefaultBoolean("launchSample");
    }

    public boolean isLaunchSampleEnabled() {
        return this.getValueAsBoolean("launchSample");
    }

    public void setLaunchSampleEnabled(boolean value) {
        this.setValue("launchSample", value);
    }
}

