/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.wst.common.navigator.internal.provisional.views.AdaptabilityUtility;

public class ResourceToItemsMapper {
    private static final int NUMBER_LIST_REUSE = 10;
    private HashMap fResourceToItem = new HashMap();
    private Stack fReuseLists = new Stack();
    private ContentViewer fContentViewer;
    private static final Class IRESOURCE_CLASS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IRESOURCE_CLASS = clazz;
    }

    public ResourceToItemsMapper(ContentViewer viewer) {
        this.fContentViewer = viewer;
    }

    public void resourceChanged(IResource changedResource) {
        Object obj = this.fResourceToItem.get(changedResource);
        if (obj != null) {
            if (obj instanceof Item) {
                Item item = (Item)obj;
                this.updateItem(item);
            } else {
                List list = (List)obj;
                int k = 0;
                while (k < list.size()) {
                    this.updateItem((Item)list.get(k));
                    ++k;
                }
            }
        }
    }

    private void updateItem(Item item) {
        Object data = null;
        try {
            if (!item.isDisposed()) {
                ILabelProvider lprovider = (ILabelProvider)this.fContentViewer.getLabelProvider();
                data = item.getData();
                if (data == null) {
                    return;
                }
                if (lprovider instanceof IViewerLabelProvider) {
                    IViewerLabelProvider provider = (IViewerLabelProvider)lprovider;
                    ViewerLabel updateLabel = new ViewerLabel(item.getText(), item.getImage());
                    provider.updateLabel(updateLabel, data);
                    if (updateLabel.hasNewImage()) {
                        item.setImage(updateLabel.getImage());
                    }
                    if (updateLabel.hasNewText()) {
                        item.setText(updateLabel.getText());
                    }
                } else {
                    Image oldImage = item.getImage();
                    Image image = lprovider.getImage(data);
                    if (image != null && !image.equals((Object)oldImage)) {
                        item.setImage(image);
                    }
                    String oldText = item.getText();
                    String text = lprovider.getText(data);
                    if (text != null && !text.equals(oldText)) {
                        item.setText(text);
                    }
                }
            }
        }
        catch (Throwable ex) {
            System.out.println("An error occurred in " + this.getClass().getName() + ".doUpdateItem(Item, Object):");
            System.out.println("\titem = \"" + (item.isDisposed() ? " Is Disposed. " : item.toString()) + "\"");
            if (data != null) {
                System.out.println("\tmodel element = \"" + data + "\"");
            }
            ex.printStackTrace();
        }
    }

    public void addToMap(Object element, Item item) {
        IResource resource = ResourceToItemsMapper.getCorrespondingResource(element);
        if (resource != null) {
            Object existingMapping = this.fResourceToItem.get(resource);
            if (existingMapping == null) {
                this.fResourceToItem.put(resource, item);
            } else if (existingMapping instanceof Item) {
                if (existingMapping != item) {
                    List list = this.getNewList();
                    list.add(existingMapping);
                    list.add(item);
                    this.fResourceToItem.put(resource, list);
                }
            } else {
                List list = (List)existingMapping;
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object element, Item item) {
        IResource resource = ResourceToItemsMapper.getCorrespondingResource(element);
        if (resource != null) {
            Object existingMapping = this.fResourceToItem.get(resource);
            if (existingMapping == null) {
                return;
            }
            if (existingMapping instanceof Item) {
                this.fResourceToItem.remove(resource);
            } else {
                List list = (List)existingMapping;
                list.remove(item);
                if (list.isEmpty()) {
                    this.fResourceToItem.remove(list);
                    this.releaseList(list);
                }
            }
        }
    }

    private List getNewList() {
        if (!this.fReuseLists.isEmpty()) {
            return (List)this.fReuseLists.pop();
        }
        return new ArrayList(2);
    }

    private void releaseList(List list) {
        if (this.fReuseLists.size() < 10) {
            this.fReuseLists.push(list);
        }
    }

    public void clearMap() {
        this.fResourceToItem.clear();
    }

    public boolean isEmpty() {
        return this.fResourceToItem.isEmpty();
    }

    private static IResource getCorrespondingResource(Object element) {
        if (element != null) {
            if (element instanceof IResource) {
                return (IResource)element;
            }
            return (IResource)AdaptabilityUtility.getAdapter(element, IRESOURCE_CLASS);
        }
        return null;
    }
}

