/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.filters;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonActivitiesUtilities;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorActivationService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.filters.CommonFilterContentProvider;
import org.eclipse.wst.common.navigator.internal.views.filters.CommonFilterLabelProvider;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterDescriptor;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterRegistryManager;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterViewerRegistry;

public class CommonFilterSelectionDialog
extends Dialog {
    private static final NavigatorActivationService NAVIGATOR_ACTIVATION_SERVICE = NavigatorActivationService.getInstance();
    private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();
    private static final Object[] NO_CHILDREN = new Object[0];
    private CheckboxTableViewer extensionsCheckboxTableViewer;
    private Text descriptionText;
    private ISelectionChangedListener updateDescriptionSelectionListener;
    private TabFolder filtersTabFolder;
    private CheckboxTableViewer filtersCheckboxTableViewer;
    private final CommonViewer commonViewer;
    private final NavigatorContentService contentService;

    public CommonFilterSelectionDialog(Shell arg0, CommonViewer aViewer) {
        super(arg0);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.commonViewer = aViewer;
        this.contentService = this.commonViewer.getNavigatorContentService();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(NavigatorMessages.CommonFilterSelectionDialog_0);
        Composite superComposite = (Composite)super.createDialogArea(parent);
        this.createFiltersTabFolder(superComposite);
        Composite extensionsComposite = this.createContainerComposite((Composite)this.filtersTabFolder);
        this.createExtensionsTableViewer(extensionsComposite);
        Composite filtersComposite = this.createContainerComposite((Composite)this.filtersTabFolder);
        this.createFiltersTableViewer(filtersComposite);
        this.createDescriptionText(superComposite);
        this.createTabItem(this.filtersTabFolder, NavigatorMessages.CommonFilterSelectionDialog_0, filtersComposite);
        this.createTabItem(this.filtersTabFolder, NavigatorMessages.CommonFilterSelectionDialog_1, extensionsComposite);
        this.descriptionText.setBackground(superComposite.getBackground());
        this.updateCheckedItems();
        return extensionsComposite;
    }

    private void createFiltersTabFolder(Composite superComposite) {
        this.filtersTabFolder = new TabFolder(superComposite, 16);
        this.createStandardLayout((Composite)this.filtersTabFolder);
        this.filtersTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommonFilterSelectionDialog.this.descriptionText.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTabItem(TabFolder filtersTabFolderArg, String label, Composite composite) {
        TabItem extensionsTabItem = new TabItem(filtersTabFolderArg, 0);
        extensionsTabItem.setText(label);
        extensionsTabItem.setControl((Control)composite);
    }

    private void createStandardLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
    }

    private Composite createContainerComposite(Composite superComposite) {
        Composite composite = new Composite(superComposite, 16);
        this.createStandardLayout(composite);
        return composite;
    }

    private void createExtensionsInstructionsLabel(Composite composite) {
        Label extensionsInstructionLabel = new Label(composite, 513);
        GridData gridData = new GridData(768);
        gridData.heightHint = this.convertHeightInCharsToPixels(1) + 3;
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(2);
        gridData.verticalAlignment = 16;
        gridData.horizontalAlignment = 256;
        extensionsInstructionLabel.setLayoutData((Object)gridData);
        extensionsInstructionLabel.setText(NavigatorMessages.CommonFilterSelectionDialog_3);
    }

    private void createFiltersInstructionsLabel(Composite composite) {
        Label filtersInstructionLabel = new Label(composite, 513);
        GridData gridData = new GridData(768);
        gridData.heightHint = this.convertHeightInCharsToPixels(1) + 3;
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(2);
        gridData.verticalAlignment = 16;
        gridData.horizontalAlignment = 256;
        filtersInstructionLabel.setLayoutData((Object)gridData);
        filtersInstructionLabel.setText(NavigatorMessages.CommonFilterSelectionDialog_4);
    }

    private void createDescriptionText(Composite composite) {
        this.descriptionText = new Text(composite, 2624);
        GridData descriptionTextGridData = new GridData(768);
        descriptionTextGridData.heightHint = this.convertHeightInCharsToPixels(3);
        this.descriptionText.setLayoutData((Object)descriptionTextGridData);
    }

    private void createFiltersTableViewer(Composite composite) {
        this.filtersCheckboxTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67600);
        this.filtersCheckboxTableViewer.setContentProvider((IContentProvider)new CommonFilterContentProvider());
        this.filtersCheckboxTableViewer.setLabelProvider((IBaseLabelProvider)new CommonFilterLabelProvider());
        this.filtersCheckboxTableViewer.setInput((Object)this.contentService);
        this.createFiltersInstructionsLabel(composite);
        this.createCheckboxTable(this.filtersCheckboxTableViewer);
    }

    private void createExtensionsTableViewer(Composite composite) {
        this.extensionsCheckboxTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2064);
        this.extensionsCheckboxTableViewer.setContentProvider((IContentProvider)new ExtensionContentProvider());
        this.extensionsCheckboxTableViewer.setLabelProvider((IBaseLabelProvider)new CommonFilterLabelProvider());
        this.extensionsCheckboxTableViewer.setInput((Object)this.contentService);
        this.createExtensionsInstructionsLabel(composite);
        this.createCheckboxTable(this.extensionsCheckboxTableViewer);
    }

    private void createCheckboxTable(CheckboxTableViewer tableViewer) {
        Table table = tableViewer.getTable();
        GridLayout tableLayout = new GridLayout();
        tableLayout.marginHeight = 0;
        tableLayout.marginWidth = 0;
        tableLayout.verticalSpacing = 0;
        tableLayout.horizontalSpacing = 0;
        tableLayout.numColumns = 2;
        GridData tableGridData = new GridData(1808);
        tableGridData.widthHint = this.convertHorizontalDLUsToPixels(100);
        tableGridData.heightHint = this.convertVerticalDLUsToPixels(50);
        table.setLayout((Layout)tableLayout);
        table.setLayoutData((Object)tableGridData);
    }

    protected void updateCheckedItems() {
        this.extensionsCheckboxTableViewer.addSelectionChangedListener(this.getSelectionListener());
        this.filtersCheckboxTableViewer.addSelectionChangedListener(this.getSelectionListener());
        this.updateExtensionsCheckState();
        this.updateFiltersCheckState();
    }

    private void updateExtensionsCheckState() {
        TableItem[] descriptorTableItems = this.extensionsCheckboxTableViewer.getTable().getItems();
        int i = 0;
        while (i < descriptorTableItems.length) {
            if (descriptorTableItems[i].getData() instanceof NavigatorContentDescriptor) {
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)descriptorTableItems[i].getData();
                boolean enabled = NAVIGATOR_ACTIVATION_SERVICE.isNavigatorExtensionActive(this.contentService.getViewerId(), descriptor.getId());
                this.extensionsCheckboxTableViewer.setChecked((Object)descriptor, enabled);
            }
            ++i;
        }
    }

    private void updateFiltersCheckState() {
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.filtersCheckboxTableViewer.getContentProvider();
        Object[] children = contentProvider.getElements((Object)this.contentService);
        ExtensionFilterViewerRegistry filterRegistry = ExtensionFilterRegistryManager.getInstance().getViewerRegistry(this.contentService.getViewerId());
        ExtensionFilterDescriptor filterDescriptor = null;
        int i = 0;
        while (i < children.length) {
            filterDescriptor = (ExtensionFilterDescriptor)children[i];
            this.filtersCheckboxTableViewer.setChecked(children[i], filterRegistry.getActivationManager().isFilterActive(filterDescriptor));
            ++i;
        }
    }

    private ISelectionChangedListener getSelectionListener() {
        if (this.updateDescriptionSelectionListener == null) {
            this.updateDescriptionSelectionListener = new UpdateDescriptionListener();
        }
        return this.updateDescriptionSelectionListener;
    }

    protected void okPressed() {
        boolean updateExtensionActivation = false;
        boolean updateFilterActivation = false;
        boolean enabled = false;
        NavigatorContentDescriptor descriptor = null;
        ExtensionFilterDescriptor filterDescriptor = null;
        ExtensionFilterViewerRegistry filterRegistry = ExtensionFilterRegistryManager.getInstance().getViewerRegistry(this.contentService.getViewerId());
        TableItem[] extensionTableItems = this.extensionsCheckboxTableViewer.getTable().getItems();
        int descriptorIndex = 0;
        while (descriptorIndex < extensionTableItems.length) {
            if (extensionTableItems[descriptorIndex].getData() instanceof NavigatorContentDescriptor && (enabled = this.extensionsCheckboxTableViewer.getChecked((Object)(descriptor = (NavigatorContentDescriptor)extensionTableItems[descriptorIndex].getData()))) != NAVIGATOR_ACTIVATION_SERVICE.isNavigatorExtensionActive(this.contentService.getViewerId(), descriptor.getId())) {
                updateExtensionActivation = true;
                NAVIGATOR_ACTIVATION_SERVICE.activateNavigatorExtension(this.contentService.getViewerId(), descriptor.getId(), enabled);
            }
            ++descriptorIndex;
        }
        TableItem[] filterTableItems = this.filtersCheckboxTableViewer.getTable().getItems();
        int descriptorIndex2 = 0;
        while (descriptorIndex2 < filterTableItems.length) {
            if (filterTableItems[descriptorIndex2].getData() instanceof ExtensionFilterDescriptor) {
                filterDescriptor = (ExtensionFilterDescriptor)filterTableItems[descriptorIndex2].getData();
                enabled = this.filtersCheckboxTableViewer.getChecked((Object)filterDescriptor);
                if (filterRegistry.getActivationManager().isFilterActive(filterDescriptor) != enabled) {
                    updateFilterActivation = true;
                    filterRegistry.getActivationManager().activateFilter(filterDescriptor, enabled);
                }
            }
            ++descriptorIndex2;
        }
        if (updateExtensionActivation) {
            NAVIGATOR_ACTIVATION_SERVICE.persistExtensionActivations(this.contentService.getViewerId());
        }
        if (updateFilterActivation) {
            filterRegistry.getActivationManager().persistFilterActivations();
        }
        if (updateExtensionActivation || updateFilterActivation) {
            this.contentService.update();
        }
        super.okPressed();
    }

    public class UpdateDescriptionListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
            Object element = structuredSelection.getFirstElement();
            if (element instanceof NavigatorContentDescriptor) {
                NavigatorContentDescriptor ncd = (NavigatorContentDescriptor)element;
                String desc = NavigatorMessages.getString(NavigatorMessages.CommonFilterSelectionDialog_2, new Object[]{ncd.getName()});
                CommonFilterSelectionDialog.this.descriptionText.setText(desc);
            } else if (element instanceof ExtensionFilterDescriptor) {
                ExtensionFilterDescriptor efd = (ExtensionFilterDescriptor)element;
                CommonFilterSelectionDialog.this.descriptionText.setText(efd.getDescription());
            }
        }
    }

    class ExtensionContentProvider
    implements ITreeContentProvider {
        ExtensionContentProvider() {
        }

        public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        }

        public Object[] getChildren(Object aParentElement) {
            return NO_CHILDREN;
        }

        public Object getParent(Object anElement) {
            return null;
        }

        public boolean hasChildren(Object anElement) {
            return this.getChildren(anElement).length != 0;
        }

        public Object[] getElements(Object anInputElement) {
            return CommonActivitiesUtilities.filterByActivity(CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors());
        }

        public void dispose() {
        }
    }
}

