/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xsd.ui.internal.XSDEditor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.XSDMenuListener;
import org.eclipse.wst.xsd.ui.internal.actions.OpenSchemaAction;
import org.eclipse.wst.xsd.ui.internal.provider.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.provider.XSDAdapterFactoryLabelProvider;
import org.eclipse.wst.xsd.ui.internal.provider.XSDContentProvider;
import org.eclipse.wst.xsd.ui.internal.provider.XSDModelAdapterFactoryImpl;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDContentOutlineConfiguration
extends ContentOutlineConfiguration {
    private XSDContentProvider fContentProvider;
    private ILabelProvider fLabelProvider;
    private KeyListener[] fKeyListeners = null;
    private IMenuListener fMenuListener = null;
    private XSDEditor fEditor = null;
    private TreeViewer treeViewer;
    protected SelectionManagerSelectionChangeListener selectionManagerSelectionChangeListener = new SelectionManagerSelectionChangeListener();
    FilterAction referenceAction;
    FilterAction inheritedAction;
    static /* synthetic */ Class class$0;

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null) {
            this.fContentProvider = new XSDContentProvider(XSDModelAdapterFactoryImpl.getInstance());
        }
        this.treeViewer = viewer;
        this.getXSDEditor().getSelectionManager().addSelectionChangedListener(this.selectionManagerSelectionChangeListener);
        return this.fContentProvider;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new XSDAdapterFactoryLabelProvider(XSDModelAdapterFactoryImpl.getInstance());
        }
        return this.fLabelProvider;
    }

    public IMenuListener getMenuListener(TreeViewer viewer) {
        if (this.fMenuListener == null && this.getXSDEditor() != null) {
            this.fMenuListener = new XSDMenuListener(this.getXSDEditor().getSelectionManager());
        }
        return this.fMenuListener;
    }

    public KeyListener[] getKeyListeners(TreeViewer viewer) {
        if (this.fKeyListeners == null) {
            final TreeViewer finalViewer = viewer;
            KeyAdapter keyListener = new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    Tree tree;
                    TreeItem[] selection;
                    if (e.character == '\u007f') {
                        IMenuListener menuListener = XSDContentOutlineConfiguration.this.getMenuListener(finalViewer);
                        if (menuListener instanceof XSDMenuListener) {
                            ((XSDMenuListener)menuListener).getDeleteAction().run();
                        }
                    } else if (e.keyCode == 0x100000C && e.widget instanceof Tree && (selection = (tree = (Tree)e.widget).getSelection()).length > 0 && selection[0].getData() instanceof XSDSchemaDirective) {
                        XSDSchemaDirective comp = (XSDSchemaDirective)selection[0].getData();
                        OpenSchemaAction openSchema = new OpenSchemaAction(XSDEditorPlugin.getXSDString("_UI_ACTION_OPEN_SCHEMA"), (XSDConcreteComponent)comp);
                        openSchema.run();
                    }
                }
            };
            this.fKeyListeners = new KeyListener[]{keyListener};
        }
        return this.fKeyListeners;
    }

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        ISelection sel = selection;
        if (selection instanceof IStructuredSelection) {
            ArrayList<Object> xsdSelections = new ArrayList<Object>();
            Iterator i = ((IStructuredSelection)selection).iterator();
            while (i.hasNext()) {
                Object domNode = i.next();
                Object xsdNode = this.getXSDNode(domNode, viewer);
                if (xsdNode == null) continue;
                xsdSelections.add(xsdNode);
            }
            if (!xsdSelections.isEmpty()) {
                sel = new StructuredSelection(xsdSelections);
            }
        }
        return sel;
    }

    private Object getXSDNode(Object object, TreeViewer viewer) {
        XSDConcreteComponent modelObject;
        Node node;
        Element element = null;
        if (object instanceof Node && (node = (Node)object) != null) {
            if (node.getNodeType() == 1) {
                element = (Element)node;
            } else if (node.getNodeType() == 2) {
                element = ((Attr)node).getOwnerElement();
            }
        }
        Element o = element;
        if (element != null && (modelObject = this.getXSDSchema(viewer).getCorrespondingComponent(element)) != null) {
            o = modelObject;
        }
        return o;
    }

    private XSDSchema getXSDSchema(TreeViewer viewer) {
        IDOMDocument domDoc;
        XSDSchema xsdSchema = null;
        Object model = null;
        if (viewer != null) {
            model = viewer.getInput();
        }
        if (model instanceof IDOMModel && (domDoc = ((IDOMModel)model).getDocument()) != null) {
            XSDModelAdapter modelAdapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((modelAdapter = (XSDModelAdapter)domDoc.getExistingAdapter((Object)clazz)) != null) {
                xsdSchema = modelAdapter.getSchema();
            }
        }
        return xsdSchema;
    }

    private XSDEditor getXSDEditor() {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbench workbench;
        if (this.fEditor == null && (workbench = PlatformUI.getWorkbench()) != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) instanceof XSDEditor) {
            this.fEditor = (XSDEditor)editor;
        }
        return this.fEditor;
    }

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        IContributionItem[] items = super.createMenuContributions(viewer);
        this.referenceAction = new FilterAction(XSDEditorPlugin.getPlugin().getPreferenceStore(), "referenceContentAction", new ReferenceFilter("Reference Content"), XSDEditorPlugin.getXSDString("_UI_OUTLINE_SHOW_REFERENCES"), ImageDescriptor.createFromFile(((Object)((Object)XSDEditorPlugin.getPlugin())).getClass(), (String)"icons/XSDElementRef.gif"));
        boolean initialRef = this.getXSDEditor().getXSDModelAdapterFactory().getShowReferences();
        this.referenceAction.setChecked(initialRef);
        this.inheritedAction = new FilterAction(XSDEditorPlugin.getPlugin().getPreferenceStore(), "inheritedContentAction", new ReferenceFilter("Inherited Content"), XSDEditorPlugin.getXSDString("_UI_OUTLINE_SHOW_INHERITED"), ImageDescriptor.createFromFile(((Object)((Object)XSDEditorPlugin.getPlugin())).getClass(), (String)"icons/XSDComplexContent.gif"));
        PropertyChangeUpdateActionContributionItem toggleReferenceItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)this.referenceAction);
        PropertyChangeUpdateActionContributionItem toggleInheritedItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)this.inheritedAction);
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(items));
        list.add(toggleReferenceItem);
        list.add(toggleInheritedItem);
        int length = list.size();
        IContributionItem[] newItems = new IContributionItem[length];
        int i = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            newItems[i] = (IContributionItem)iter.next();
            ++i;
        }
        return newItems;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void updateActions(Action current) {
        if (this.referenceAction.isChecked()) {
            this.getXSDEditor().getXSDModelAdapterFactory().setShowReferences(true);
        } else {
            this.getXSDEditor().getXSDModelAdapterFactory().setShowReferences(false);
        }
        if (this.inheritedAction.isChecked()) {
            this.getXSDEditor().getXSDModelAdapterFactory().setShowInherited(true);
        } else {
            this.getXSDEditor().getXSDModelAdapterFactory().setShowInherited(false);
        }
        this.getTreeViewer().refresh();
    }

    public void unconfigure(TreeViewer viewer) {
        super.unconfigure(viewer);
        this.getXSDEditor().getSelectionManager().removeSelectionChangedListener(this.selectionManagerSelectionChangeListener);
    }

    public class FilterAction
    extends PropertyChangeUpdateAction {
        ViewerFilter filter;

        public FilterAction(IPreferenceStore store, String preference, ViewerFilter filter, String label, ImageDescriptor image) {
            super(label, store, preference, true);
            this.setImageDescriptor(image);
            this.setUpdateFromPropertyChange(false);
            this.filter = filter;
            this.setChecked(false);
        }

        public void update() {
            super.update();
            XSDContentOutlineConfiguration.this.updateActions((Action)this);
        }
    }

    class ReferenceFilter
    extends ViewerFilter {
        protected String elementTag;

        public ReferenceFilter(String elementTag) {
            this.elementTag = elementTag;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    }

    class SelectionManagerSelectionChangeListener
    implements ISelectionChangedListener {
        SelectionManagerSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() != XSDContentOutlineConfiguration.this.getTreeViewer()) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof XSDSchema) {
                    StructuredSelection s = (StructuredSelection)XSDContentOutlineConfiguration.this.getTreeViewer().getSelection();
                    if (!(s.getFirstElement() instanceof CategoryAdapter)) {
                        XSDContentOutlineConfiguration.this.getTreeViewer().setSelection(event.getSelection(), true);
                    }
                } else {
                    XSDContentOutlineConfiguration.this.getTreeViewer().setSelection(event.getSelection(), true);
                }
            }
        }
    }
}

