/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.gef.util.figures;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.IConnectedEditPartFigure;

public class ConnectionRenderingFigure
extends RectangleFigure {
    protected boolean isOutlined = true;
    protected IFigure primaryLayer;

    public ConnectionRenderingFigure(IFigure primaryLayer) {
        this.setOpaque(false);
        this.primaryLayer = primaryLayer;
    }

    protected boolean isMouseEventTarget() {
        return false;
    }

    public boolean containsPoint(int x, int y) {
        return false;
    }

    protected void fillShape(Graphics graphics) {
        graphics.setForegroundColor(ColorConstants.black);
        this.drawLines(graphics, this.primaryLayer);
    }

    protected void outlineShape(Graphics graphics) {
        if (this.isOutlined) {
            super.outlineShape(graphics);
        }
    }

    protected void drawLines(Graphics graphics, IFigure figure) {
        IConnectedEditPartFigure graphNodeFigure;
        List connectedFigures;
        int connectedFiguresSize;
        if (figure instanceof IConnectedEditPartFigure && (connectedFiguresSize = (connectedFigures = (graphNodeFigure = (IConnectedEditPartFigure)figure).getConnectedFigures(4)).size()) > 0) {
            IConnectedEditPartFigure firstGraphNodeFigure = (IConnectedEditPartFigure)connectedFigures.get(0);
            Rectangle r = graphNodeFigure.getConnectionFigure().getBounds();
            int x1 = r.x + r.width;
            int y1 = r.y + r.height / 2;
            int startOfChildBox = firstGraphNodeFigure.getConnectionFigure().getBounds().x;
            int x2 = x1 + (startOfChildBox - x1) / 3;
            int y2 = y1;
            if (connectedFiguresSize == 1) {
                graphics.drawLine(x1, y1, startOfChildBox, y2);
            } else {
                graphics.drawLine(x1, y1, x2, y2);
                int minY = Integer.MAX_VALUE;
                int maxY = -1;
                Iterator i = connectedFigures.iterator();
                while (i.hasNext()) {
                    IConnectedEditPartFigure connectedFigure = (IConnectedEditPartFigure)i.next();
                    Rectangle childConnectionRectangle = connectedFigure.getConnectionFigure().getBounds();
                    int y = childConnectionRectangle.y + childConnectionRectangle.height / 2;
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    graphics.drawLine(x2, y, childConnectionRectangle.x, y);
                }
                graphics.drawLine(x2, minY, x2, maxY);
            }
        }
        List children = figure.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            this.drawLines(graphics, child);
        }
    }

    public PointList getConnectionPoints(GraphicalEditPart parentEditPart, GraphicalEditPart childRefEditPart, Rectangle draggedFigureBounds) {
        PointList pointList = new PointList();
        int[] data = new int[1];
        Point a = this.getConnectionPoint(parentEditPart, childRefEditPart, data);
        if (a != null) {
            int draggedFigureBoundsY = draggedFigureBounds.y + draggedFigureBounds.height / 2;
            pointList.addPoint(a);
            if (data[0] == 0) {
                int x = a.x + (draggedFigureBounds.x - a.x) / 2;
                pointList.addPoint(new Point(x, a.y));
                pointList.addPoint(new Point(x, draggedFigureBoundsY));
                pointList.addPoint(new Point(draggedFigureBounds.x, draggedFigureBoundsY));
            } else {
                pointList.addPoint(new Point(a.x, draggedFigureBoundsY));
                pointList.addPoint(new Point(draggedFigureBounds.x, draggedFigureBoundsY));
            }
        }
        return pointList;
    }

    protected Point getConnectionPoint(GraphicalEditPart parentEditPart, GraphicalEditPart childRefEditPart, int[] data) {
        Point point = null;
        List childList = parentEditPart.getChildren();
        if (parentEditPart.getFigure() instanceof IConnectedEditPartFigure && childList.size() > 0) {
            point = new Point();
            GraphicalEditPart prev = null;
            GraphicalEditPart next = null;
            Iterator i = childList.iterator();
            while (i.hasNext()) {
                GraphicalEditPart childEditPart;
                Object o = i.next();
                if (!(o instanceof GraphicalEditPart) || !((childEditPart = (GraphicalEditPart)o).getFigure() instanceof IConnectedEditPartFigure)) continue;
                if (childEditPart == childRefEditPart) {
                    next = childEditPart;
                    break;
                }
                prev = childEditPart;
            }
            if (next != null && prev != null) {
                int ya = this.getConnectedEditPartConnectionBounds(prev).getCenter().y;
                int yb = this.getConnectedEditPartConnectionBounds(next).getCenter().y;
                point.y = ya + (yb - ya) / 2;
                data[0] = 0;
            } else if (prev != null) {
                point.y = this.getConnectedEditPartConnectionBounds(prev).getCenter().y;
                data[0] = 1;
            } else if (next != null) {
                point.y = this.getConnectedEditPartConnectionBounds(next).getCenter().y;
                data[0] = -1;
            }
            if (next != null || prev != null) {
                GraphicalEditPart child = prev != null ? prev : next;
                int startOfChildBox = this.getConnectedEditPartConnectionBounds(child).x;
                Rectangle r = this.getConnectedEditPartConnectionBounds(parentEditPart);
                int x1 = r.x + r.width;
                point.x = x1 + (startOfChildBox - x1) / 3;
            }
        }
        return point;
    }

    protected Rectangle getConnectedEditPartConnectionBounds(GraphicalEditPart editPart) {
        return ((IConnectedEditPartFigure)editPart.getFigure()).getConnectionFigure().getBounds();
    }
}

