/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.FillLayout;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ContainerFigure;
import org.eclipse.wst.xsd.ui.internal.graph.model.Category;
import org.eclipse.wst.xsd.ui.internal.graph.model.XSDModelAdapterFactory;
import org.eclipse.xsd.XSDSchema;

class CategoryRowEditPart
extends BaseEditPart {
    public static final int[] ELEMENTS_AND_TYPES = new int[]{2, 3};
    public static final int[] DIRECTIVES_AND_NOTATIONS = new int[]{6, 7};
    public static final int[] MODEL_GROUPS_AND_ATTRIBUTES = new int[]{5, 1};
    protected XSDSchema schema;
    protected Figure contentPane;

    CategoryRowEditPart() {
    }

    protected IFigure createFigure() {
        ContainerFigure containerFigure = new ContainerFigure();
        containerFigure.setFill(true);
        containerFigure.setBorder((Border)new MarginBorder(4, 4, 4, 4));
        FillLayout fillLayout = new FillLayout(4);
        fillLayout.setHorizontal(true);
        containerFigure.setLayoutManager((LayoutManager)fillLayout);
        return containerFigure;
    }

    public IFigure getContentPane() {
        return super.getContentPane();
    }

    public XSDSchema getSchema() {
        return this.schema;
    }

    public void setSchema(XSDSchema schema) {
        this.schema = schema;
    }

    protected List getModelChildren() {
        List categoryList = (List)XSDModelAdapterFactory.getAdapter(this.schema).getProperty(this.schema, "groups");
        return this.filterCategoryList(categoryList);
    }

    protected List filterCategoryList(List list) {
        ArrayList<Category> result = new ArrayList<Category>();
        int[] categoryTypes = (int[])this.getModel();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Category category = (Category)i.next();
            if (!this.isMatching(categoryTypes, category)) continue;
            result.add(category);
        }
        return result;
    }

    private boolean isMatching(int[] categoryTypes, Category category) {
        boolean result = false;
        int i = 0;
        while (i < categoryTypes.length) {
            if (categoryTypes[i] == category.getGroupType()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }
}

