/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.xsd.XSDSchema;

public class NotationPropertySource
extends BasePropertySource
implements IPropertySource {
    public NotationPropertySource() {
    }

    public NotationPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public NotationPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> list = new ArrayList<TextPropertyDescriptor>();
        TextPropertyDescriptor publicDescriptor = new TextPropertyDescriptor((Object)"public", "public");
        list.add(publicDescriptor);
        TextPropertyDescriptor systemDescriptor = new TextPropertyDescriptor((Object)"system", "system");
        list.add(systemDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            String newValue = (String)value;
            if (((String)id).equals("name")) {
                if (this.validateName(newValue)) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_NOTATION_NAME_CHANGE"), this.element);
                    if (newValue.length() > 0) {
                        this.element.setAttribute("name", newValue);
                    } else {
                        this.element.setAttribute("name", "");
                    }
                    this.endRecording(this.element);
                }
            } else if (((String)id).equals("public")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_NOTATION_PUBLIC_CHANGE"), this.element);
                if (newValue.length() > 0) {
                    this.element.setAttribute("public", newValue);
                } else {
                    this.element.setAttribute("public", "");
                }
                this.endRecording(this.element);
            } else if (((String)id).equals("system")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_NOTATION_SYSTEM_CHANGE"), this.element);
                if (newValue.length() > 0) {
                    this.element.setAttribute("system", newValue);
                } else {
                    this.element.removeAttribute("system");
                }
                this.endRecording(this.element);
            }
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (NotationPropertySource.this.viewer != null) {
                    NotationPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }
}

