/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.internal.viewers.NavigableTableViewer;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.properties.section.FacetViewer;
import org.eclipse.wst.xsd.ui.internal.properties.section.XSDWorkbook;
import org.eclipse.wst.xsd.ui.internal.properties.section.XSDWorkbookPage;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.wst.xsd.ui.internal.wizards.RegexWizard;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FacetsSection
extends AbstractSection {
    IWorkbenchPart part;
    ISelection selection;
    FacetViewer facetViewer;
    XSDWorkbook workbook;
    FacetsWorkbookPage facetsWorkbookPage;
    PatternsWorkbookPage patternsWorkbookPage;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.workbook = new XSDWorkbook(parent, 0x800400);
        this.facetsWorkbookPage = new FacetsWorkbookPage(this.workbook, this);
        this.patternsWorkbookPage = new PatternsWorkbookPage(this.workbook);
        this.facetsWorkbookPage.activate();
        this.patternsWorkbookPage.activate();
        this.workbook.setSelectedPage(this.facetsWorkbookPage);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.part = part;
        this.selection = selection;
    }

    public void refresh() {
        Object input = this.getInput();
        if (this.isReadOnly) {
            this.facetViewer.getControl().getParent().setEnabled(false);
        } else {
            this.facetViewer.getControl().getParent().setEnabled(true);
        }
        if (this.facetViewer != null) {
            this.facetViewer.setInput(input);
        }
        if (this.patternsWorkbookPage != null) {
            this.patternsWorkbookPage.setInput(input);
        }
    }

    public void dispose() {
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    class FacetsWorkbookPage
    extends XSDWorkbookPage {
        FacetsSection facetsSection;
        Composite page1;

        public FacetsWorkbookPage(XSDWorkbook workbook, FacetsSection facetsSection2) {
            super(workbook);
            this.getTabItem().setText(XSDEditorPlugin.getXSDString("_UI_LABEL_FACETS"));
            this.facetsSection = facetsSection2;
        }

        public Control createControl(Composite parent) {
            this.page1 = FacetsSection.this.getWidgetFactory().createFlatFormComposite(parent);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            FacetsSection.this.facetViewer = new FacetViewer(this.page1, this.facetsSection);
            FacetsSection.this.facetViewer.setInput(FacetsSection.this.getInput());
            FacetsSection.this.facetViewer.getControl().setLayoutData((Object)data);
            return this.page1;
        }
    }

    class PatternsWorkbookPage
    extends XSDWorkbookPage
    implements SelectionListener,
    Listener {
        PatternsTableViewer patternsTable;
        Button addButton;
        Button deleteButton;
        Button editButton;
        Composite composite;

        public PatternsWorkbookPage(XSDWorkbook workbook) {
            super(workbook);
            this.getTabItem().setText(XSDEditorPlugin.getXSDString("_UI_LABEL_PATTERNS"));
        }

        public Control createControl(Composite parent) {
            this.composite = FacetsSection.this.getWidgetFactory().createFlatFormComposite(parent);
            this.patternsTable = new PatternsTableViewer(FacetsSection.this.getWidgetFactory().createTable(this.composite, 65538));
            this.patternsTable.setInput(FacetsSection.this.getInput());
            Table table = this.patternsTable.getTable();
            table.addSelectionListener((SelectionListener)this);
            this.addButton = FacetsSection.this.getWidgetFactory().createButton(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_ADD"), 8);
            this.editButton = FacetsSection.this.getWidgetFactory().createButton(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_EDIT"), 8);
            this.deleteButton = FacetsSection.this.getWidgetFactory().createButton(this.composite, XSDEditorPlugin.getXSDString("_UI_ACTION_DELETE_INCLUDE"), 8);
            FormData data = new FormData();
            data.left = new FormAttachment(100, -100);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(0, 0);
            this.addButton.setLayoutData((Object)data);
            this.addButton.addSelectionListener((SelectionListener)this);
            data = new FormData();
            data.left = new FormAttachment((Control)this.addButton, 0, 16384);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.addButton, 0);
            this.editButton.setLayoutData((Object)data);
            this.editButton.setEnabled(false);
            this.editButton.addSelectionListener((SelectionListener)this);
            data = new FormData();
            data.left = new FormAttachment((Control)this.addButton, 0, 16384);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.editButton, 0);
            this.deleteButton.setLayoutData((Object)data);
            this.deleteButton.setEnabled(false);
            this.deleteButton.addSelectionListener((SelectionListener)this);
            data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment((Control)this.addButton, 0);
            data.bottom = new FormAttachment(100, 0);
            data.width = FacetsSection.this.tableMinimumWidth;
            table.setLayoutData((Object)data);
            table.addListener(11, (Listener)this);
            return this.composite;
        }

        public void handleEvent(Event event) {
            Table table = this.patternsTable.getTable();
            if (event.type == 11 && event.widget == table) {
                TableColumn tableColumn = table.getColumn(0);
                tableColumn.setWidth(table.getSize().x);
            }
        }

        public void setInput(Object input) {
            this.patternsTable.setInput(input);
            if (FacetsSection.this.isReadOnly) {
                this.composite.setEnabled(false);
            } else {
                this.composite.setEnabled(true);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)FacetsSection.this.getInput();
            Element element = st.getElement();
            if (e.widget == this.addButton) {
                XSDDOMHelper helper = new XSDDOMHelper();
                int variety = st.getVariety().getValue();
                Node varietyElement = null;
                if (variety == 0) {
                    varietyElement = helper.getChildNode(element, "restriction");
                } else if (variety == 2) {
                    varietyElement = helper.getChildNode(element, "union");
                } else if (variety == 1) {
                    varietyElement = helper.getChildNode(element, "list");
                }
                if (varietyElement != null) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    String initialValue = "";
                    RegexWizard wizard = new RegexWizard(initialValue);
                    WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
                    wizardDialog.setBlockOnOpen(true);
                    wizardDialog.create();
                    int result = wizardDialog.open();
                    if (result == 0) {
                        String newPattern = wizard.getPattern();
                        ArrayList<DOMAttribute> attributes = new ArrayList<DOMAttribute>();
                        attributes.add(new DOMAttribute("value", newPattern));
                        FacetsSection.this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_PATTERN"), element);
                        Action action = FacetsSection.this.getNewElementAction("pattern", XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_PATTERN"), attributes, (Element)varietyElement, null);
                        action.run();
                        st.setElement(element);
                        FacetsSection.this.endRecording(element);
                        this.patternsTable.refresh();
                        attributes = null;
                    }
                }
            } else if (e.widget == this.deleteButton) {
                StructuredSelection selection = (StructuredSelection)this.patternsTable.getSelection();
                if (selection != null) {
                    Iterator i = selection.iterator();
                    FacetsSection.this.beginRecording(XSDEditorPlugin.getXSDString("_UI_ACTION_DELETE_INCLUDE"), element);
                    while (i.hasNext()) {
                        Object obj = i.next();
                        if (obj == null || !(obj instanceof XSDPatternFacet)) continue;
                        XSDPatternFacet patternFacet = (XSDPatternFacet)obj;
                        XSDDOMHelper.removeNodeAndWhitespace(patternFacet.getElement());
                    }
                    st.setElement(element);
                    FacetsSection.this.endRecording(element);
                    this.patternsTable.refresh();
                    if (this.patternsTable.getTable().getItemCount() == 0) {
                        this.editButton.setEnabled(false);
                        this.deleteButton.setEnabled(false);
                    }
                }
            } else if (e.widget == this.editButton) {
                Object obj;
                StructuredSelection selection = (StructuredSelection)this.patternsTable.getSelection();
                if (selection != null && (obj = selection.getFirstElement()) instanceof XSDPatternFacet) {
                    XSDPatternFacet pattern = (XSDPatternFacet)obj;
                    String initialValue = pattern.getLexicalValue();
                    if (initialValue == null) {
                        initialValue = "";
                    }
                    Shell shell = Display.getCurrent().getActiveShell();
                    RegexWizard wizard = new RegexWizard(initialValue);
                    WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
                    wizardDialog.setBlockOnOpen(true);
                    wizardDialog.create();
                    int result = wizardDialog.open();
                    if (result == 0) {
                        String newPattern = wizard.getPattern();
                        FacetsSection.this.beginRecording(XSDEditorPlugin.getXSDString("_UI_PATTERN_VALUE_CHANGE"), element);
                        element.setAttribute("value", newPattern);
                        pattern.setLexicalValue(newPattern);
                        FacetsSection.this.endRecording(element);
                        this.patternsTable.refresh();
                    }
                }
            } else if (e.widget == this.patternsTable.getTable()) {
                StructuredSelection selection = (StructuredSelection)this.patternsTable.getSelection();
                if (selection.getFirstElement() != null) {
                    this.editButton.setEnabled(true);
                    this.deleteButton.setEnabled(true);
                } else {
                    this.editButton.setEnabled(false);
                    this.deleteButton.setEnabled(false);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class PatternsTableViewer
    extends NavigableTableViewer
    implements ICellModifier {
        protected String[] columnProperties = new String[]{"Pattern"};
        protected CellEditor[] cellEditors;
        Table table;

        public PatternsTableViewer(Table table) {
            super(table);
            table = this.getTable();
            table.setLinesVisible(true);
            this.setContentProvider((IContentProvider)new PatternsTableContentProvider());
            this.setLabelProvider((IBaseLabelProvider)new PatternsTableLabelProvider());
            this.setColumnProperties(this.columnProperties);
            this.setCellModifier(this);
            TableColumn column = new TableColumn(table, 0, 0);
            column.setText(this.columnProperties[0]);
            column.setAlignment(16384);
            column.setResizable(true);
            this.cellEditors = new CellEditor[1];
            TableLayout layout = new TableLayout();
            ColumnWeightData data = new ColumnWeightData(100);
            layout.addColumnData((ColumnLayoutData)data);
            this.cellEditors[0] = new TextCellEditor((Composite)table);
            this.getTable().setLayout((Layout)layout);
            this.setCellEditors(this.cellEditors);
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem && value != null) {
                TableItem item = (TableItem)element;
                Element simpleTypeElement = ((XSDSimpleTypeDefinition)this.getInput()).getElement();
                FacetsSection.this.beginRecording(XSDEditorPlugin.getXSDString("_UI_PATTERN_VALUE_CHANGE"), simpleTypeElement);
                XSDPatternFacet patternFacet = (XSDPatternFacet)item.getData();
                patternFacet.setLexicalValue((String)value);
                item.setData((Object)patternFacet);
                item.setText((String)value);
                FacetsSection.this.endRecording(simpleTypeElement);
            }
        }

        public Object getValue(Object element, String property) {
            if (element instanceof XSDPatternFacet) {
                XSDPatternFacet patternFacet = (XSDPatternFacet)element;
                String value = patternFacet.getLexicalValue();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            return "";
        }
    }

    class PatternsTableContentProvider
    implements IStructuredContentProvider {
        PatternsTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = new ArrayList();
            if (inputElement instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)inputElement;
                return st.getPatternFacets().toArray();
            }
            return list.toArray();
        }

        public void dispose() {
        }
    }

    class PatternsTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return XSDEditorPlugin.getXSDImage("icons/XSDSimplePattern.gif");
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof XSDPatternFacet) {
                XSDPatternFacet pattern = (XSDPatternFacet)element;
                String value = pattern.getLexicalValue();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            return "";
        }
    }
}

