/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xsd.ui.internal.commands.MakeLocalElementGlobalCommand;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.SelectionDispatchAction;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Node;

public class MakeLocalElementGlobalAction
extends SelectionDispatchAction {
    XSDElementDeclaration fSelectedComponent;

    public MakeLocalElementGlobalAction(ISelectionProvider selectionProvider, XSDSchema schema) {
        super(selectionProvider);
        this.setText(RefactoringMessages.getString("MakeLocalElementGlobalAction.text"));
        this.setSchema(schema);
    }

    public boolean canRun() {
        return this.fSelectedComponent != null;
    }

    protected boolean canEnable(XSDConcreteComponent selectedObject) {
        XSDElementDeclaration element;
        this.fSelectedComponent = null;
        if (selectedObject instanceof XSDElementDeclaration && !(element = (XSDElementDeclaration)selectedObject).isElementDeclarationReference() && !element.isGlobal()) {
            this.fSelectedComponent = element;
        }
        return this.canRun();
    }

    protected boolean canEnable(Object selectedObject) {
        if (selectedObject instanceof XSDConcreteComponent) {
            return this.canEnable((XSDConcreteComponent)selectedObject);
        }
        if (selectedObject instanceof Node) {
            Node node = (Node)selectedObject;
            XSDSchema xsdSchema = this.getSchema();
            if (xsdSchema != null) {
                XSDConcreteComponent concreteComponent = xsdSchema.getCorrespondingComponent(node);
                return this.canEnable(concreteComponent);
            }
        }
        return false;
    }

    public void run() {
        DocumentImpl doc = (DocumentImpl)this.fSelectedComponent.getElement().getOwnerDocument();
        doc.getModel().beginRecording((Object)this, this.getText());
        MakeLocalElementGlobalCommand command = new MakeLocalElementGlobalCommand((XSDConcreteComponent)this.fSelectedComponent);
        command.run();
        doc.getModel().endRecording((Object)this);
    }
}

