/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.SelectionDispatchAction;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameRefactoringWizard;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameResourceProcessor;

public class RenameResourceAction
extends SelectionDispatchAction {
    public RenameResourceAction(ISelectionProvider selectionProvider) {
        super(selectionProvider);
    }

    public void selectionChanged(IStructuredSelection selection) {
        IResource element = RenameResourceAction.getResource(selection);
        if (element == null) {
            this.setEnabled(false);
        } else {
            RenameResourceProcessor processor = new RenameResourceProcessor(element);
            this.setEnabled(processor.isApplicable());
        }
    }

    public void run(IStructuredSelection selection) {
        IResource resource = RenameResourceAction.getResource(selection);
        RenameResourceProcessor processor = new RenameResourceProcessor(resource);
        if (!processor.isApplicable()) {
            return;
        }
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        try {
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)refactoring, RefactoringMessages.getString("RenameComponentWizard.defaultPageTitle"), RefactoringMessages.getString("RenameComponentWizard.inputPage.description"), null);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            op.run(XSDEditorPlugin.getShell(), wizard.getDefaultPageTitle());
            op.getInitialConditionCheckingStatus();
        }
        catch (InterruptedException interruptedException) {}
    }

    private static IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IResource)) {
            return null;
        }
        return (IResource)first;
    }
}

