/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.delete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.BaseGlobalCleanup;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;

public class GlobalAttributeCleanup
extends BaseGlobalCleanup {
    protected String replacementName = null;

    public GlobalAttributeCleanup(XSDConcreteComponent deletedItem) {
        super(deletedItem);
    }

    protected String getReplacementElementName() {
        if (this.replacementName == null) {
            TypesHelper helper = new TypesHelper(this.schema);
            List elements = helper.getGlobalAttributes();
            String deletedName = this.getDeletedQName();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (name.equals(deletedName)) continue;
                this.replacementName = name;
                break;
            }
        }
        return this.replacementName;
    }

    public void visitComplexTypeDefinition(XSDComplexTypeDefinition type) {
        super.visitComplexTypeDefinition(type);
        if (type.getAttributeContents() != null) {
            Iterator iter = type.getAttributeContents().iterator();
            while (iter.hasNext()) {
                XSDAttributeUse attrUse;
                XSDAttributeDeclaration attrDecl;
                XSDAttributeGroupContent attrGroupContent = (XSDAttributeGroupContent)iter.next();
                if (!(attrGroupContent instanceof XSDAttributeUse) || (attrDecl = (attrUse = (XSDAttributeUse)attrGroupContent).getContent()) == null || !attrDecl.isAttributeDeclarationReference() || !this.deletedItem.equals(attrDecl.getResolvedAttributeDeclaration())) continue;
                if (this.getReplacementElementName() != null) {
                    String msg = XSDEditorPlugin.getPlugin().getString("_UI_WARNING_RESET_ATTR_REF", this.getReplacementElementName());
                    this.addMessage(msg, (XSDConcreteComponent)attrUse);
                    attrUse.getElement().setAttribute("ref", this.getReplacementElementName());
                    continue;
                }
                String name = this.getNamedComponentName((XSDConcreteComponent)type);
                String msg = XSDEditorPlugin.getPlugin().getString("_UI_WARNING_REMOVE_ATTR_REF", name);
                this.addMessage(msg, attrUse.getContainer());
                this.childrenToRemove.add(attrDecl.getElement());
            }
        }
    }
}

