/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.extension;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateModuleCommand;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class PreServiceAssembleCommand
extends AbstractDataModelOperation {
    private IWebService webService_;
    private String project_;
    private String module_;
    private String earProject_;
    private String ear_;
    private String j2eeLevel_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.earProject_ == null) {
            return Status.OK_STATUS;
        }
        CreateModuleCommand command = new CreateModuleCommand();
        command.setProjectName(this.earProject_);
        command.setModuleName(this.ear_);
        command.setModuleType(8);
        command.setServerFactoryId(this.webService_.getWebServiceInfo().getServerFactoryId());
        command.setServerInstanceId(this.webService_.getWebServiceInfo().getServerInstanceId());
        command.setJ2eeLevel(this.j2eeLevel_);
        command.setEnvironment(environment);
        IStatus status = command.execute(monitor, null);
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
            return status;
        }
        AssociateModuleWithEARCommand associateCommand = new AssociateModuleWithEARCommand();
        associateCommand.setProject(this.project_);
        associateCommand.setModule(this.module_);
        associateCommand.setEARProject(this.earProject_);
        associateCommand.setEar(this.ear_);
        associateCommand.setEnvironment(environment);
        status = associateCommand.execute(monitor, null);
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }

    public void setProject(String project) {
        this.project_ = project;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setEarProject(String earProject) {
        this.earProject_ = earProject;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setJ2eeLevel(String j2eeLevel) {
        this.j2eeLevel_ = j2eeLevel;
    }

    public void setWebService(IWebService webService) {
        this.webService_ = webService;
    }
}

