/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.common.FacetMatcher;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class FacetUtils {
    public static IProject[] getAllProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> validProjects = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            try {
                IFacetedProject facProject = ProjectFacetsManager.create((IProject)projects[i]);
                if (facProject != null) {
                    validProjects.add(projects[i]);
                } else {
                    IJavaProject javaProject = null;
                    javaProject = JavaCore.create((IProject)projects[i]);
                    if (javaProject != null) {
                        validProjects.add(projects[i]);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return validProjects.toArray(new IProject[0]);
    }

    public static Set getFacetsForProject(String projectName) {
        Set facetVersions = null;
        IProject project = ProjectUtilities.getProject((String)projectName);
        if (project != null && project.exists()) {
            try {
                IFacetedProject fproject = ProjectFacetsManager.create((IProject)project);
                if (fproject != null) {
                    facetVersions = fproject.getProjectFacets();
                } else {
                    IJavaProject javaProject = null;
                    javaProject = JavaCore.create((IProject)project);
                    if (javaProject != null) {
                        facetVersions = FacetUtils.getFacetsForJavaProject(javaProject);
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return facetVersions;
    }

    public static Set getTemplates(RequiredFacetVersion[] requiredFacetVersions) {
        HashSet<IFacetedProjectTemplate> templates = new HashSet<IFacetedProjectTemplate>();
        Iterator itr = ProjectFacetsManager.getTemplates().iterator();
        while (itr.hasNext()) {
            Set initial;
            FacetMatcher fm;
            IFacetedProjectTemplate template = (IFacetedProjectTemplate)itr.next();
            String templateId = template.getId();
            if (templateId.indexOf("ear") != -1 || templateId.indexOf("wst.web") != -1 || !(fm = FacetUtils.match(requiredFacetVersions, initial = FacetUtils.getInitialFacetVersionsFromTemplate(templateId))).isMatch()) continue;
            templates.add(template);
        }
        return templates;
    }

    public static Set getInitialFacetVersionsFromTemplate(String templateId) {
        IFacetedProjectTemplate template = ProjectFacetsManager.getTemplate((String)templateId);
        Set fixedFacets = template.getFixedProjectFacets();
        HashSet<IProjectFacetVersion> initial = new HashSet<IProjectFacetVersion>();
        Iterator itr2 = fixedFacets.iterator();
        while (itr2.hasNext()) {
            IProjectFacet facet = (IProjectFacet)itr2.next();
            IProjectFacetVersion highestFacetVersion = null;
            try {
                highestFacetVersion = FacetUtils.isJavaFacet(facet) ? facet.getVersion("1.4") : facet.getLatestVersion();
            }
            catch (VersionFormatException versionFormatException) {
            }
            catch (CoreException coreException) {}
            initial.add(highestFacetVersion);
        }
        return initial;
    }

    public static String[] getTemplateLabels(String[] templateIds) {
        String[] labels = new String[templateIds.length];
        int i = 0;
        while (i < templateIds.length) {
            IFacetedProjectTemplate template = ProjectFacetsManager.getTemplate((String)templateIds[i]);
            labels[i] = template.getLabel();
            ++i;
        }
        return labels;
    }

    public static String getTemplateIdByLabel(String templateLabel) {
        Iterator itr = ProjectFacetsManager.getTemplates().iterator();
        while (itr.hasNext()) {
            IFacetedProjectTemplate template = (IFacetedProjectTemplate)itr.next();
            if (!template.getLabel().equals(templateLabel)) continue;
            return template.getId();
        }
        return "";
    }

    public static String getTemplateLabelById(String templateId) {
        IFacetedProjectTemplate template = ProjectFacetsManager.getTemplate((String)templateId);
        return template.getLabel();
    }

    public static Set getInstallActions(Set projectFacetVersions) {
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        Iterator facets = projectFacetVersions.iterator();
        while (facets.hasNext()) {
            IProjectFacetVersion fv = (IProjectFacetVersion)facets.next();
            IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, fv, null);
            actions.add(action);
        }
        return actions;
    }

    public static FacetMatcher match(RequiredFacetVersion[] requiredFacetVersions, Set projectFacetVersions) {
        FacetMatcher fm = new FacetMatcher();
        HashSet<IProjectFacetVersion> facetsToAdd = new HashSet<IProjectFacetVersion>();
        HashSet<IProjectFacetVersion> facetsThatMatched = new HashSet<IProjectFacetVersion>();
        int i = 0;
        while (i < requiredFacetVersions.length) {
            RequiredFacetVersion rfv = requiredFacetVersions[i];
            IProjectFacetVersion rpfv = rfv.getProjectFacetVersion();
            String rid = rpfv.getProjectFacet().getId();
            String rv = rpfv.getVersionString();
            boolean facetPresent = false;
            Iterator itr = projectFacetVersions.iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion pfv = (IProjectFacetVersion)itr.next();
                String id = pfv.getProjectFacet().getId();
                String version = pfv.getVersionString();
                if (!rid.equals(id)) continue;
                if (rv.equals(version)) {
                    facetPresent = true;
                    facetsThatMatched.add(pfv);
                    break;
                }
                if (!rfv.getAllowNewer() || !FacetUtils.greaterThan(version, rv)) break;
                facetPresent = true;
                facetsThatMatched.add(pfv);
                break;
            }
            if (!facetPresent) {
                facetsToAdd.add(rpfv);
            }
            ++i;
        }
        if (facetsToAdd.size() > 0) {
            Set actions = FacetUtils.getInstallActions(facetsToAdd);
            if (ProjectFacetsManager.check((Set)projectFacetVersions, (Set)actions).getSeverity() == 0) {
                fm.setMatch(true);
                fm.setFacetsThatMatched(facetsThatMatched);
                fm.setFacetsToAdd(facetsToAdd);
            } else {
                fm.setMatch(false);
            }
        } else {
            fm.setMatch(true);
            fm.setFacetsThatMatched(facetsThatMatched);
            fm.setFacetsToAdd(facetsToAdd);
        }
        return fm;
    }

    /*
     * Unable to fully structure code
     */
    public static IStatus addRequiredFacetsToProject(IProject project, RequiredFacetVersion[] rfvs, IProgressMonitor monitor) {
        block6: {
            status = Status.OK_STATUS;
            facetsToAdd = null;
            try {
                fProject = ProjectFacetsManager.create((IProject)project);
                if (fProject != null && (projectFacetMatcher = FacetUtils.match(rfvs, projectFacetVersions = fProject.getProjectFacets())).isMatch() && (facetsToAdd = projectFacetMatcher.getFacetsToAdd()).size() > 0) {
                    actions = FacetUtils.getInstallActions(facetsToAdd);
                    fProject.modify(actions, monitor);
                }
                break block6;
            }
            catch (CoreException v0) {
                if (!project.exists()) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_DOES_NOT_EXIST, (Object[])new String[]{project.getName()}));
                    break block6;
                }
                if (!project.isOpen()) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_IS_NOT_OPEN, (Object[])new String[]{project.getName()}));
                    break block6;
                }
                itr = facetsToAdd.iterator();
                size = facetsToAdd.size();
                if (size <= 0) break block6;
                firstProjectFacetVersion = (IProjectFacetVersion)itr.next();
                facetList = firstProjectFacetVersion.getProjectFacet().getLabel();
                ** while (itr.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                pfv = (IProjectFacetVersion)itr.next();
                pfvLabel = pfv.getProjectFacet().getLabel();
                facetList = NLS.bind((String)ConsumptionMessages.MSG_FACETS, (Object[])new String[]{facetList, pfvLabel});
                continue;
            }
lbl26:
            // 1 sources

            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADDING_FACETS_TO_PROJECT, (Object[])new String[]{project.getName(), facetList}));
        }
        return status;
    }

    public static Set getFacetsForJavaProject(IJavaProject javaProject) {
        HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
        String jdkComplianceLevel = null;
        if (javaProject != null && (jdkComplianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", false)) == null && (jdkComplianceLevel = (String)JavaCore.getDefaultOptions().get("org.eclipse.jdt.core.compiler.compliance")) == null) {
            jdkComplianceLevel = "1.4";
        }
        IProjectFacet javaFacet = ProjectFacetsManager.getProjectFacet((String)"jst.java");
        IProjectFacetVersion javaFacetVersion = null;
        javaFacetVersion = jdkComplianceLevel.equals("1.3") ? javaFacet.getVersion("1.3") : (jdkComplianceLevel.equals("1.4") ? javaFacet.getVersion("1.4") : (jdkComplianceLevel.equals("1.5") ? javaFacet.getVersion("5.0") : javaFacet.getVersion("1.4")));
        facets.add(javaFacetVersion);
        IProjectFacet utilityFacet = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
        IProjectFacetVersion utilityFacetVersion = null;
        try {
            utilityFacetVersion = utilityFacet.getLatestVersion();
        }
        catch (CoreException coreException) {}
        if (utilityFacetVersion != null) {
            facets.add(utilityFacetVersion);
        }
        return facets;
    }

    public static Set getRuntimes(RequiredFacetVersion[] requiredFacetVersions) {
        ArrayList listOfFacetSets = new ArrayList();
        HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
        int javaFacetIndex = -1;
        int i = 0;
        while (i < requiredFacetVersions.length) {
            IProjectFacetVersion pfv = requiredFacetVersions[i].getProjectFacetVersion();
            if (FacetUtils.isJavaFacet(pfv.getProjectFacet())) {
                javaFacetIndex = i;
            }
            facets.add(requiredFacetVersions[i].getProjectFacetVersion());
            ++i;
        }
        listOfFacetSets.add(facets);
        if (javaFacetIndex > -1) {
            ArrayList<String> permittedJavaVersions = new ArrayList<String>();
            RequiredFacetVersion rfv = requiredFacetVersions[javaFacetIndex];
            if (rfv.getAllowNewer()) {
                String version = rfv.getProjectFacetVersion().getVersionString();
                Set allVersions = rfv.getProjectFacetVersion().getProjectFacet().getVersions();
                Iterator itr = allVersions.iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion thisPfv = (IProjectFacetVersion)itr.next();
                    String thisVersion = thisPfv.getVersionString();
                    if (!FacetUtils.greaterThan(thisVersion, version)) continue;
                    permittedJavaVersions.add(thisVersion);
                }
                String[] javaVersions = permittedJavaVersions.toArray(new String[0]);
                int j = 0;
                while (j < javaVersions.length) {
                    HashSet<IProjectFacetVersion> thisFacetSet = new HashSet<IProjectFacetVersion>();
                    int k = 0;
                    while (k < requiredFacetVersions.length) {
                        IProjectFacetVersion pfv;
                        if (k == javaFacetIndex) {
                            pfv = requiredFacetVersions[k].getProjectFacetVersion().getProjectFacet().getVersion(javaVersions[j]);
                            thisFacetSet.add(pfv);
                        } else {
                            pfv = requiredFacetVersions[k].getProjectFacetVersion();
                            thisFacetSet.add(pfv);
                        }
                        ++k;
                    }
                    listOfFacetSets.add(thisFacetSet);
                    ++j;
                }
            }
        }
        return FacetUtils.getRuntimes(listOfFacetSets.toArray(new Set[0]));
    }

    public static Set getRuntimes(Set[] facetSets) {
        HashSet<IRuntime> unionSet = new HashSet<IRuntime>();
        int i = 0;
        while (i < facetSets.length) {
            Set facets = facetSets[i];
            Set runtimes = RuntimeManager.getRuntimes((Set)facets);
            Iterator itr = runtimes.iterator();
            while (itr.hasNext()) {
                IRuntime runtime = (IRuntime)itr.next();
                if (unionSet.contains(runtime)) continue;
                unionSet.add(runtime);
            }
            ++i;
        }
        return unionSet;
    }

    public static boolean doesRuntimeSupportFacets(IRuntime facetRuntime, Set projectFacetVersions) {
        Set runtimes = RuntimeManager.getRuntimes((Set)projectFacetVersions);
        Iterator itr = runtimes.iterator();
        while (itr.hasNext()) {
            IRuntime runtime = (IRuntime)itr.next();
            if (!runtime.getName().equals(facetRuntime.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean greaterThan(String versionA, String versionB) {
        int sizeB;
        StringTokenizer stA = new StringTokenizer(versionA, ".");
        StringTokenizer stB = new StringTokenizer(versionB, ".");
        int sizeA = stA.countTokens();
        int size = sizeA < (sizeB = stB.countTokens()) ? sizeA : sizeB;
        int i = 0;
        while (i < size) {
            int b;
            int a = Integer.parseInt(stA.nextToken());
            if (a != (b = Integer.parseInt(stB.nextToken()))) {
                return a > b;
            }
            ++i;
        }
        return sizeA > sizeB;
    }

    public static boolean isJavaFacet(IProjectFacet pf) {
        return pf.getId().equals("jst.java");
    }

    public static boolean isJavaProject(IProject project) {
        try {
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
            if (fProject != null) {
                IProjectFacetVersion pfv;
                if (J2EEUtils.isJavaComponent((IProject)project)) {
                    return true;
                }
                Set facets = fProject.getProjectFacets();
                if (facets.size() == 1 && FacetUtils.isJavaFacet((pfv = (IProjectFacetVersion)facets.iterator().next()).getProjectFacet())) {
                    return true;
                }
            } else {
                IJavaProject javaProject = null;
                javaProject = JavaCore.create((IProject)project);
                if (javaProject != null) {
                    return true;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean isUtilityTemplate(String templateId) {
        return ProjectFacetsManager.isTemplateDefined((String)templateId) && templateId.equals("template.jst.utility");
    }
}

