/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.core.containment.GroupID;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.DDLGenerator;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;

public class OpenAction extends Action {
   
   /**
    * Launch SQL Editor with DDL of the selected object
    */
   public void run(IAction action) {
   	try{    		
   	    init();
   	        		    	      	    
   	    Iterator itSelection = selection.iterator(); 
   	    if (itSelection.hasNext()) { 
   	       Object selectedObject = itSelection.next();
   	       if (selectedObject instanceof SQLObject) {
   	          SQLObject sqlObject = (SQLObject)selectedObject;
   	          DatabaseDefinition dbdef = Utility.getDBDef(database);
   	          DDLGenerator ddlGenerator = dbdef.getDDLGenerator();
   	          
   	          /* save engineering options of ddlGenerator and set all
   	           * options to true in order to create DDL for all elements
   	           */ 
   	          EngineeringOption[] options = ddlGenerator.getOptions();
   	          ArrayList optionsSettings = new ArrayList(options.length);   	          
   	          for (int i = 0; i < options.length; i++){
   	             EngineeringOption option = (EngineeringOption) options[i];
   	             optionsSettings.add(new Boolean(option.getBoolean()));
   	             option.setBoolean(true);
   	          }
   	    		
   	          String[] result = ddlGenerator.createSQLObjects(new SQLObject[] {sqlObject}, true, true, new NullProgressMonitor());
   	            	          
   	          // restore engineering options which were set before
   	          for (int i = 0; i < options.length; i++){
   	             EngineeringOption option = (EngineeringOption) options[i];
   	             option.setBoolean(((Boolean)optionsSettings.get(i)).booleanValue());
   	          }

   	          if (result.length > 0)
   	             launchSQLEditor(result[0],sqlObject.getName());
   	       }
   	    }   	    	   	       
        
   	}catch(Exception e) {
   	    ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0, e.getMessage(), e);    		   	    
   	}        
   }   
   
   public void launchSQLEditor(String ddl, String title) {
      
      getEditorLaunch().launchSQLEditor(ddl, 
                                        Utility.getConnectionInfo(database),
                                        title);
   }
   
    public void selectionChanged(IAction action, ISelection selection) {
        
        super.selectionChanged(action, selection);
        
        if (action.isEnabled() &&
            selection instanceof IStructuredSelection &&
            ((IStructuredSelection)selection).getFirstElement() instanceof EObject ) {
            EObject o = (EObject) ((IStructuredSelection)selection).getFirstElement();
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService(); 
            String groupID = containmentService.getGroupId(o);
            action.setEnabled( (groupID != null) && (groupID.startsWith(GroupID.CORE_PREFIX)) );
        }
    }

}
