/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;
import java.sql.Connection;
import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.CharacterStringDataType;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.server.internal.ui.query.execute.QueryOutputHelper;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

/**
 * @author hkolwalk
 */
public class ShowStatisticsAction implements IViewActionDelegate, IActionDelegate2
{
	private IStructuredSelection selection;
	
	public void init(IViewPart viewPart) {
	}
	
	public void run(IAction action) {
		Connection connection = null;
		
		if ( (this.selection != null) && !this.selection.isEmpty() ) {
			Iterator iter = this.selection.iterator();
			String selectString = "";
			Object selectedObj = iter.next();
			if ( (selectedObj != null) && (selectedObj instanceof ICatalogObject) ) {
				connection = ((ICatalogObject) selectedObj).getConnection();
			}
		
			if (connection != null) {
				if (selectedObj instanceof Table) {
	                selectString += "SELECT CARD, NPAGES, FPAGES, OVERFLOW FROM SYSSTAT.TABLES";
					selectString += " WHERE TABSCHEMA = "  + this.wrapNameSingle(((Table) selectedObj).getSchema().getName());
					selectString += " AND TABNAME = "  + this.wrapNameSingle(((Table) selectedObj).getName());
				}
				else if (selectedObj instanceof Column) {
					selectString += "SELECT SYSSTAT.COLUMNS.COLCARD, SYSSTAT.COLUMNS.AVGCOLLEN, SYSSTAT.COLUMNS.NUMNULLS,";
					if (((Column) selectedObj).getDataType() instanceof CharacterStringDataType) {
						selectString += " SYSSTAT.COLUMNS.SUB_COUNT,";
					}
					selectString += " SYSSTAT.COLDIST.COLVALUE, SYSSTAT.COLDIST.VALCOUNT FROM SYSSTAT.COLUMNS, SYSSTAT.COLDIST";
					selectString += " WHERE SYSSTAT.COLUMNS.TABSCHEMA = "  + this.wrapNameSingle(((Column) selectedObj).getTable().getSchema().getName());
					selectString += " AND SYSSTAT.COLUMNS.TABNAME = "  + this.wrapNameSingle(((Column) selectedObj).getTable().getName());
					selectString += " AND SYSSTAT.COLUMNS.COLNAME = "  + this.wrapNameSingle(((Column) selectedObj).getName());
				}
				else if (selectedObj instanceof Index) {
					selectString += "SELECT NLEAF, NLEVELS, FIRSTKEYCARD, FULLKEYCARD, CLUSTERRATIO, CLUSTERFACTOR,";
					selectString += " SEQUENTIAL_PAGES, DENSITY FROM SYSSTAT.INDEXES";
					selectString += " WHERE INDSCHEMA = "  + this.wrapNameSingle(((Index) selectedObj).getSchema().getName());
					selectString += " AND INDNAME = "  + this.wrapNameSingle(((Index) selectedObj).getName());
				}
				else if (selectedObj instanceof Routine) {
					selectString += "SELECT IOS_PER_INVOC, INSTS_PER_INVOC FROM SYSSTAT.ROUTINES";
					selectString += " WHERE ROUTINESCHEMA = "  + this.wrapNameSingle(((Routine) selectedObj).getSchema().getName());
					selectString += " AND ROUTINENAME = "  + this.wrapNameSingle(((Routine) selectedObj).getName());
				}
				
				QueryOutputHelper queryHelper = new QueryOutputHelper(selectString, connection);
				queryHelper.setObjectName(ResourceLoader.INSTANCE.queryString("_UI_SHOW_STATISTICS_TITLE"));
				queryHelper.runQuery();
			}
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			this.selection = (IStructuredSelection)selection;
			action.setEnabled(false);
			
			Object selectedObj = this.selection.getFirstElement();
			Database database = null;
			if (selectedObj instanceof Column) {
				database = ((Column)selectedObj).getTable().getSchema().getDatabase();
			}
			else if (selectedObj instanceof Table) {
				database = ((Table)selectedObj).getSchema().getDatabase();
			}
			else if (selectedObj instanceof Index) {
				database = ((Index)selectedObj).getSchema().getDatabase();
			}
			else if (selectedObj instanceof Routine) {
				database = ((Routine)selectedObj).getSchema().getDatabase();
			}
			if ( (database != null) && database.getVendor().equalsIgnoreCase("DB2 UDB") ) {
				action.setEnabled(true);
			}
		}
	}

    /**
     * @see org.eclipse.ui.IActionDelegate2#init(org.eclipse.jface.action.IAction)
     */
    public void init(IAction action)
    {
    }

    /**
     * @see org.eclipse.ui.IActionDelegate2#dispose()
     */
    public void dispose()
    {
    }

    /**
     * @see org.eclipse.ui.IActionDelegate2#runWithEvent(org.eclipse.jface.action.IAction, org.eclipse.swt.widgets.Event)
     */
    public void runWithEvent(IAction action, Event event)
    {
        run(action);
    }
    
    private String wrapNameDouble(String name) {
    	return "\"" + name + "\"";
    }
    
    private String wrapNameSingle(String name) {
    	return "\'" + name + "\'";
    }
    
    private String getFullyQualifiedName(Table table) {
    	return this.wrapNameDouble(table.getSchema().getName()) + "." + this.wrapNameDouble(table.getName());
    }
}
