/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.query.execute;

import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.util.RDBCorePluginConstants;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewAPI;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

/*import com.ibm.etools.rdbschema.impl.RDBConnectionImpl;
import com.ibm.etools.rsc.core.ui.RSCCoreUIPlugin;
import com.ibm.etools.rsc.core.ui.wizards.NewConnectionWizard;
import com.ibm.etools.rsc.core.ui.wizards.NewConnectionWizardPage;
import com.ibm.etools.sqlquery.SQLQuery;
import com.ibm.etools.sqlquery.SQLStatement;*/

/**
 * @author joan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class QueryOutputHelper {
  
  //SQLStatement statement = null;	
  Database database = null;
  String objectName = ""; //$NON-NLS-1$
  String statementSource = ""; //$NON-NLS-1$
  OutputItem stmtOutput = null;
  boolean updateOutputItemStatus = true;
  	
  /*public QueryOutputHelper(Object element, Database database)	
  {
  	  if (element instanceof SQLStatement)
  	  {
  	    this.statement = (SQLStatement)element;
  	    statementSource = this.statement.toString();
  	  }
      this.database = database;      
  }

  public QueryOutputHelper(String statementString, RDBConnection connect)	
  {
  	statementSource = statementString;
  	rdbConnection = connect;
  }*/

  public QueryOutputHelper(Connection connection) {
     this.jdbcConnection = connection;
  }

  public QueryOutputHelper(String statementString, Connection connection) {
	  this.statementSource = statementString; 
	  this.jdbcConnection = connection;
  }
  
  protected OutputItem getSQLScrapbookOutputItem() {
  	if (stmtOutput == null)
  	{
  		stmtOutput = new OutputItem(OutputItem.STATUS_START, OutputItem.ACTION_EXECUTE, ResourceLoader.INSTANCE.queryString("_UI_SCRAPBOOK_ITEM_TITLE")); //$NON-NLS-1$
	}
  	return stmtOutput;
  }

  public boolean runSQLScrapbookQuery()
  {
  	ResultSet resultSet;
  	
  	try
  	{
  		//RDBConnection rdbCCopy = rdbConnection.getCopy();
  		//RDBConnectionAPI.getInstance().openConnection(rdbCCopy);

  		//
  		// Loads the jdbc driver
  		//
  		//jdbcConnection = ((RDBConnectionImpl)rdbCCopy).getSQLConnection();


  		if (jdbcConnection != null)
  		{
  			getSQLScrapbookOutputItem().setStatus(OutputItem.STATUS_IN_PROGRESS);

  			try
  			{
  				showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING")); //$NON-NLS-1$
				showMessage(statementSource);

  				Statement stmt = jdbcConnection.createStatement();

  				boolean setLimit = RDBCorePlugin.getDefault().getPluginPreferences().getBoolean(RDBCorePluginConstants.LIMIT_ROWS_RETRIEVED);
  				if (setLimit) {
  					int integer = RDBCorePlugin.getDefault().getPluginPreferences().getInt(RDBCorePluginConstants.MAX_ROW_RETRIEVED);
  					stmt.setMaxRows(integer);
  				}
  				else {
  					stmt.setMaxRows(0); // arg = 0, This will not put a upper limit
  				}
  				int fieldSize = RDBCorePlugin.getDefault().getPluginPreferences().getInt(RDBCorePluginConstants.MAX_LOB_LENGTH);
  				if (fieldSize > 0)
  					stmt.setMaxFieldSize(fieldSize);
  				
  				stmt.execute(statementSource);
  				resultSet = null;

  				resultSet = stmt.getResultSet();

  				
  				if (resultSet != null) // &&
//					  statement instanceof SQLQuery)  // Only shows query results
  				{
  					getOutputItem().setStatus(OutputItem.STATUS_SUCCESS);
  					//jvh - OutputViewAPI.getInstance().updateStatus(getOutputItem(), OutputItem.STATUS_SUCCESS);  // the status changes to success
  					//showMessage(RSCCoreUIPlugin.getString("_UI_MSG_EXE_SUCCESSFUL")); 
					showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_SUCCESSFUL"));  //$NON-NLS-1$
  					
  					//display result set in output view
  					OutputViewAPI.getInstance().showOutputContent(getOutputItem(), resultSet);

  					//  get the number of records in table                  
  					//     if > 1000 records 
  					int numDisplayed = OutputViewAPI.getInstance().getRowCount(stmtOutput);
  					if (numDisplayed >= 1000) 
  					{
  						OutputViewAPI.getInstance().showMessage(getOutputItem() , ResourceLoader.INSTANCE.queryString("_UI_MSG_MAX_RECORD_EXCEEDED"), false); //$NON-NLS-1$
  					}
  					else 
  					{
  						OutputViewAPI.getInstance().showMessage(getOutputItem() , numDisplayed + " " + ResourceLoader.INSTANCE.queryString("_UI_MSG_RECORD_RETURNED"), false); //$NON-NLS-1$ //$NON-NLS-2$
  					}
  					

  					SQLWarning rsWarningMsgs = resultSet.getWarnings();
  					if (rsWarningMsgs != null)
  					{
  						showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), OutputItem.STATUS_WARNING);         //$NON-NLS-1$
  						displayMessages(rsWarningMsgs, getOutputItem());
  					}
  				}  
  				else {
  					getOutputItem().setStatus(OutputItem.STATUS_SUCCESS);
  					showMessage(ResourceLoader.INSTANCE.queryString("_UI_LABEL_EXECUTION_SUCCESSFUL")); //$NON-NLS-1$
  				}
  				
				SQLWarning rsWarningMsgs = stmt.getWarnings();
				if (rsWarningMsgs != null)
				{
					showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), OutputItem.STATUS_WARNING);         //$NON-NLS-1$
					displayMessages(rsWarningMsgs, getOutputItem());
				}
  			}
  			catch (Exception exception)
  			{         
  				showErrors(exception.toString(), OutputItem.STATUS_FAILURE);        
  				return false;
  			}
  			
  		}          
  	}
  	catch (java.util.NoSuchElementException e)
  	{
  		showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), OutputItem.STATUS_FAILURE);         //$NON-NLS-1$
  		return false;
  	}
  	catch (org.eclipse.emf.common.util.WrappedException e)
  	{
  		String msg;
  		if (e.exception() instanceof java.io.FileNotFoundException)
  		{
  			msg = ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE") + "\n\n" + e.exception().toString();             //$NON-NLS-1$ //$NON-NLS-2$
  		}
  		else
  		{
  			msg = e.toString();
  		}
  		showErrors(msg, OutputItem.STATUS_FAILURE);        
  		return false;
  	}
  	catch (Exception e)
  	{
  		showErrors(e.toString(), OutputItem.STATUS_FAILURE);        
  		return false;
  	}
  	return true;
  } 
  
public boolean runQuery()
{
   ResultSet resultSet;
   //String stmtName = statement.getName();
   
   try { 
   	/*  if (getDatabase().getConnection().size() == 0)  // if there is no connection
   		{
            connectionExists = false;
            
            //Set known values for connection, ie. the database name
            //Need to set the attributes of a RDBConnection and pass into the wizard but
            //the api is not very friendly.  See defect 186217

            //RDBConnection rdbC = RSCCoreUIPlugin.getRSCCoreUIPlugin().getRDBSchemaFactory().createRDBConnection();
            //rdbC.setDbName(getDomainModel().getDatabase().getName());
            //NewConnectionWizard wizard = new NewConnectionWizard(rdbC, false);

            RDBConnection rdbC = null;
            NewConnectionWizard wizard = new NewConnectionWizard(null, true, NewConnectionWizardPage.SHOWCONS_OPTION);
            wizard.setLoadMetadata(false);

            wizard.init(PlatformUI.getWorkbench(), null);
            wizard.setNeedsProgressMonitor(true);
            WizardDialog dialog = new WizardDialog(getShell(), wizard);
            dialog.create();
            dialog.getShell().setText(RSCCoreUIPlugin.getString("_UI_DIALOG_CONNECTION_TITLE"));
            int rc = dialog.open();
            rdbC = wizard.getConnection();
            if (rc == WizardDialog.CANCEL)
            {
              return false;
            }

            if (rdbC != null)
            {
              jdbcConnection = ((RDBConnectionImpl)rdbC).getSQLConnection();
              try
              {
                // want to add a copy of the rdb to the current database
                //  for this execute
                RDBConnection rdbCCopy = rdbC.getCopy();
                getDatabase().getConnection().add(rdbCCopy);
                RDBConnectionAPI.getInstance().saveDatabaseConnections(getDatabase());
              }
              catch(Exception e)
              {
                RSCCoreUIPlugin.getRSCCoreUIPlugin().getLogger().write("###Error..GenerateXMLAction::generate()..Cannot save database");
              }
            }
         }*/

         /*if (connectionExists)
         {
           jdbcConnection = getConnection();
         }*/    

          if (jdbcConnection != null)
          {
            getOutputItem().setStatus(OutputItem.STATUS_IN_PROGRESS);
            boolean continueExecution = substituteParameters(getOutputItem());
            if (continueExecution)
            {
              try
              {
                showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING"));   //$NON-NLS-1$
                showMessage(/*statement.toString()*/this.statementSource);

                Statement stmt = jdbcConnection.createStatement();

                boolean setLimit = RDBCorePlugin.getDefault().getPluginPreferences().getBoolean(RDBCorePluginConstants.LIMIT_ROWS_RETRIEVED);
  				if (setLimit) {
  					int integer = RDBCorePlugin.getDefault().getPluginPreferences().getInt(RDBCorePluginConstants.MAX_ROW_RETRIEVED);
  					stmt.setMaxRows(integer);
  				}
  				else {
  					stmt.setMaxRows(0); // arg = 0, This will not put a upper limit
  				}
  				int fieldSize = RDBCorePlugin.getDefault().getPluginPreferences().getInt(RDBCorePluginConstants.MAX_LOB_LENGTH);
  				if (fieldSize > 0)
  					stmt.setMaxFieldSize(fieldSize);

                stmt.execute(statementSource);
                resultSet = null;
                //if (statement instanceof SQLQuery)
                //{
                  resultSet = stmt.getResultSet();
                //}                
                
                if (resultSet != null /*&&
                    statement instanceof SQLQuery*/)  // Only shows query results
                {
                   getOutputItem().setStatus(OutputItem.STATUS_SUCCESS);
                   //jvh - OutputViewAPI.getInstance().updateStatus(getOutputItem(), OutputItem.STATUS_SUCCESS);  // the status changes to success
                   showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_SUCCESSFUL"));   //$NON-NLS-1$
                  
                  //display result set in output view
                  OutputViewAPI.getInstance().showOutputContent(getOutputItem(), resultSet);

                  //  get the number of records in table                  
                  //     if > 1000 records 
                  int numDisplayed = OutputViewAPI.getInstance().getRowCount(stmtOutput);
                  if (numDisplayed >= 1000) 
                  {
                    OutputViewAPI.getInstance().showMessage(getOutputItem() , ResourceLoader.INSTANCE.queryString("_UI_MSG_MAX_RECORD_EXCEEDED"), false); //$NON-NLS-1$
                  }
                  else 
                  {
                    OutputViewAPI.getInstance().showMessage(getOutputItem() , numDisplayed + " " + ResourceLoader.INSTANCE.queryString("_UI_MSG_RECORD_RETURNED"), false);  //$NON-NLS-1$//$NON-NLS-2$
                  }
                  

                  SQLWarning rsWarningMsgs = resultSet.getWarnings();
                  if (rsWarningMsgs != null)
                  {
                    showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), OutputItem.STATUS_WARNING);         //$NON-NLS-1$
                    displayMessages(rsWarningMsgs, getOutputItem());
                  }
                }  
                /*else if (!(statement instanceof SQLQuery))
                {
                   getOutputItem().setStatus(OutputItem.STATUS_SUCCESS);
                   showMessage(RSCCoreUIPlugin.getString("_UI_LABEL_EXECUTION_SUCCESSFUL"));
                }*/
              }
              catch (Exception exception)
              {         
                showErrors(exception.toString(), OutputItem.STATUS_FAILURE);        
                return false;
              }
            }
          }          
        }
        catch (java.util.NoSuchElementException e)
        {
           showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), OutputItem.STATUS_FAILURE);         //$NON-NLS-1$
           return false;
        }
        catch (org.eclipse.emf.common.util.WrappedException e)
        {
          String msg;
          if (e.exception() instanceof java.io.FileNotFoundException)
          {
            msg = ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE") + "\n\n" + e.exception().toString();              //$NON-NLS-1$//$NON-NLS-2$
          }
          else
          {
            msg = e.toString();
          }
          showErrors(msg, OutputItem.STATUS_FAILURE);        
          return false;
        }
        catch (Exception e)
        {
          showErrors(e.toString(), OutputItem.STATUS_FAILURE);        
          return false;
        }
   return true;
}

  protected void displayMessages(SQLWarning except, OutputItem outputItem)
  {
    String reason = ""; //$NON-NLS-1$
    if (except instanceof DataTruncation)
    {
      reason = ResourceLoader.INSTANCE.queryString("_WARN_DATA_WAS_TRUNCATED"); //$NON-NLS-1$
    }
    else
    {
      reason = ResourceLoader.INSTANCE.queryString("_WARN_SQL_WARNINGS_FOUND"); //$NON-NLS-1$
    }
    OutputViewAPI.getInstance().showMessage(outputItem, reason, false);

    do
    {
      OutputViewAPI.getInstance().showMessage(outputItem, "SQLState=" + except.getSQLState() + " " + except.getMessage(), false); //$NON-NLS-1$ //$NON-NLS-2$
      except = except.getNextWarning();
    }
    while (except != null);
  }

  public Database getDatabase()
  {
    return database;
  }

  protected Connection jdbcConnection;
  
    /**
   * Get a JDBC Connection object for the connection to the database
   * If not exist, make it live from the database
   */
  public Connection getConnection() throws SQLException, Exception
  {
    if (jdbcConnection == null)
    {
      makeLiveConnection();
    }
    return jdbcConnection;
  }
  
  /**
   * Make a live JDBC connection
   * We need to do a dynamic class load if we specified the DB2 driver in a db2 plugin.xml.
   */
  private void makeLiveConnection()
          throws SQLException, Exception
  {
    /*RDBConnection rdbConnect = getRDBConnection();

    if (rdbConnect == null)
    {
      RSCCoreUIPlugin.getRSCCoreUIPlugin().getLogger().write("makeLiveConnection error on database.." + getDatabase().getName() );
      return;
    }

    String userid = rdbConnect.getUserid();
    String password = rdbConnect.getPassword();
    String jdbcDriver = rdbConnect.getOtherDriver();
    String jdbcDriverLocation = rdbConnect.getClassLocation();
    String url = getDatabase().getJDBCUrl();

    RDBConnectionAPI.getInstance().openConnection(rdbConnect);

    //
    // Loads the jdbc driver
    //
    jdbcConnection = ((RDBConnectionImpl)rdbConnect).getSQLConnection();*/
  }

  //protected RDBConnection rdbConnection;
  /**
   * Get the MOF RDBConnection object
   */
  /*public RDBConnection getRDBConnection()
  {
    if (rdbConnection == null)
    {
      Iterator iterator = getDatabase().getConnection().iterator();
      rdbConnection = (RDBConnection) iterator.next();
    }
    return rdbConnection;
  }*/
  
  /**
   * Substitute the parameter values
   */
  private boolean substituteParameters(OutputItem outputItem)
  {
    /*ParameterMarkers pm = new ParameterMarkers(statement);
    String result = pm.substituteParameters();
    statementSource = result;
    if (!statementSource.equals(""))
    {
    Vector parameterValues = pm.getMarkerValues();
    Vector parameterNames = statement.getParameterMarkers();
    Vector parameterVector = new Vector();
     for (int i=0; i < parameterNames.size(); i++)
     {
       String[] parameters =  new String[3];  
       parameters[0] = parameterNames.elementAt(i).toString();
       parameters[1] = parameterValues.elementAt(i).toString();         
       parameters[2] = "";
       parameterVector.add(parameters);            
     }
     OutputViewAPI.getInstance().showParameters(outputItem, parameterVector);
    }
    return pm.getContinueExecution();   */
    return true; 
  }
  
  Shell getShell()
  {
    return
      OutputViewPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
  }
  
  public void setObjectName(String objectName)
  {
      //statement.setName(objectName);
  	  this.objectName = objectName;
  }  

  protected void showErrors(String error, int newStatus)
  {
     if (updateOutputItemStatus)
        OutputViewAPI.getInstance().updateStatus(getOutputItem(), newStatus);
     OutputViewAPI.getInstance().showMessage(getOutputItem() , error, false); 
  }
  
  protected OutputItem getOutputItem()
  {
    if (stmtOutput == null)
    {
       stmtOutput = new OutputItem(OutputItem.STATUS_START, OutputItem.ACTION_EXECUTE, /*statement.getName()*/this.objectName);
    }
    return stmtOutput;
  }
  public void setOutputItem(OutputItem stmtOutput) {
     this.stmtOutput = stmtOutput;
  }

  public boolean isUpdateOutputItemStatus() {
     return updateOutputItemStatus;
  }

  public void setUpdateOutputItemStatus(boolean updateOutputItemStatus) {
     this.updateOutputItemStatus = updateOutputItemStatus;
  }

  public void setStatement(String statementSource) {
     this.statementSource = statementSource;
  }
  
  public void showMessage(String messageText)
  {
      OutputViewAPI.getInstance().showMessage(getOutputItem(), messageText, false);
  }
  
  protected OutputItem getDDLExecutionOutputItem(String source) {
  	if (stmtOutput == null)
  	{
  		stmtOutput = new OutputItem(OutputItem.STATUS_START, OutputItem.ACTION_EXECUTE,  source);
	}
  	return stmtOutput;
  }

  public boolean executeDDL(String source)
  { 	
  	try
  	{
  		if (jdbcConnection != null)
  		{
  		   if (updateOutputItemStatus)
  		      getDDLExecutionOutputItem(source).setStatus(OutputItem.STATUS_IN_PROGRESS);

  			try
  			{
  				showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING")); //$NON-NLS-1$
				showMessage(statementSource);

  				Statement stmt = jdbcConnection.createStatement();
  				
  				stmt.execute(statementSource);
  				if (updateOutputItemStatus)
  				   getOutputItem().setStatus(OutputItem.STATUS_SUCCESS);
  				showMessage(ResourceLoader.INSTANCE.queryString("_UI_LABEL_EXECUTION_SUCCESSFUL")); //$NON-NLS-1$
  			}
  			catch (Exception exception)
  			{         
  				showErrors(exception.toString(), OutputItem.STATUS_FAILURE);        
  				return false;
  			}
  			
  		}          
  	}
  	catch (java.util.NoSuchElementException e)
  	{
  		showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), OutputItem.STATUS_FAILURE);         //$NON-NLS-1$
  		return false;
  	}
  	catch (org.eclipse.emf.common.util.WrappedException e)
  	{
  		String msg;
  		if (e.exception() instanceof java.io.FileNotFoundException)
  		{
  			msg = ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE") + "\n\n" + e.exception().toString();             //$NON-NLS-1$ //$NON-NLS-2$
  		}
  		else
  		{
  			msg = e.toString();
  		}
  		showErrors(msg, OutputItem.STATUS_FAILURE);        
  		return false;
  	}
  	catch (Exception e)
  	{
  		showErrors(e.toString(), OutputItem.STATUS_FAILURE);        
  		return false;
  	}
  	return true;
  } 
}
