/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.views.extensions;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;

/**
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class NavigatorContentProvider implements INavigatorContentProvider {

	private final ITreeContentProvider contentProvider; 

	/**
	 *  
	 */
	public NavigatorContentProvider(ITreeContentProvider aContentProvider) {
		super();
		contentProvider = aContentProvider; 
	}

	/**
	 *  
	 */
	public void dispose() {
		contentProvider.dispose();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object anObject) {
		return contentProvider.equals(anObject);
	}

	/**
	 * @param aParentElement
	 * @return
	 */
	public Object[] getChildren(Object aParentElement) {
		return contentProvider.getChildren(aParentElement);
	}

	/**
	 * @param anInputElement
	 * @return
	 */
	public Object[] getElements(Object anInputElement) {
		return contentProvider.getElements(anInputElement);
	}

	/**
	 * @param anElement
	 * @return
	 */
	public Object getParent(Object anElement) {
		return contentProvider.getParent(anElement);
	}

	/**
	 * @param anElement
	 * @return
	 */
	public boolean hasChildren(Object anElement) {
		return contentProvider.hasChildren(anElement);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return contentProvider.hashCode();
	}

	/**
	 * @param aViewer
	 * @param anOldInput
	 * @param aNewInput
	 */
	public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
		contentProvider.inputChanged(aViewer, anOldInput, aNewInput);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return contentProvider.toString();
	}
	
	public ITreeContentProvider getDelegateContentProvider() {
		return contentProvider;
	}
}
