/*******************************************************************************
 * Copyright (c) 2004, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.core.internal.ui.services;

import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IEditorPart;

/**
 * @author ljulien
 */
public interface IMarkerNavigationSelectionProvider
{
    /**
     * Clients should used the "com.ibm.datatools.core.ui.markerNavigationProvider" extension point
     * Will be implemented by clients of wants to provide selection for Marker Navigation
     * @param the object associated with the Marker that should be selected
     * @return true if the client did select an object
     */
    public boolean provides (IEditorPart editor, IMarker marker);
    public void doGotoMarker(IMarker marker);
}
