/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.dialogs;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ImagePath;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;


/**
 * @author ljulien
 */
public class ConnectedServerDialog extends Dialog
{
	private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
	private static final String HEADER_TITLE = resourceLoader
			.queryString("DATATOOLS.SERVER.UI.DISCONNECT_SERVER_TITLE");
	private static final String SERVER_SELECTION = resourceLoader
			.queryString("DATATOOLS.SERVER.UI.DISCONNECT_SERVER_SELECTION");
	private static final String CONNECTED_SERVERS = resourceLoader
			.queryString("DATATOOLS.SERVER.UI.DISCONNECT_CONNECTED_SERVERS");

	private List selection = new LinkedList ();

	private Tree tree;

	/**
	 * @param parentShell
	 */
	public ConnectedServerDialog()
	{
		super(Display.getCurrent().getActiveShell());
		this.setShellStyle(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL | SWT.BORDER);
	}

	/**
	 * Will present the servers available to the user for disconnection
	 * @param parentComposite
	 */
	private void createTreeDialogArea(Composite composite)
	{
		Composite parentComposite = new Composite (composite, SWT.NONE);
		parentComposite.setLayout(new GridLayout());
		parentComposite.setLayoutData(new GridData (GridData.FILL_BOTH));
		parentComposite.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		
		tree = new Tree(parentComposite, SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL);
		tree.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		tree.addSelectionListener(new SelectionListener ()
		{
			public void widgetSelected(SelectionEvent e)
			{
				TreeItem item = (TreeItem) e.item;
				if (item.getData() != null && item.getData() instanceof IConnectionNode)
				{
					selection.add(item.getData());
				}
			}

			public void widgetDefaultSelected(SelectionEvent e)
			{
				TreeItem item = (TreeItem) e.item;
				if (item.getData() != null && item.getData() instanceof IConnectionNode && selection.contains(item.getData()))
				{
					selection.remove(item.getData());
				}
			}
		});
		
		IConnectionNode[] connectedServers = IServicesManager.INSTANCE.getServerExplorerContentService().getAllConnectedServers();
		TreeItem root = new TreeItem(tree, SWT.NONE);
		root.setText(CONNECTED_SERVERS);
		root.setImage(resourceLoader.queryImageFromRegistry(ImagePath.CONNECTION_FOLDER));

		for (int i = 0, n = connectedServers.length; i < n; i++)
		{
			IConnectionNode server = connectedServers[i];
			TreeItem item = new TreeItem(root, SWT.NONE);
			item.setData(server);
			item.setText(server.getDisplayName());
			item.setImage(resourceLoader.queryImageFromRegistry(ImagePath.CONNECTION));
			tree.showItem(item);
		}
		
	}

	/**
	 * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
	 */
	protected void configureShell(Shell shell)
	{
		super.configureShell(shell);
		shell.setText(HEADER_TITLE);
		shell.setImage(resourceLoader.queryImageFromRegistry(ImagePath.SERVER_EXPLORER));
	}

	/**
	 * @see org.eclipse.jface.dialogs.Dialog#buttonPressed(int)
	 */
	protected void buttonPressed(int buttonId)
	{
		super.buttonPressed(buttonId);
	}

	/**
	 * Will provide the controls for this composite
	 * 
	 * @param parentComposite
	 */
	protected Control createDialogArea(Composite parent)
	{
		Composite parentComposite = new Composite(parent, SWT.NONE);
		GridLayout gridLayout = new GridLayout();

		gridLayout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
		gridLayout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
		gridLayout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
		gridLayout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);

		parentComposite.setLayout(gridLayout);
		GridData data = new GridData(GridData.FILL_BOTH);
		data.widthHint = 300;
		data.heightHint = 150;
		parentComposite.setLayoutData(data);

		Label label = new Label(parentComposite, SWT.NONE);
		label.setText(SERVER_SELECTION);
		label.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		createTreeDialogArea(parentComposite);

		return parentComposite;
	}

	/**
	 * @return Array of Servers to Disconnect
	 */
	public IConnectionNode[] getSelectedServers()
	{
		return (IConnectionNode[]) selection.toArray(new IConnectionNode[selection.size()]);
	}

}
