/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonNavigator;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerExplorerViewPart;

/**
 * @author ljulien
 */
public class ServerExplorerNav extends CommonNavigator implements IServerExplorerViewPart
{
	public StructuredViewer getStructuredViewer() 
	{
		return this.getCommonViewer();
	}

	/**
	 * <p>
	 * Constructs and returns an instance of {@see CommonViewer}. The ID of the Eclipse view part
	 * will be used to create the viewer. The ID is important as some extensions identify themselves
	 * with a particular viewer ID.
	 * <p>
	 * 
	 * @param aParent
	 *            A composite parent to contain the Common Viewer
	 * @return An initialized instance of CommonViewer
	 */
	protected CommonViewer createCommonViewer(Composite aParent) 
	{
		return new ServerExplorerViewer (getViewSite().getId(), aParent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
	}
	
	public Object getAdapter(Class adapter) { 
		if(adapter == IPropertySheetPage.class) 
		{
			return null;
		}
		return super.getAdapter(adapter);
	}

}
