/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.rdb.connection.internal.ui.filter.FilterWizard;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ImagePath;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

/**
 * @author ldunnell
 */
public class EditFilterAction extends AbstractAction {

	private static ISelection selection;

	/**
	 * Will set the current selection
	 * 
	 * @param sel
	 */
	protected void setSelection(ISelection sel) {
		selection = sel;
	}

	/**
	 * Will return the current selection
	 * 
	 * @return
	 */
	protected ISelection getSelection() {
		return selection;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		FilterWizard wizard = new FilterWizard(selection);

		wizard.init(PlatformUI.getWorkbench(), null);
		wizard.setNeedsProgressMonitor(false);

		WizardDialog dialog = new WizardDialog(Display.getCurrent()
				.getActiveShell(), wizard);
		dialog.create();
		dialog.getShell().setSize(500, 600);
		dialog.getShell().setText("Filter");
		dialog.getShell().setImage(ResourceLoader.INSTANCE.queryImageFromRegistry(ImagePath.FILTER_WIZARD_DIALOG));
		dialog.open();
	}


}