/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;
import java.sql.Connection;
import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.server.internal.ui.query.execute.QueryOutputHelper;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;


/**
 * @author hkolwalk
 */
public class SampleContentsAction implements IViewActionDelegate, IActionDelegate2
{
	private IStructuredSelection selection;
	
	public void init(IViewPart viewPart) {
		this.quote = DQ;
	}
	
	public void run(IAction action) {
		Connection connection = null;
		
		if (!this.selection.isEmpty()) {
			Iterator iter = this.selection.iterator();
			String selectString = ""; //$NON-NLS-1$
			/*int i=0;
			while(iter.hasNext()) {
				Object obj1 = (Object)iter.next();
				if (obj1 instanceof ITableViewer) {
					Object obj2 = ((ITableViewer)obj1).getElement();
					if (obj2 instanceof Table) {
						if (connection == null)
							connection = ((ICatalogObject)obj2).getConnection();
						selectString += ((Table)obj2).getSchema().getName() + "." + ((Table)obj2).getName();
						if (i != (this.selection.size()-1)) {
							selectString += ",";
						}
					}
				}
				i++;
			}*/
			Object selectedObj = iter.next();

			if (selectedObj instanceof Table) {
				if (connection == null)
                {
                    connection = ((ICatalogObject) selectedObj).getConnection();
                }
				final Schema schema = ((Table) selectedObj).getSchema();
				final Database database = schema.getDatabase();
				final DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
				this.quote = databaseDefinition.getIdentifierQuoteString();
				
                selectString += "SELECT * FROM " + this.getFullyQualifiedName((Table) selectedObj); //$NON-NLS-1$
			}
			else if (selectedObj instanceof Column) 
			{
			    if (connection == null) 
			    {
					connection = ((ICatalogObject)selectedObj).getConnection();
				}
			    String columnName = ((Column)selectedObj).getName();
				selectString += "SELECT DISTINCT " + this.wrapName(columnName) + " , COUNT(*) AS OCCURRENCE"; //$NON-NLS-1$ //$NON-NLS-2$
				selectString += " FROM " + this.getFullyQualifiedName(((Column)selectedObj).getTable()); //$NON-NLS-1$
				selectString += " GROUP BY " + this.wrapName(columnName); //$NON-NLS-1$
				selectString += " ORDER BY " + this.wrapName(columnName); //$NON-NLS-1$
			}
			
			QueryOutputHelper queryHelper = new QueryOutputHelper(selectString, connection);
			queryHelper.setObjectName(ResourceLoader.INSTANCE.queryString("_UI_SAMPLE_CONTENTS_OUTPUTVIEW_TITLE")); //$NON-NLS-1$
			queryHelper.runQuery();
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			this.selection = (IStructuredSelection)selection;
		}
	}

    /**
     * @see org.eclipse.ui.IActionDelegate2#init(org.eclipse.jface.action.IAction)
     */
    public void init(IAction action)
    {
		this.quote = DQ;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate2#dispose()
     */
    public void dispose()
    {
    }

    /**
     * @see org.eclipse.ui.IActionDelegate2#runWithEvent(org.eclipse.jface.action.IAction, org.eclipse.swt.widgets.Event)
     */
    public void runWithEvent(IAction action, Event event)
    {
        run(action);
    }
    
    private String wrapName(String name) {
    	if(this.quote.equals(SQ) || this.quote.equals(SQ2))
    	{
       		return this.quote + name + this.quote; 
    	}
    	else
        	return DQ + name + DQ; //$NON-NLS-1$ //$NON-NLS-2$
    }
    
    private String getFullyQualifiedName(Table table) {
    	return this.wrapName(table.getSchema().getName()) + "." + this.wrapName(table.getName()); //$NON-NLS-1$
    }
    private final String SQ = "'"; //$NON-NLS-1$ //$NON-NLS-2$
    private final String SQ2 = "`"; //$NON-NLS-1$ //$NON-NLS-2$
    private final String DQ = "\""; //$NON-NLS-1$ //$NON-NLS-2$
    private String quote = ""; //$NON-NLS-1$ //$NON-NLS-2$
}
