/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Apr 1, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.swt.widgets.Control;

/**
 * @author Admin
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DelegateShowProjectContentProvider implements ITreeContentProvider, IResourceChangeListener {

	/**
	 * 
	 */
	protected static final int ORIGINAL= 0;
	protected static final int PARENT= 1 << 0;
	protected static final int GRANT_PARENT= 1 << 1;
	protected static final int PROJECT= 1 << 2;
	protected static final Object[] NO_CHILDREN= new Object[0];
	TreeViewer fViewer;
	private Object fInput;
	
	private int fPendingChanges;
	
	public DelegateShowProjectContentProvider() {
		super();
		// TODO Auto-generated constructor stub
	}

	
	protected Object getViewerInput() {
		return fInput;
	}
	
	/* (non-Javadoc)
	 * Method declared on IElementChangedListener.
	 */
	public void resourceChanged(final IResourceChangeEvent event) {
		try {
			if (inputDeleted())
				return;
			processDelta(event.getDelta());
		} catch(JavaModelException e) {
			JavaPlugin.log(e);
		}
	}

	private boolean inputDeleted() {
		if (fInput == null)
			return false;
		if ((fInput instanceof IResource) && ((IResource) fInput).exists())
			return false;
		if (fInput instanceof WorkingSetModel)
			return false;
		postRefresh(fInput, ORIGINAL, fInput);
		return true;
	}

	/* (non-Javadoc)
	 * Method declared on IContentProvider.
	 */
	public void dispose() {
		ResourcesPlugin.getWorkspace().removeResourceChangeListener(this);
	}
	

	public Object[] getChildren(Object parentElement) {
		Object[] children= NO_CHILDREN;
		if (parentElement instanceof IWorkspaceRoot) {
			children =  ((IWorkspaceRoot) parentElement).getProjects();
		}
		return children;
	}

	

	public Object getParent(Object child) {
		return internalGetParent(child);	
	}

	protected Object internalGetParent(Object element) {
		if (element instanceof IResource) 
			return ((IResource)element).getParent();
		return null;
	}
	


	/* (non-Javadoc)
	 * Method declared on IContentProvider.
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		fViewer = (TreeViewer) viewer;
	
		if (oldInput == null && newInput != null) {
			ResourcesPlugin.getWorkspace().addResourceChangeListener(this);
		} else if (oldInput != null && newInput == null) {
			ResourcesPlugin.getWorkspace().removeResourceChangeListener(this);
		}
		fInput= newInput;
		
	}

	// ------ delta processing ------

	/**
	 * Processes a delta recursively. When more than two children are affected the
	 * tree is fully refreshed starting at this node. The delta is processed in the
	 * current thread but the viewer updates are posted to the UI thread.
	 */
	/**
	 * Processes a delta recursively. When more than two children are affected the
	 * tree is fully refreshed starting at this node. The delta is processed in the
	 * current thread but the viewer updates are posted to the UI thread.
	 */
	private void processDelta(IResourceDelta delta) throws JavaModelException {
		if (delta == null) return;
		int kind= delta.getKind();
		int flags= delta.getFlags();
		IResource resource= delta.getResource();
		int resourceType= resource.getType();
		
		
		if (resourceType != IResource.ROOT && resourceType != IResource.PROJECT) {
			IProject proj= resource.getProject();
			if (proj == null || !proj.getProject().isOpen()) // TODO: Not needed if parent already did the 'open' check!
				return;	
		}
		
		if (resourceType == IResource.PROJECT) {
			// handle open and closing of a project
			if ((flags & IResourceDelta.OPEN) != 0) {			
				postRefresh(resource, ORIGINAL, resource);
				return;
			}
		}
	
		if (kind == IResourceDelta.REMOVED) {
			postRemove(resource);
			return;
		}
	
		if (kind == IResourceDelta.ADDED) { 
			Object parent= internalGetParent(resource);
			postAdd(parent, resource);
			
		}
	
		IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
		if (processResourceDeltas(resourceDeltas, resource))
			return; 
	}
	
	
	
	/**
	 * Process resource deltas.
	 *
	 * @return true if the parent got refreshed
	 */
	private boolean processResourceDeltas(IResourceDelta[] deltas, Object parent) {
		if (deltas == null)
			return false;
		
		if (deltas.length > 1) {
			// more than one child changed, refresh from here downwards
			postRefresh(parent, ORIGINAL, parent);
			return true;
		}

		for (int i= 0; i < deltas.length; i++) {
			if (processResourceDelta(deltas[i], parent))
				return true;
		}

		return false;
	}
	
	
	/**
	 * Process a resource delta.
	 * 
	 * @return true if the parent got refreshed
	 */
	private boolean processResourceDelta(IResourceDelta delta, Object parent) {
		int status= delta.getKind();
		int flags= delta.getFlags();
		
		IResource resource= delta.getResource();
		// filter out changes affecting the output folder
		if (resource == null)
			return false;	
			
		// this could be optimized by handling all the added children in the parent
		if ((status & IResourceDelta.REMOVED) != 0) {
				postRemove(resource);
		}
		if ((status & IResourceDelta.ADDED) != 0) {
				postAdd(parent, resource);
		}
		// open/close state change of a project
		if ((flags & IResourceDelta.OPEN) != 0) {
			postProjectStateChanged(internalGetParent(parent));
			return true;		
		}
		processResourceDeltas(delta.getAffectedChildren(), resource);
		return false;
	}

	private void postRefresh(Object root, int relation, Object affectedElement) {
		// JFace doesn't refresh when object isn't part of the viewer
		// Therefore move the refresh start down to the viewer's input
		if (isParent(root, fInput)) 
			root= fInput;
		List toRefresh= new ArrayList(1);
		toRefresh.add(root);
		augmentElementToRefresh(toRefresh, relation, affectedElement);
		postRefresh(toRefresh, true);
	}
	
	protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
	}

	boolean isParent(Object root, Object child) {
		Object parent= getParent(child);
		if (parent == null)
			return false;
		if (parent.equals(root))
			return true;
		return isParent(root, parent);
	}

	/* package */ void postRefresh(final List toRefresh, final boolean updateLabels) {
		postRunnable(new Runnable() {
			public void run() {
				Control ctrl= fViewer.getControl();
				if (ctrl != null && !ctrl.isDisposed()) {
					try {
						fViewer.getControl().setRedraw(false);
						for (Iterator iter= toRefresh.iterator(); iter.hasNext();) {
							Object next = iter.next();
						//	if(next instanceof IWorkingSet)
						//		fViewer.refresh(getParent(next), updateLabels);
						//	else
								fViewer.refresh(next, updateLabels);
						}
					} finally {
						fViewer.getControl().setRedraw(true);
					}
				}
			}
		});
	}

	private void postAdd(final Object parent, final Object element) {
		postRunnable(new Runnable() {
			public void run() {
				Control ctrl= fViewer.getControl();
				if (ctrl != null && !ctrl.isDisposed()){
					// TODO workaround for 39754 New projects being added to the TreeViewer twice
					if (fViewer.testFindItem(element) == null) 
						fViewer.add(parent, element);
				}
			}
		});
	}

	private void postRemove(final Object element) {
		postRunnable(new Runnable() {
			public void run() {
				Control ctrl= fViewer.getControl();
				if (ctrl != null && !ctrl.isDisposed()) {
					fViewer.remove(element);
				}
			}
		});
	}

	private void postProjectStateChanged(final Object root) {
		postRunnable(new Runnable() {
			public void run() {
				Control ctrl= fViewer.getControl();
				if (ctrl != null && !ctrl.isDisposed()) {
					try {
						fViewer.getControl().setRedraw(false);
						fViewer.refresh(root, true);
						// trigger a syntetic selection change so that action refresh their
						// enable state.
						fViewer.setSelection(fViewer.getSelection());
					} finally {
						fViewer.getControl().setRedraw(true);
					}
				}
			}
		});
	}

	/* package */ void postRunnable(final Runnable r) {
		Control ctrl= fViewer.getControl();
		final Runnable trackedRunnable= new Runnable() {
			public void run() {
				try {
					r.run();
				} finally {
					removePendingChange();
				}
			}
		};
		if (ctrl != null && !ctrl.isDisposed()) {
			addPendingChange();
			try {
				ctrl.getDisplay().asyncExec(trackedRunnable); 
			} catch (RuntimeException e) {
				removePendingChange();
				throw e;
			} catch (Error e) {
				removePendingChange();
				throw e; 
			}
		}
	}

	// ------ Pending change management due to the use of asyncExec in postRunnable.
	
	public synchronized boolean hasPendingChanges() {
		return fPendingChanges > 0;  
	}
	
	private synchronized void addPendingChange() {
		fPendingChanges++;
		// System.out.print(fPendingChanges);
	}

	synchronized void removePendingChange() {
		fPendingChanges--;
		if (fPendingChanges < 0)
			fPendingChanges= 0;
		// System.out.print(fPendingChanges);
	}
	
	/**
	 * {@inheritDoc}
	 */
	public boolean hasChildren(Object element) {
		if (element instanceof IWorkspaceRoot)
			return true;
		return false;
	}


	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

}
