/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.containment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractContainmentProvider implements ContainmentProvider {
	public Collection getContainedElements(EObject obj) {
	    List children = new ArrayList(obj.eContents());
	    return children;
	}

	public boolean isDisplayableElement(EObject obj) {
		return true;
	}

	public EObject getContainer(EObject obj) {
		return obj.eContainer();
	}

	public EStructuralFeature getContainmentFeature(EObject obj) {
		return obj.eContainingFeature();
	}
}
