/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.nsedit.EditNamespacesDialog;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceInfoManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.w3c.dom.Element;

public class EditNamespacesAction
extends Action {
    protected Definition definition;

    public EditNamespacesAction(Definition definition) {
        this.setText(WSDLEditorPlugin.getWSDLString("_UI_EDIT_NAMESPACES"));
        this.definition = definition;
    }

    public void run() {
        DOMNamespaceInfoManager namespaceInfoManager = new DOMNamespaceInfoManager();
        Element element = WSDLEditorUtil.getInstance().getElementForObject(this.definition);
        if (element != null) {
            List namespaceInfoList = namespaceInfoManager.getNamespaceInfoList(element);
            Iterator i = namespaceInfoList.iterator();
            while (i.hasNext()) {
                NamespaceInfo info = (NamespaceInfo)i.next();
                NamespaceInfo oldCopy = new NamespaceInfo(info);
                info.setProperty("oldCopy", (Object)oldCopy);
            }
            Path path = new Path(this.definition.getDocumentBaseURI());
            EditNamespacesDialog dialog = new EditNamespacesDialog(WSDLEditorPlugin.getShell(), (IPath)path, WSDLEditorPlugin.getWSDLString("_UI_EDIT_NAMESPACES_DIALOG_TITLE"), this.definition.getTargetNamespace(), namespaceInfoList);
            int rc = dialog.createAndOpen();
            if (rc == 0) {
                element.setAttribute("targetNamespace", dialog.getTargetNamespace());
                List newInfoList = dialog.getNamespaceInfoList();
                namespaceInfoManager.removeNamespaceInfo(element);
                namespaceInfoManager.addNamespaceInfo(element, newInfoList, false);
            }
        }
    }

    protected Map createPrefixMapping(List oldList, List newList) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        Hashtable<String, NamespaceInfo> oldURIToPrefixTable = new Hashtable<String, NamespaceInfo>();
        Iterator i = oldList.iterator();
        while (i.hasNext()) {
            NamespaceInfo oldInfo = (NamespaceInfo)i.next();
            oldURIToPrefixTable.put(oldInfo.uri, oldInfo);
        }
        i = newList.iterator();
        while (i.hasNext()) {
            String oldPrefix;
            NamespaceInfo newInfo = (NamespaceInfo)i.next();
            NamespaceInfo oldInfo = (NamespaceInfo)oldURIToPrefixTable.get(newInfo.uri != null ? newInfo.uri : "");
            if (oldInfo == null) {
                oldInfo = (NamespaceInfo)newInfo.getProperty("oldCopy");
            }
            if (oldInfo == null) continue;
            String newPrefix = newInfo.prefix != null ? newInfo.prefix : "";
            String string = oldPrefix = oldInfo.prefix != null ? oldInfo.prefix : "";
            if (oldPrefix.equals(newPrefix)) continue;
            map.put(oldPrefix, newPrefix);
        }
        return map;
    }
}

