/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.properties.section;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.EditNamespacesAction;
import org.eclipse.wst.wsdl.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonEditNamespacesTargetFieldDialog;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonNamespaceInfoTable;
import org.w3c.dom.Element;

public class NamespaceSection
extends AbstractSection {
    protected String targetNamespace;
    protected List namespaceInfoList;
    protected CommonEditNamespacesTargetFieldDialog editWSDLNamespacesControl;
    protected Button button;
    Text nameText;
    Text prefixText;
    Text targetNamespaceText;
    protected CommonNamespaceInfoTable tableViewer;
    private boolean handlingEvent;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        String nameString = String.valueOf(WSDLEditorPlugin.getWSDLString("_UI_LABEL_NAME")) + ":";
        String prefixString = String.valueOf(WSDLEditorPlugin.getWSDLString("_UI_LABEL_PREFIX")) + ":";
        String namespaceString = WSDLEditorPlugin.getWSDLString("_UI_LABEL_TARGET_NAMESPACE");
        GC gc = new GC((Drawable)parent);
        int xoffset = Math.max(115, gc.textExtent((String)nameString).x + 20);
        xoffset = Math.max(xoffset, gc.textExtent((String)prefixString).x + 20);
        xoffset = Math.max(xoffset, gc.textExtent((String)namespaceString).x + 20);
        gc.dispose();
        CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, nameString);
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        CLabel prefixLabel = this.getWidgetFactory().createCLabel(this.composite, prefixString);
        this.prefixText = this.getWidgetFactory().createText(this.composite, "");
        CLabel targetNamespaceLabel = this.getWidgetFactory().createCLabel(this.composite, namespaceString);
        this.targetNamespaceText = this.getWidgetFactory().createText(this.composite, "");
        this.button = this.getWidgetFactory().createButton(this.composite, String.valueOf(WSDLEditorPlugin.getWSDLString("_UI_SECTION_ADVANCED_ATTRIBUTES")) + "...", 8);
        FormData dataNameLabel = new FormData();
        dataNameLabel.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        nameLabel.setLayoutData((Object)dataNameLabel);
        FormData dataPrefixLabel = new FormData();
        dataPrefixLabel.left = new FormAttachment(0, 0);
        dataPrefixLabel.top = new FormAttachment((Control)this.prefixText, 0, 0x1000000);
        prefixLabel.setLayoutData((Object)dataPrefixLabel);
        FormData datatnsLabel = new FormData();
        datatnsLabel.left = new FormAttachment(0, 0);
        datatnsLabel.right = new FormAttachment((Control)this.targetNamespaceText, 0);
        datatnsLabel.top = new FormAttachment((Control)this.targetNamespaceText, 0, 0x1000000);
        targetNamespaceLabel.setLayoutData((Object)datatnsLabel);
        FormData dataNameText = new FormData();
        dataNameText.left = new FormAttachment(0, xoffset);
        dataNameText.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        dataNameText.top = new FormAttachment(0, 0);
        this.nameText.setLayoutData((Object)dataNameText);
        this.nameText.addListener(24, (Listener)this);
        FormData dataPrefixText = new FormData();
        dataPrefixText.left = new FormAttachment(0, xoffset);
        dataPrefixText.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        dataPrefixText.top = new FormAttachment((Control)this.nameText, 4);
        this.prefixText.setLayoutData((Object)dataPrefixText);
        this.prefixText.addListener(24, (Listener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, xoffset);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.prefixText, 4);
        this.targetNamespaceText.setLayoutData((Object)data);
        this.targetNamespaceText.addListener(24, (Listener)this);
        FormData dataButton = new FormData();
        dataButton.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        dataButton.top = new FormAttachment((Control)this.targetNamespaceText, 4);
        this.button.setLayoutData((Object)dataButton);
        this.button.addSelectionListener((SelectionListener)this);
    }

    public void doHandleEvent(Event event) {
        WSDLElement obj;
        this.handlingEvent = true;
        if (event.widget == this.nameText) {
            WSDLElement obj2 = this.getElement();
            if (obj2 instanceof Definition) {
                Definition definition = (Definition)obj2;
                String uri = "";
                if (definition.getQName() != null) {
                    uri = definition.getQName().getNamespaceURI();
                }
                definition.setQName(new QName(uri, this.nameText.getText()));
            }
        } else if (event.widget == this.prefixText) {
            WSDLElement obj3 = this.getElement();
            if (obj3 instanceof Definition) {
                Definition definition = (Definition)obj3;
                Element element = definition.getElement();
                String oldPrefix = definition.getPrefix(definition.getTargetNamespace());
                element.removeAttribute("xmlns:" + oldPrefix);
                element.setAttribute("xmlns:" + this.prefixText.getText(), definition.getTargetNamespace());
            }
        } else if (event.widget == this.targetNamespaceText && (obj = this.getElement()) instanceof Definition) {
            Definition definition = (Definition)obj;
            String newValue = this.targetNamespaceText.getText();
            String prefix = definition.getPrefix(definition.getTargetNamespace());
            definition.setTargetNamespace(newValue);
            definition.getElement().setAttribute("xmlns:" + prefix, newValue);
        }
        this.handlingEvent = false;
    }

    public void refresh() {
        Definition definition;
        String targetNS;
        super.refresh();
        if (this.targetNamespaceText.isFocusControl() || this.handlingEvent) {
            return;
        }
        this.setListenerEnabled(false);
        WSDLElement obj = this.getElement();
        if (obj instanceof Definition && (targetNS = (definition = (Definition)obj).getTargetNamespace()) != null) {
            this.targetNamespaceText.setText(targetNS);
            Element element = definition.getElement();
            String newPrefix = definition.getPrefix(targetNS);
            if (newPrefix == null) {
                newPrefix = "";
            }
            if (element != null) {
                int index = 0;
                while (index < element.getAttributes().getLength()) {
                    String xmlnsString;
                    AttrImpl attr = (AttrImpl)element.getAttributes().item(index);
                    String nodeName = attr.getNodeName();
                    String nsValue = attr.getNodeValue();
                    if (nsValue.equals(targetNS) && nodeName.indexOf(":") != -1 && (xmlnsString = nodeName.substring(0, nodeName.indexOf(":"))).equals("xmlns")) {
                        newPrefix = attr.getLocalName();
                        break;
                    }
                    ++index;
                }
            }
            this.prefixText.setText(newPrefix);
        }
        if (this.getElement() != null && this.getElement().getElement() != null) {
            String name = this.getElement().getElement().getAttribute("name");
            if (name == null) {
                name = "";
            }
            this.nameText.setText(name);
        }
        this.setListenerEnabled(true);
    }

    public void widgetSelected(SelectionEvent e) {
        WSDLElement obj;
        if (e.widget == this.button && (obj = this.getElement()) instanceof Definition) {
            Definition definition = (Definition)obj;
            EditNamespacesAction action = new EditNamespacesAction(definition);
            action.run();
            this.refresh();
        }
    }
}

