/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.datamodel.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.DataModelManager;
import org.eclipse.wst.common.frameworks.internal.OperationManager;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.AddablePageGroup;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.SimplePageGroup;
import org.eclipse.wst.common.frameworks.internal.eclipse.ui.EclipseEnvironment;
import org.eclipse.wst.common.frameworks.internal.ui.ErrorDialog;
import org.eclipse.wst.common.frameworks.internal.ui.PageGroupManager;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;

public abstract class DataModelWizard
extends Wizard
implements IDMPageHandler {
    private DataModelManager dataModelManager;
    private OperationManager operationManager;
    private PageGroupManager pageGroupManager;
    private IDataModel dataModel;
    private AddablePageGroup rootPageGroup;
    private IDataModelOperation rootOperation;

    public DataModelWizard(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public DataModelWizard() {
    }

    protected abstract IDataModelProvider getDefaultProvider();

    public final String getWizardID() {
        return this.getDataModel().getID();
    }

    protected IDataModelOperation getRootOperation() {
        return this.getDataModel().getDefaultOperation();
    }

    public final void addPages() {
        this.init();
        this.doAddPages();
    }

    protected void doAddPages() {
    }

    public IWizardPage getStartingPage() {
        this.pageGroupManager.reset();
        return this.getNextPage(null);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage currentPage = this.pageGroupManager.getCurrentPage();
        this.pageGroupManager.moveForwardOnePage();
        IWizardPage nextPage = this.pageGroupManager.getCurrentPage();
        if (currentPage != nextPage && nextPage != null) {
            nextPage.setWizard((IWizard)this);
            nextPage.setPreviousPage(currentPage);
        }
        return currentPage == nextPage ? null : nextPage;
    }

    public String getNextPage(String currentPageName, String expectedNextPageName) {
        return expectedNextPageName;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return page != null ? page.getPreviousPage() : null;
    }

    public String getPreviousPage(String currentPageName, String expectedPreviousPageName) {
        return expectedPreviousPageName;
    }

    public boolean canFinish() {
        return super.canFinish() && this.getDataModel().isValid();
    }

    public PageGroupManager getPageGroupManager() {
        return this.pageGroupManager;
    }

    protected void resetAfterFinishError() {
    }

    public final boolean performFinish() {
        boolean wasSuccessful = false;
        try {
            if (this.prePerformFinish()) {
                this.storeDefaultSettings();
                wasSuccessful = this.runOperations().getSeverity() != 4;
                this.postPerformFinish();
            }
        }
        catch (Throwable throwable) {
            wasSuccessful = false;
        }
        return wasSuccessful;
    }

    private IStatus runOperations() {
        final IStatus[] status = new IStatus[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    status[0] = DataModelWizard.this.rootOperation.execute(monitor, null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            this.getContainer().run(this.runForked(), this.isCancelable(), runnable);
        }
        catch (Throwable exc) {
            Logger.getLogger().logError(exc);
            ErrorDialog.openError(this.getShell(), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_0, new Object[]{this.getWindowTitle()}), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_1, new Object[]{this.getWindowTitle()}), exc, 0, false);
            status[0] = new Status(4, "id", 0, exc.getMessage(), exc);
        }
        return status[0];
    }

    public boolean performCancel() {
        this.pageGroupManager.undoAllCurrentOperations();
        return true;
    }

    protected boolean prePerformFinish() {
        return true;
    }

    protected void postPerformFinish() throws InvocationTargetException {
    }

    protected void storeDefaultSettings() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            this.storeDefaultSettings(pages[i], i);
            ++i;
        }
    }

    protected void storeDefaultSettings(IWizardPage page, int pageIndex) {
        if (page instanceof DataModelWizardPage) {
            ((DataModelWizardPage)page).storeDefaultSettings();
        }
    }

    protected boolean isCancelable() {
        return false;
    }

    protected boolean runForked() {
        return false;
    }

    public void setDataModel(IDataModel model) {
        this.dataModel = model;
    }

    public IDataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = DataModelFactory.createDataModel((IDataModelProvider)this.getDefaultProvider());
        }
        return this.dataModel;
    }

    public void dispose() {
        super.dispose();
        if (this.dataModel != null) {
            this.dataModel.dispose();
        }
    }

    protected AddablePageGroup createRootPageGroup() {
        String id = this.getWizardID();
        SimplePageGroup pageGroup = new SimplePageGroup(id, id);
        pageGroup.setPageHandler(this);
        return pageGroup;
    }

    protected IEnvironment createEnvironment() {
        return new EclipseEnvironment();
    }

    public void addPage(IWizardPage page) {
        this.rootPageGroup.addPage(page);
    }

    private void init() {
        this.dataModelManager = new DataModelManager(this.getDataModel());
        this.rootOperation = this.getRootOperation();
        this.operationManager = new WizardOperationManager(this.dataModelManager, this.rootOperation);
        this.rootPageGroup = this.createRootPageGroup();
        this.pageGroupManager = new PageGroupManager(this.operationManager, this.dataModelManager, this.rootPageGroup);
    }

    public boolean needsPreviousAndNextButtons() {
        return super.needsPreviousAndNextButtons() || this.getPageGroupManager().hasMultiplePages();
    }

    private class WizardOperationManager
    extends OperationManager {
        public WizardOperationManager(DataModelManager dataModelManager, IDataModelOperation rootOperation) {
            super(dataModelManager, rootOperation, DataModelWizard.this.createEnvironment());
        }

        public IStatus runOperations() {
            IStatus[] status = new IStatus[1];
            IRunnableWithProgress runnable = new IRunnableWithProgress(this, status){
                final /* synthetic */ WizardOperationManager this$1;
                private final /* synthetic */ IStatus[] val$status;
                {
                    this.this$1 = wizardOperationManager;
                    this.val$status = iStatusArray;
                }

                public void run(IProgressMonitor monitor) {
                    this.this$1.setProgressMonitor(monitor);
                    this.val$status[0] = WizardOperationManager.access$0(this.this$1);
                }
            };
            try {
                DataModelWizard.this.getContainer().run(DataModelWizard.this.runForked(), DataModelWizard.this.isCancelable(), runnable);
            }
            catch (Throwable exc) {
                Logger.getLogger().logError(exc);
                ErrorDialog.openError(DataModelWizard.this.getShell(), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_0, new Object[]{DataModelWizard.this.getWindowTitle()}), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_1, new Object[]{DataModelWizard.this.getWindowTitle()}), exc, 0, false);
                status[0] = new Status(4, "id", 0, exc.getMessage(), exc);
            }
            return status[0];
        }

        public void undoLastRun() {
            IRunnableWithProgress runnable = new IRunnableWithProgress(this){
                final /* synthetic */ WizardOperationManager this$1;
                {
                    this.this$1 = wizardOperationManager;
                }

                public void run(IProgressMonitor monitor) {
                    this.this$1.setProgressMonitor(monitor);
                    WizardOperationManager.access$1(this.this$1);
                }
            };
            try {
                DataModelWizard.this.getContainer().run(DataModelWizard.this.runForked(), DataModelWizard.this.isCancelable(), runnable);
            }
            catch (Throwable exc) {
                Logger.getLogger().logError(exc);
                ErrorDialog.openError(DataModelWizard.this.getShell(), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_0, new Object[]{DataModelWizard.this.getWindowTitle()}), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_1, new Object[]{DataModelWizard.this.getWindowTitle()}), exc, 0, false);
            }
        }

        static /* synthetic */ IStatus access$0(WizardOperationManager wizardOperationManager) {
            return super.runOperations();
        }

        static /* synthetic */ void access$1(WizardOperationManager wizardOperationManager) {
            super.undoLastRun();
        }
    }
}

