/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deployables;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.server.core.IApplicationClientModule;
import org.eclipse.jst.server.core.IConnectorModule;
import org.eclipse.jst.server.core.IEJBModule;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.web.internal.deployables.ComponentDeployable;

public class J2EEFlexProjDeployable
extends ComponentDeployable
implements IJ2EEModule,
IEnterpriseApplication,
IApplicationClientModule,
IConnectorModule,
IEJBModule,
IWebModule {
    private static final IPath WEB_CLASSES_PATH = new Path("WEB-INF").append("classes");

    public J2EEFlexProjDeployable(IProject project, IVirtualComponent aComponent) {
        super(project);
    }

    public J2EEFlexProjDeployable(IProject project) {
        super(project);
    }

    public IContainer[] getResourceFolders() {
        IVirtualFolder vFolder;
        ArrayList<IContainer> result = new ArrayList<IContainer>();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getProject());
        if (vc != null && (vFolder = vc.getRootFolder()) != null) {
            IContainer[] underlyingFolders = vFolder.getUnderlyingFolders();
            result.addAll(Arrays.asList(underlyingFolders));
            IPackageFragmentRoot[] srcRoots = J2EEProjectUtilities.getSourceContainers(this.getProject());
            try {
                int i = 0;
                while (i < srcRoots.length) {
                    IResource corrResource = srcRoots[i].getCorrespondingResource();
                    if (corrResource != null && corrResource instanceof IContainer) {
                        IContainer srcContainer = (IContainer)corrResource;
                        result.remove(srcContainer);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        return result.toArray(new IContainer[result.size()]);
    }

    public IContainer[] getJavaOutputFolders() {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getProject());
        if (vc == null) {
            return new IContainer[0];
        }
        return J2EEProjectUtilities.getOutputContainers(this.getProject());
    }

    public IModuleResource[] members() throws CoreException {
        IVirtualComponent vc;
        this.members.clear();
        Path javaPath = Path.EMPTY;
        if (J2EEProjectUtilities.isDynamicWebProject(this.component.getProject())) {
            javaPath = WEB_CLASSES_PATH;
        }
        if ((vc = ComponentCore.createComponent((IProject)this.getProject())) != null) {
            IVirtualFolder vFolder = vc.getRootFolder();
            IModuleResource[] mr = this.getMembers((IVirtualContainer)vFolder, (IPath)Path.EMPTY);
            int size = mr.length;
            int j = 0;
            while (j < size) {
                if (!this.members.contains(mr[j])) {
                    this.members.add(mr[j]);
                }
                ++j;
            }
            List utilMembers = this.getUtilMembers(vc);
            if (!utilMembers.isEmpty()) {
                this.members.addAll(utilMembers);
            }
        }
        IContainer[] javaCont = this.getJavaOutputFolders();
        int size = javaCont.length;
        int i = 0;
        while (i < size) {
            IModuleResource[] mr = this.getMembers(javaCont[i], (IPath)javaPath, (IPath)javaPath, javaCont);
            int size2 = mr.length;
            int j = 0;
            while (j < size2) {
                if (!this.members.contains(mr[j])) {
                    this.members.add(mr[j]);
                }
                ++j;
            }
            ++i;
        }
        IModuleResource[] mr = new IModuleResource[this.members.size()];
        this.members.toArray(mr);
        return mr;
    }

    protected IModuleResource[] handleJavaPath(IPath path, IPath javaPath, IPath curPath, IContainer[] javaCont, IModuleResource[] mr, IContainer cc) throws CoreException {
        if (curPath.equals((Object)javaPath)) {
            int size = javaCont.length;
            int i = 0;
            while (i < size) {
                IModuleResource[] mr2 = this.getMembers(javaCont[i], path.append(cc.getName()), null, null);
                IModuleResource[] mr3 = new IModuleResource[mr.length + mr2.length];
                System.arraycopy(mr, 0, mr3, 0, mr.length);
                System.arraycopy(mr2, 0, mr3, mr.length, mr2.length);
                mr = mr3;
                ++i;
            }
        } else {
            boolean containsFolder = false;
            String name = javaPath.segment(curPath.segmentCount());
            int size = mr.length;
            int i = 0;
            while (i < size && !containsFolder) {
                IModuleFolder mf2;
                if (mr[i] instanceof IModuleFolder && name.equals((mf2 = (IModuleFolder)mr[i]).getName())) {
                    containsFolder = true;
                }
                ++i;
            }
            if (!containsFolder && javaCont.length > 0) {
                ModuleFolder mf2 = new ModuleFolder(javaCont[0], name, curPath);
                IModuleResource[] mrf = new IModuleResource[]{};
                size = javaCont.length;
                int i2 = 0;
                while (i2 < size) {
                    IModuleResource[] mrf2 = this.getMembers(javaCont[i2], javaPath, null, null);
                    IModuleResource[] mrf3 = new IModuleResource[mrf.length + mrf2.length];
                    System.arraycopy(mrf, 0, mrf3, 0, mrf.length);
                    System.arraycopy(mrf2, 0, mrf3, mrf.length, mrf2.length);
                    mrf = mrf3;
                    ++i2;
                }
                mf2.setMembers(mrf);
                IModuleResource[] mr3 = new IModuleResource[mr.length + 1];
                System.arraycopy(mr, 0, mr3, 0, mr.length);
                mr3[mr.length] = mf2;
                mr = mr3;
            }
        }
        return mr;
    }

    public IPath[] getClasspath() {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IJavaProject proj = JemProjectUtilities.getJavaProject((IProject)this.getProject());
        URL[] urls = JemProjectUtilities.getClasspathAsURLArray((IJavaProject)proj);
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            paths.add(Path.fromOSString((String)url.getPath()));
            ++i;
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJNDIName(String ejbName) {
        EJBJar jar;
        EjbModuleExtensionHelper modHelper;
        block8: {
            if (!J2EEProjectUtilities.isEJBProject(this.component.getProject())) {
                return null;
            }
            modHelper = null;
            jar = null;
            ArtifactEdit ejbEdit = null;
            try {
                try {
                    ejbEdit = ComponentUtilities.getArtifactEditForRead((IVirtualComponent)this.component);
                    if (ejbEdit != null) {
                        jar = (EJBJar)ejbEdit.getContentModelRoot();
                        modHelper = IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (ejbEdit == null) throw throwable;
                ejbEdit.dispose();
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (ejbEdit == null) break block8;
            }
            ejbEdit.dispose();
        }
        if (modHelper == null) {
            return null;
        }
        String string = modHelper.getJNDIName(jar, jar.getEnterpriseBeanNamed(ejbName));
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getURI(IModule module) {
        String aURI;
        block18: {
            block19: {
                IProject[] earProjects;
                if (this.component != null && module != null && J2EEProjectUtilities.isEARProject(this.component.getProject())) {
                    return this.getContainedURI(module);
                }
                IVirtualComponent ear = null;
                aURI = null;
                if (module != null && J2EEProjectUtilities.isEARProject(module.getProject())) {
                    ear = ComponentCore.createComponent((IProject)module.getProject());
                } else if (this.component != null && (earProjects = J2EEProjectUtilities.getReferencingEARProjects(this.component.getProject())).length > 0) {
                    ear = ComponentCore.createComponent((IProject)earProjects[0]);
                }
                if (ear == null || this.component == null) break block19;
                EARArtifactEdit earEdit = null;
                try {
                    try {
                        earEdit = EARArtifactEdit.getEARArtifactEditForRead(ear);
                        if (earEdit != null) {
                            aURI = earEdit.getModuleURI(this.component);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (earEdit == null) throw throwable;
                    earEdit.dispose();
                    throw throwable;
                }
                {
                    Object var6_8 = null;
                    if (earEdit != null) {
                        earEdit.dispose();
                    }
                    break block18;
                }
            }
            if (this.component != null && J2EEProjectUtilities.isEARProject(this.component.getProject())) {
                aURI = String.valueOf(this.component.getDeployedName()) + ".ear";
            } else if (this.component != null && J2EEProjectUtilities.isDynamicWebProject(this.component.getProject())) {
                aURI = String.valueOf(this.component.getDeployedName()) + ".war";
            } else if (this.component != null && (J2EEProjectUtilities.isEJBProject(this.component.getProject()) || J2EEProjectUtilities.isApplicationClientProject(this.component.getProject()))) {
                aURI = String.valueOf(this.component.getDeployedName()) + ".jar";
            } else if (this.component != null && J2EEProjectUtilities.isJCAProject(this.component.getProject())) {
                aURI = String.valueOf(this.component.getDeployedName()) + ".rar";
            }
        }
        if (aURI == null) return aURI;
        if (aURI.length() <= 1) return aURI;
        if (!aURI.startsWith("/")) return aURI;
        return aURI.substring(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getContainedURI(IModule module) {
        String aURI;
        block6: {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)module.getProject());
            aURI = null;
            if (comp == null || this.component == null || !J2EEProjectUtilities.isEARProject(this.component.getProject())) break block6;
            EARArtifactEdit earEdit = null;
            try {
                try {
                    earEdit = EARArtifactEdit.getEARArtifactEditForRead(this.component);
                    if (earEdit != null) {
                        aURI = earEdit.getModuleURI(comp);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (earEdit == null) throw throwable;
                earEdit.dispose();
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (earEdit == null) break block6;
            }
            earEdit.dispose();
        }
        if (aURI == null) return aURI;
        if (aURI.length() <= 1) return aURI;
        if (!aURI.startsWith("/")) return aURI;
        return aURI.substring(1);
    }

    public String getContextRoot() {
        Properties props = this.component.getMetaProperties();
        if (props.containsKey("context-root")) {
            return props.getProperty("context-root");
        }
        return this.component.getName();
    }

    protected boolean isFileInSourceContainer(IFile file) {
        boolean result = false;
        if (file == null) {
            return false;
        }
        IPackageFragmentRoot[] srcContainers = J2EEProjectUtilities.getSourceContainers(this.getProject());
        int i = 0;
        while (i < srcContainers.length) {
            IPath srcPath = srcContainers[i].getPath();
            result = srcPath.isPrefixOf(file.getFullPath());
            if (result) break;
            ++i;
        }
        return result;
    }
}

