/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.project.facet.EARFacetUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class EarFacetValidator
implements IFacetedProjectValidator {
    private static final String MARKER_ID = "org.eclipse.jst.j2ee.differentRuntimesDetected";

    public void validate(IFacetedProject fproj) throws CoreException {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)fproj.getProject());
        if (vc == null) {
            return;
        }
        if (fproj.hasProjectFacet(EARFacetUtils.EAR_FACET)) {
            fproj.getProject().deleteMarkers(MARKER_ID, false, 0);
            IVirtualReference[] refs = vc.getReferences();
            int i = 0;
            while (i < refs.length) {
                IVirtualReference ref = refs[i];
                IVirtualComponent refvc = ref.getReferencedComponent();
                IProject refpj = refvc.getProject();
                this.validate(fproj, ProjectFacetsManager.create((IProject)refpj));
                ++i;
            }
        } else {
            IVirtualComponent[] referencing = vc.getReferencingComponents();
            int i = 0;
            while (i < referencing.length) {
                IVirtualComponent refvc = referencing[i];
                IFacetedProject reffpj = ProjectFacetsManager.create((IProject)refvc.getProject());
                if (reffpj.hasProjectFacet(EARFacetUtils.EAR_FACET)) {
                    this.validate(reffpj);
                }
                ++i;
            }
        }
    }

    private void validate(IFacetedProject ear, IFacetedProject module) throws CoreException {
        IRuntime earRuntime = ear.getRuntime();
        IRuntime moduleRuntime = module.getRuntime();
        if (!(earRuntime == null && moduleRuntime != null || earRuntime != null && moduleRuntime == null || earRuntime == null || moduleRuntime == null || earRuntime.equals(moduleRuntime))) {
            String msg = NLS.bind((String)Resources.targettingDifferentRuntimes, (Object)module.getProject().getName());
            IMarker m = ear.createWarningMarker(MARKER_ID, msg);
            m.setAttribute("moduleProject", (Object)module.getProject().getName());
            m.setAttribute("runtime1", (Object)ear.getRuntime().getName());
            m.setAttribute("runtime2", (Object)module.getRuntime().getName());
        }
    }

    private static final class Resources
    extends NLS {
        public static String targettingDifferentRuntimes;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.project.facet.EarFacetValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jst.j2ee.project.facet.EarFacetValidator$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        Resources() {
        }
    }
}

