/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ui.project.facet;

import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class JavaVersionMismatchMarkerResolutions
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        return new IMarkerResolution[]{new Resolution1(marker), new Resolution2(marker)};
    }

    private static final class Resolution1
    implements IMarkerResolution {
        private final IMarker marker;

        public Resolution1(IMarker marker) {
            this.marker = marker;
        }

        public String getLabel() {
            IProjectFacetVersion fv = this.getProjectFacetVersion();
            return NLS.bind((String)Resources.changeFacetVersion, (Object)fv);
        }

        public void run(IMarker marker) {
            IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, this.getProjectFacetVersion(), null);
            IProject proj = this.marker.getResource().getProject();
            try {
                IFacetedProject fproj = ProjectFacetsManager.create((IProject)proj);
                fproj.modify(Collections.singleton(action), null);
            }
            catch (CoreException e) {
                ErrorDialog.openError(null, (String)Resources.errorDialogTitle, (String)Resources.errorDialogMessage, (IStatus)e.getStatus());
            }
        }

        private IProjectFacetVersion getProjectFacetVersion() {
            String level = this.marker.getAttribute("compilerLevel", null);
            return JavaFacetUtils.compilerLevelToFacet((String)level);
        }
    }

    private static final class Resolution2
    implements IMarkerResolution {
        private final IMarker marker;

        public Resolution2(IMarker marker) {
            this.marker = marker;
        }

        public String getLabel() {
            String level = this.getCompilerLevel();
            return NLS.bind((String)Resources.changeCompilerLevel, (Object)level);
        }

        public void run(IMarker marker) {
            IProject project = this.marker.getResource().getProject();
            String level = this.getCompilerLevel();
            try {
                JavaFacetUtils.setCompilerLevel((IProject)project, (String)level);
                JavaFacetUtils.scheduleFullBuild((IProject)project);
            }
            catch (CoreException e) {
                ErrorDialog.openError(null, (String)Resources.errorDialogTitle, (String)Resources.errorDialogMessage, (IStatus)e.getStatus());
            }
        }

        private String getCompilerLevel() {
            String fvstr = this.marker.getAttribute("facetVersion", null);
            IProjectFacetVersion fv = JavaFacetUtils.JAVA_FACET.getVersion(fvstr);
            return JavaFacetUtils.facetToCompilerLevel((IProjectFacetVersion)fv);
        }
    }

    private static final class Resources
    extends NLS {
        public static String changeFacetVersion;
        public static String changeCompilerLevel;
        public static String errorDialogTitle;
        public static String errorDialogMessage;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.ui.project.facet.JavaVersionMismatchMarkerResolutions");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jst.j2ee.ui.project.facet.JavaVersionMismatchMarkerResolutions$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        Resources() {
        }
    }
}

