/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.fe.internal.ui.wizards;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.DatabaseAuthenticationWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.DatabaseProductVersion;
import org.eclipse.wst.rdb.core.internal.ui.icons.ImageDescription;
import org.eclipse.wst.rdb.fe.internal.ui.util.ResourceLoader;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FEConfigurationData;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FEConfigureJDBCConnectionWizardPage;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FESelectFileWizardPage;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FESelectObjectsWizardPage;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FESelectOptionsWizardPage;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FESpecifyExistingConnectionsWizardPage;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FESummaryProperty;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FESummaryWizardPage;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.IGenerateDDL;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.DDLGenerator;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.core.util.DatabaseProviderHelper;
import org.eclipse.wst.rdb.internal.core.util.SaveDDLUtility;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.server.internal.ui.query.execute.QueryOutputHelper;

public class FEWizard
extends Wizard
implements IGenerateDDL {
    private FESelectOptionsWizardPage selectOptionsPage;
    private FESelectObjectsWizardPage selectObjectsPage;
    private FESelectFileWizardPage selectFilePage;
    private FESpecifyExistingConnectionsWizardPage existingConnectionsPage;
    private DatabaseAuthenticationWizardPage databaseAuthenticationPage;
    private FEConfigureJDBCConnectionWizardPage configureJDBCPage;
    private FESummaryWizardPage summaryPage;
    private static String SELECT_OPTIONS_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SelectOptionsPage";
    private static String SELECT_OBJECTS_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SelectObjectsPage";
    private static String SELECT_FILE_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SelectFilePage";
    private static String EXISTING_CONNECTIONS_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.ExistingConnectionsPage";
    private static String DATABASE_AUTHENTICATION_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.DatabaseAuthenticationPage";
    private static String CONFIGURE_JDBC_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.ConfigureJDBCPage";
    private static String SUMMARY_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SummaryPage";
    private List selection;
    private DDLGenerator feProvider;
    private DatabaseDefinition databaseDefinition;
    String lastProductValueSet = "";
    String lastVersionValueSet = "";
    private Connection connection = null;
    private ConnectionInfo connectionInfo = null;
    private StringWriter writer = new StringWriter();
    private String[] ddlScripts = new String[0];
    private boolean hasGenerated = false;

    public FEWizard(List selection) {
        this.selection = selection;
        this.setWindowTitle(ResourceLoader.INSTANCE.queryString("FE_WIZARD_TITLEBAR_TEXT"));
        this.setDefaultPageImageDescriptor(ImageDescription.getGenerateDDLWizard());
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        Database database = this.getDatabase((EObject)((SQLObject)this.selection.get(0)));
        this.databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database.getVendor(), database.getVersion());
        this.feProvider = this.databaseDefinition.getDDLGenerator();
        FEConfigurationData configurationData = new FEConfigurationData(this.feProvider.getOptions(this.selection.toArray(new SQLObject[this.selection.size()])));
        this.selectOptionsPage = new FESelectOptionsWizardPage(SELECT_OPTIONS_WIZARD_PAGE_NAME, configurationData);
        this.addPage((IWizardPage)this.selectOptionsPage);
        this.selectObjectsPage = new FESelectObjectsWizardPage(SELECT_OBJECTS_WIZARD_PAGE_NAME, configurationData);
        this.addPage((IWizardPage)this.selectObjectsPage);
        this.selectFilePage = new FESelectFileWizardPage(SELECT_FILE_WIZARD_PAGE_NAME, this.selection);
        this.addPage((IWizardPage)this.selectFilePage);
        this.existingConnectionsPage = new FESpecifyExistingConnectionsWizardPage(EXISTING_CONNECTIONS_WIZARD_PAGE_NAME);
        this.addPage((IWizardPage)this.existingConnectionsPage);
        this.databaseAuthenticationPage = new DatabaseAuthenticationWizardPage(DATABASE_AUTHENTICATION_WIZARD_PAGE_NAME);
        this.addPage((IWizardPage)this.databaseAuthenticationPage);
        this.configureJDBCPage = new FEConfigureJDBCConnectionWizardPage(CONFIGURE_JDBC_WIZARD_PAGE_NAME);
        this.addPage((IWizardPage)this.configureJDBCPage);
        this.summaryPage = new FESummaryWizardPage(SUMMARY_WIZARD_PAGE_NAME);
        this.addPage((IWizardPage)this.summaryPage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor monitor) {
                try {
                    try {
                        FEWizard.this.performDDLGeneration(monitor);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public StringWriter generateDDL() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    FEWizard.this.writer = new StringWriter();
                    monitor.beginTask("", 5);
                    monitor.setTaskName(ResourceLoader.INSTANCE.queryString("FEWizard.generatingDDLProgressMessage"));
                    monitor.worked(1);
                    FEWizard.this.hasGenerated = false;
                    FEConfigurationData configurationData = FEWizard.this.selectOptionsPage.getOptions();
                    if (configurationData != null) {
                        try {
                            FEWizard.this.ddlScripts = FEWizard.this.feProvider.generateDDL(FEWizard.this.selection.toArray(new SQLObject[FEWizard.this.selection.size()]), monitor);
                            FEWizard.this.hasGenerated = true;
                            monitor.worked(3);
                            int i = 0;
                            while (i < FEWizard.this.ddlScripts.length) {
                                FEWizard.this.writer.write(String.valueOf(FEWizard.this.ddlScripts[i]) + FEWizard.this.getExecutableSpecifier(FEWizard.this.databaseDefinition));
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.writer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performDDLGeneration(IProgressMonitor monitor) {
        block12: {
            try {
                try {
                    if (this.hasGenerated) {
                        Connection conn;
                        monitor.worked(2);
                        monitor.setTaskName(ResourceLoader.INSTANCE.queryString("FEWizard.savingDDLProgressMessage"));
                        IFile ddlFile = SaveDDLUtility.getInstance().saveDDLFileAsResource(this.writer, this.selectFilePage.getResourcePath());
                        monitor.worked(4);
                        if (this.selectFilePage.isOpenDDLSelected()) {
                            monitor.setTaskName(ResourceLoader.INSTANCE.queryString("FEWizard.openingDDLProgressMessage"));
                            if (ddlFile != null) {
                                IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(ddlFile.getName());
                                if (editorDescriptor == null) {
                                    editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("file.txt");
                                }
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(ddlFile), editorDescriptor.getId());
                            }
                        }
                        if (this.selectFilePage.isExecuteSelected() && (conn = this.getDBConnection()) != null && this.ddlScripts != null) {
                            int index = 0;
                            while (index < this.ddlScripts.length) {
                                monitor.setTaskName(String.valueOf(ResourceLoader.INSTANCE.queryString("FEWizard.executingProgressMessage")) + this.ddlScripts[index]);
                                new QueryOutputHelper(this.ddlScripts[index], conn).executeDDL(ResourceLoader.INSTANCE.queryString("FEWizard.queryOutputSourceIdentity"));
                                ++index;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (!this.hasGenerated) {
                    MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 513);
                    box.setMessage(ResourceLoader.INSTANCE.queryString("FEWizard.ddlGenerationErrorMessage"));
                    box.open();
                }
                throw throwable;
            }
            {
                Object var5_8 = null;
                if (this.hasGenerated) break block12;
            }
            MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 513);
            box.setMessage(ResourceLoader.INSTANCE.queryString("FEWizard.ddlGenerationErrorMessage"));
            box.open();
        }
        monitor.worked(5);
    }

    private String getExecutableSpecifier(DatabaseDefinition dbDef) {
        return dbDef.getProduct().equals("SQL Server") ? "\r\nGo\r\n\r\n" : ";\r\n\r\n";
    }

    public boolean canFinish() {
        boolean canFinish = false;
        canFinish = !this.selectFilePage.isExecuteSelected() ? this.selectOptionsPage.isPageComplete() && this.selectObjectsPage.isPageComplete() && this.selectFilePage.isPageComplete() && this.summaryPage.isVisible() : (this.existingConnectionsPage.isNewConnectionSelected() ? this.selectOptionsPage.isPageComplete() && this.selectObjectsPage.isPageComplete() && this.selectFilePage.isPageComplete() && this.configureJDBCPage.isPageComplete() && this.summaryPage.isVisible() : this.selectOptionsPage.isPageComplete() && this.selectObjectsPage.isPageComplete() && this.selectFilePage.isPageComplete() && this.summaryPage.isVisible());
        return canFinish;
    }

    public IWizardPage getNextPage(IWizardPage wizardPage) {
        Object nextPage = null;
        this.databaseAuthenticationPage.setConnectionInfo(this.existingConnectionsPage.getSelectedConnection());
        String currentProductSet = this.databaseDefinition.getProduct();
        String currentVersionSet = this.databaseDefinition.getVersion();
        if (!this.lastProductValueSet.equals(currentProductSet) || !this.lastVersionValueSet.equals(currentVersionSet)) {
            this.lastProductValueSet = currentProductSet;
            this.lastVersionValueSet = currentVersionSet;
            this.existingConnectionsPage.setAllowedProduct(currentProductSet);
            this.existingConnectionsPage.setAllowedVersion(currentVersionSet);
            this.configureJDBCPage.setAllowedProductVersions(new DatabaseProductVersion[]{new DatabaseProductVersion(currentProductSet, currentVersionSet)});
        }
        nextPage = wizardPage.getName().equals(SELECT_OPTIONS_WIZARD_PAGE_NAME) ? this.selectObjectsPage : (wizardPage.getName().equals(SELECT_OBJECTS_WIZARD_PAGE_NAME) ? this.selectFilePage : (wizardPage.getName().equals(SELECT_FILE_WIZARD_PAGE_NAME) ? (this.selectFilePage.isExecuteSelected() ? this.existingConnectionsPage : this.populateSummaryPage()) : (wizardPage.getName().equals(EXISTING_CONNECTIONS_WIZARD_PAGE_NAME) ? (this.existingConnectionsPage.isNewConnectionSelected() ? this.configureJDBCPage : (this.existingConnectionsPage.isSelectedConnectionClosed() ? this.databaseAuthenticationPage : this.populateSummaryPage())) : (wizardPage.getName().equals(DATABASE_AUTHENTICATION_WIZARD_PAGE_NAME) ? this.populateSummaryPage() : (wizardPage.getName().equals(CONFIGURE_JDBC_WIZARD_PAGE_NAME) ? this.populateSummaryPage() : (wizardPage.getName().equals(SUMMARY_WIZARD_PAGE_NAME) ? null : super.getNextPage(wizardPage)))))));
        return nextPage;
    }

    private FESummaryWizardPage populateSummaryPage() {
        if (this.summaryPage == null) {
            this.summaryPage = new FESummaryWizardPage(SUMMARY_WIZARD_PAGE_NAME);
            this.addPage((IWizardPage)this.summaryPage);
        }
        EngineeringOption[] options = this.selectOptionsPage.getOptions().getOptions();
        FESummaryProperty[] properties = null;
        Vector<FESummaryProperty> propertiesCollection = new Vector<FESummaryProperty>();
        propertiesCollection.add(new FESummaryProperty(ResourceLoader.INSTANCE.queryString("FEWizard.fileLocationSummaryProperty"), this.selectFilePage.getResourcePath()));
        propertiesCollection.add(new FESummaryProperty(ResourceLoader.INSTANCE.queryString("FEWizard.openDDLForEditingSummaryProperty"), String.valueOf(this.selectFilePage.isOpenDDLSelected())));
        propertiesCollection.add(new FESummaryProperty("", ""));
        int index = 0;
        while (index < options.length) {
            propertiesCollection.add(new FESummaryProperty(options[index].getOptionDescription(), String.valueOf(options[index].getBoolean())));
            ++index;
        }
        propertiesCollection.add(new FESummaryProperty("", ""));
        options = this.selectObjectsPage.getOptions().getOptions();
        index = 0;
        while (index < options.length) {
            propertiesCollection.add(new FESummaryProperty(options[index].getOptionDescription(), String.valueOf(options[index].getBoolean())));
            ++index;
        }
        properties = new FESummaryProperty[propertiesCollection.size()];
        propertiesCollection.toArray(properties);
        this.summaryPage.setProperties(properties);
        return this.summaryPage;
    }

    private Connection getDBConnection() {
        Connection connection = null;
        try {
            if (this.connection != null) {
                connection = this.connection;
            } else if (this.existingConnectionsPage.isNewConnectionSelected()) {
                ConnectionInfo connectionInfo = null;
                this.configureJDBCPage.internalSaveWidgetValues();
                this.configureJDBCPage.performTestConnection(false);
                if (this.configureJDBCPage.isFinalConnection()) {
                    connectionInfo = this.configureJDBCPage.getConnection();
                    this.connection = connection = this.persistConnection(connectionInfo);
                    this.connectionInfo = connectionInfo;
                }
            } else {
                this.connectionInfo = this.existingConnectionsPage.getSelectedConnection();
                connection = this.connection = this.connectionInfo.getSharedConnection();
            }
            return connection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Connection persistConnection(ConnectionInfo connectionInfo) {
        Connection connection = null;
        try {
            connection = connectionInfo.connect();
            connectionInfo.setSharedConnection(connection);
            connectionInfo.saveConnectionInfo();
            new DatabaseProviderHelper().setDatabase(connection, connectionInfo, connectionInfo.getDatabaseName());
        }
        catch (Exception exception) {
            RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(connectionInfo.getName());
            connection = null;
        }
        return connection;
    }

    private Database getDatabase(EObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Database) {
            return (Database)object;
        }
        return this.getDatabase(RDBCorePlugin.getDefault().getContainmentService().getContainer(object));
    }
}

