/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.PessimisticResourceRuleFactory;
import org.eclipse.team.internal.core.TeamHookDispatcher;
import org.eclipse.team.internal.core.TeamPlugin;

public abstract class RepositoryProvider
implements IProjectNature,
IAdaptable {
    private static final String TEAM_SETID = "org.eclipse.team.repository-provider";
    private static final List AllProviderTypeIds = RepositoryProvider.initializeAllProviderTypes();
    private IProject project;
    private static final ILock mappingLock = Platform.getJobManager().newLock();
    private static final Object NOT_MAPPED = new Object();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void map(IProject project, String id) throws TeamException {
        block16: {
            rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)project);
            try {
                try {
                    Platform.getJobManager().beginRule(rule, null);
                    try {
                        RepositoryProvider.mappingLock.acquire();
                        existingProvider = null;
                        if (project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY) != null) {
                            existingProvider = RepositoryProvider.getProvider(project);
                        }
                        if (existingProvider == null) ** GOTO lbl26
                        if (existingProvider.getID().equals(id)) {
                            var7_5 = null;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var8_14) {
                        var7_6 = null;
                        RepositoryProvider.mappingLock.release();
                        throw var8_14;
                    }
                    RepositoryProvider.mappingLock.release();
                    var9_8 = null;
                    break block16;
lbl-1000:
                    // 1 sources

                    {
                        RepositoryProvider.unmap(project);
lbl26:
                        // 2 sources

                        provider = RepositoryProvider.mapNewProvider(project, id);
                        try {
                            project.setPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY, id);
                        }
                        catch (CoreException outer) {
                            try {
                                project.setSessionProperty(TeamPlugin.PROVIDER_PROP_KEY, null);
                                throw outer;
                            }
                            catch (CoreException inner) {
                                TeamPlugin.log(4, NLS.bind((String)Messages.RepositoryProvider_couldNotClearAfterError, (Object[])new String[]{project.getName(), id}), inner);
                            }
                            throw outer;
                        }
                        provider.configure();
                        project.touch(null);
                        TeamHookDispatcher.setProviderRuleFactory(project, provider.getRuleFactory());
                    }
                    {
                        var7_7 = null;
                        RepositoryProvider.mappingLock.release();
                        ** GOTO lbl-1000
                    }
                }
                catch (CoreException e) {
                    throw TeamPlugin.wrapException(e);
                }
            }
            catch (Throwable var10_15) {
                var9_9 = null;
                Platform.getJobManager().endRule(rule);
                throw var10_15;
            }
        }
        Platform.getJobManager().endRule(rule);
        return;
lbl-1000:
        // 1 sources

        {
            var9_10 = null;
        }
        Platform.getJobManager().endRule(rule);
    }

    private static RepositoryProvider mapNewProvider(IProject project, String id) throws TeamException {
        RepositoryProvider provider = RepositoryProvider.newProvider(id);
        if (provider == null) {
            throw new TeamException(NLS.bind((String)Messages.RepositoryProvider_couldNotInstantiateProvider, (Object[])new String[]{project.getName(), id}));
        }
        if (!provider.canHandleLinkedResources()) {
            try {
                IResource[] members = project.members();
                int i = 0;
                while (i < members.length) {
                    IResource resource = members[i];
                    if (resource.isLinked()) {
                        throw new TeamException((IStatus)new Status(4, "org.eclipse.team.core", 378, NLS.bind((String)Messages.RepositoryProvider_linkedResourcesExist, (Object[])new String[]{project.getName(), id}), null));
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                throw TeamPlugin.wrapException(e);
            }
        }
        try {
            project.setSessionProperty(TeamPlugin.PROVIDER_PROP_KEY, (Object)provider);
            provider.setProject(project);
        }
        catch (CoreException e) {
            throw TeamPlugin.wrapException(e);
        }
        return provider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RepositoryProvider mapExistingProvider(IProject project, String id) throws TeamException {
        RepositoryProvider repositoryProvider;
        block8: {
            RepositoryProvider repositoryProvider2;
            block7: {
                RepositoryProvider repositoryProvider3;
                block5: {
                    try {
                        block6: {
                            mappingLock.acquire();
                            try {
                                String currentId = project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY);
                                if (currentId == null) {
                                    repositoryProvider3 = null;
                                    Object var3_7 = null;
                                    break block5;
                                }
                                if (currentId.equals(id)) break block6;
                                repositoryProvider2 = RepositoryProvider.lookupProviderProp(project);
                                break block7;
                            }
                            catch (CoreException e) {
                                throw TeamPlugin.wrapException(e);
                            }
                        }
                        repositoryProvider = RepositoryProvider.mapNewProvider(project, id);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var3_10 = null;
                        mappingLock.release();
                        throw throwable;
                    }
                }
                mappingLock.release();
                return repositoryProvider3;
            }
            Object var3_8 = null;
            mappingLock.release();
            return repositoryProvider2;
        }
        Object var3_9 = null;
        mappingLock.release();
        return repositoryProvider;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unmap(IProject project) throws TeamException {
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)project);
        try {
            try {
                Platform.getJobManager().beginRule(rule, null);
                try {
                    mappingLock.acquire();
                    String id = project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY);
                    if (id == null) {
                        throw new TeamException(NLS.bind((String)Messages.RepositoryProvider_No_Provider_Registered, (Object[])new String[]{project.getName()}));
                    }
                    RepositoryProvider provider = RepositoryProvider.getProvider(project);
                    if (provider == null) {
                        TeamPlugin.log(4, NLS.bind((String)Messages.RepositoryProvider_couldNotInstantiateProvider, (Object[])new String[]{project.getName(), id}), null);
                    }
                    if (provider != null) {
                        provider.deconfigure();
                    }
                    project.setSessionProperty(TeamPlugin.PROVIDER_PROP_KEY, null);
                    project.setPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY, null);
                    if (provider != null) {
                        provider.deconfigured();
                    }
                    project.touch(null);
                    TeamHookDispatcher.setProviderRuleFactory(project, null);
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    mappingLock.release();
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                    mappingLock.release();
                }
            }
            catch (CoreException e) {
                throw TeamPlugin.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Platform.getJobManager().endRule(rule);
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        Platform.getJobManager().endRule(rule);
    }

    private static RepositoryProvider lookupProviderProp(IProject project) throws CoreException {
        Object provider = project.getSessionProperty(TeamPlugin.PROVIDER_PROP_KEY);
        if (provider instanceof RepositoryProvider) {
            return (RepositoryProvider)provider;
        }
        return null;
    }

    public abstract void configureProject() throws CoreException;

    public final void configure() throws CoreException {
        try {
            this.configureProject();
        }
        catch (CoreException e) {
            try {
                RepositoryProvider.unmap(this.getProject());
            }
            catch (TeamException e2) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.team.core", 0, String.valueOf(Messages.RepositoryProvider_Error_removing_nature_from_project___1) + this.getID(), (Throwable)((Object)e2)));
            }
            throw e;
        }
    }

    protected void deconfigured() {
    }

    public abstract String getID();

    public IFileModificationValidator getFileModificationValidator() {
        return null;
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return null;
    }

    public String toString() {
        return NLS.bind((String)Messages.RepositoryProvider_toString, (Object[])new String[]{this.getProject().getName(), this.getID()});
    }

    public static final String[] getAllProviderTypeIds() {
        IProjectNatureDescriptor[] desc = ResourcesPlugin.getWorkspace().getNatureDescriptors();
        HashSet<String> teamSet = new HashSet<String>();
        teamSet.addAll(AllProviderTypeIds);
        int i = 0;
        while (i < desc.length) {
            String[] setIds = desc[i].getNatureSetIds();
            int j = 0;
            while (j < setIds.length) {
                if (setIds[j].equals(TEAM_SETID)) {
                    teamSet.add(desc[i].getNatureId());
                }
                ++j;
            }
            ++i;
        }
        return teamSet.toArray(new String[teamSet.size()]);
    }

    public static final RepositoryProvider getProvider(IProject project) {
        block10: {
            try {
                if (project.isAccessible()) {
                    RepositoryProvider provider = RepositoryProvider.lookupProviderProp(project);
                    if (provider != null) {
                        return provider;
                    }
                    if (RepositoryProvider.isMarkedAsUnshared(project)) {
                        return null;
                    }
                    String id = project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY);
                    if (id != null) {
                        return RepositoryProvider.mapExistingProvider(project, id);
                    }
                    IProjectDescription projectDesc = project.getDescription();
                    String[] natureIds = projectDesc.getNatureIds();
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    int i = 0;
                    while (i < natureIds.length) {
                        IProjectNatureDescriptor desc = workspace.getNatureDescriptor(natureIds[i]);
                        if (desc != null) {
                            String[] setIds = desc.getNatureSetIds();
                            int j = 0;
                            while (j < setIds.length) {
                                if (setIds[j].equals(TEAM_SETID)) {
                                    return RepositoryProvider.getProvider(project, natureIds[i]);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                if (RepositoryProvider.isAcceptableException(e)) break block10;
                TeamPlugin.log(e);
            }
        }
        RepositoryProvider.markAsUnshared(project);
        return null;
    }

    private static boolean isAcceptableException(CoreException e) {
        return e.getStatus().getCode() == 368;
    }

    public static final RepositoryProvider getProvider(IProject project, String id) {
        block11: {
            try {
                if (project.isAccessible()) {
                    RepositoryProvider provider = RepositoryProvider.lookupProviderProp(project);
                    if (provider != null) {
                        if (provider.getID().equals(id)) {
                            return provider;
                        }
                        return null;
                    }
                    if (RepositoryProvider.isMarkedAsUnshared(project)) {
                        return null;
                    }
                    String existingID = project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY);
                    if (id.equals(existingID)) {
                        RepositoryProvider newProvider = RepositoryProvider.mapExistingProvider(project, id);
                        if (newProvider != null && newProvider.getID().equals(id)) {
                            return newProvider;
                        }
                        return null;
                    }
                    IProjectNatureDescriptor desc = ResourcesPlugin.getWorkspace().getNatureDescriptor(id);
                    if (desc == null) {
                        return null;
                    }
                    String[] setIds = desc.getNatureSetIds();
                    int i = 0;
                    while (i < setIds.length) {
                        if (setIds[i].equals(TEAM_SETID)) {
                            return (RepositoryProvider)project.getNature(id);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                if (RepositoryProvider.isAcceptableException(e)) break block11;
                TeamPlugin.log(e);
            }
        }
        RepositoryProvider.markAsUnshared(project);
        return null;
    }

    public static boolean isShared(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            boolean shared;
            if (RepositoryProvider.lookupProviderProp(project) != null) {
                return true;
            }
            if (RepositoryProvider.isMarkedAsUnshared(project)) {
                return false;
            }
            boolean bl = shared = project.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY) != null;
            if (!shared) {
                RepositoryProvider.markAsUnshared(project);
            }
            return shared;
        }
        catch (CoreException e) {
            TeamPlugin.log(e);
            return false;
        }
    }

    private static boolean isMarkedAsUnshared(IProject project) {
        try {
            return project.getSessionProperty(TeamPlugin.PROVIDER_PROP_KEY) == NOT_MAPPED;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static void markAsUnshared(IProject project) {
        try {
            project.setSessionProperty(TeamPlugin.PROVIDER_PROP_KEY, NOT_MAPPED);
        }
        catch (CoreException coreException) {}
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private static List initializeAllProviderTypes() {
        IExtensionPoint extension;
        ArrayList<String> allIDs = new ArrayList<String>();
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.core", "repository")) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String extensionId = configElements[j].getAttribute("id");
                    allIDs.add(extensionId);
                    ++j;
                }
                ++i;
            }
        }
        return allIDs;
    }

    private static RepositoryProvider newProvider(String id) {
        IExtensionPoint extension;
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.core", "repository")) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String extensionId = configElements[j].getAttribute("id");
                    if (extensionId != null && extensionId.equals(id)) {
                        try {
                            return (RepositoryProvider)configElements[j].createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            TeamPlugin.log(e);
                        }
                        catch (ClassCastException e) {
                            String className = configElements[j].getAttribute("class");
                            TeamPlugin.log(4, NLS.bind((String)Messages.RepositoryProvider_invalidClass, (Object[])new String[]{id, className}), e);
                        }
                        return null;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public IStatus validateCreateLink(IResource resource, int updateFlags, IPath location) {
        if (this.canHandleLinkedResources()) {
            return Team.OK_STATUS;
        }
        return new Status(4, "org.eclipse.team.core", 378, NLS.bind((String)Messages.RepositoryProvider_linkedResourcesNotSupported, (Object[])new String[]{this.getProject().getName(), this.getID()}), null);
    }

    public boolean canHandleLinkedResources() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IResourceRuleFactory getRuleFactory() {
        return new PessimisticResourceRuleFactory();
    }
}

