/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.preferences.EncodingSettings;

public class XMLFilesPreferencePage
extends AbstractPreferencePage {
    protected EncodingSettings fEncodingSettings = null;
    protected Combo fEndOfLineCode = null;
    private Vector fEOLCodes = null;

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.xml.ui.webx0060");
        this.createContentsForCreatingOrSavingGroup(composite);
        this.createContentsForCreatingGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void createContentsForCreatingGroup(Composite parent) {
        Group creatingGroup = this.createGroup(parent, 1);
        creatingGroup.setText(XMLUIMessages.Creating_files);
        this.createLabel((Composite)creatingGroup, XMLUIMessages.Encoding_desc);
        this.fEncodingSettings = new EncodingSettings((Composite)creatingGroup, XMLUIMessages.Encoding);
    }

    protected void createContentsForCreatingOrSavingGroup(Composite parent) {
        Group creatingOrSavingGroup = this.createGroup(parent, 2);
        creatingOrSavingGroup.setText(XMLUIMessages.Creating_or_saving_files);
        Label label = this.createLabel((Composite)creatingOrSavingGroup, XMLUIMessages.End_of_line_code_desc);
        ((GridData)label.getLayoutData()).horizontalSpan = 2;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = true;
        this.createLabel((Composite)creatingOrSavingGroup, XMLUIMessages.End_of_line_code);
        this.fEndOfLineCode = this.createDropDownBox((Composite)creatingOrSavingGroup);
        this.populateLineDelimiters();
    }

    protected void doSavePreferenceStore() {
        XMLCorePlugin.getDefault().savePluginPreferences();
    }

    private String getCurrentEOLCode() {
        int i = this.fEndOfLineCode.getSelectionIndex();
        if (i >= 0) {
            return (String)this.fEOLCodes.elementAt(i);
        }
        return "";
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void initializeValues() {
        this.initializeValuesForCreatingOrSavingGroup();
        this.initializeValuesForCreatingGroup();
    }

    protected void initializeValuesForCreatingGroup() {
        String encoding = this.getModelPreferences().getString("outputCodeset");
        this.fEncodingSettings.setIANATag(encoding);
    }

    protected void initializeValuesForCreatingOrSavingGroup() {
        String endOfLineCode = this.getModelPreferences().getString("endOfLineCode");
        if (endOfLineCode.length() > 0) {
            this.setCurrentEOLCode(endOfLineCode);
        } else {
            this.setCurrentEOLCode("");
        }
    }

    protected void performDefaults() {
        this.performDefaultsForCreatingOrSavingGroup();
        this.performDefaultsForCreatingGroup();
        super.performDefaults();
    }

    protected void performDefaultsForCreatingGroup() {
        String encoding = this.getModelPreferences().getDefaultString("outputCodeset");
        this.fEncodingSettings.setIANATag(encoding);
    }

    protected void performDefaultsForCreatingOrSavingGroup() {
        String endOfLineCode = this.getModelPreferences().getDefaultString("endOfLineCode");
        if (endOfLineCode.length() > 0) {
            this.setCurrentEOLCode(endOfLineCode);
        } else {
            this.setCurrentEOLCode("");
        }
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }

    private void populateLineDelimiters() {
        this.fEOLCodes = new Vector();
        this.fEndOfLineCode.add(XMLUIMessages.EOL_Unix);
        this.fEOLCodes.add("EOL_Unix");
        this.fEndOfLineCode.add(XMLUIMessages.EOL_Mac);
        this.fEOLCodes.add("EOL_Mac");
        this.fEndOfLineCode.add(XMLUIMessages.EOL_Windows);
        this.fEOLCodes.add("EOL_Windows");
        this.fEndOfLineCode.add(XMLUIMessages.EOL_NoTranslation);
        this.fEOLCodes.add("");
    }

    private void setCurrentEOLCode(String eolCode) {
        this.fEndOfLineCode.clearSelection();
        this.fEndOfLineCode.deselectAll();
        int i = this.fEOLCodes.indexOf(eolCode);
        if (i >= 0) {
            this.fEndOfLineCode.select(i);
        }
    }

    protected void storeValues() {
        this.storeValuesForCreatingOrSavingGroup();
        this.storeValuesForCreatingGroup();
    }

    protected void storeValuesForCreatingGroup() {
        this.getModelPreferences().setValue("outputCodeset", this.fEncodingSettings.getIANATag());
    }

    protected void storeValuesForCreatingOrSavingGroup() {
        String eolCode = this.getCurrentEOLCode();
        this.getModelPreferences().setValue("endOfLineCode", eolCode);
    }
}

