/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.core.ElementCache;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelInfo;

public class JavaModelCache {
    public static final int DEFAULT_PROJECT_SIZE = 5;
    public static final int DEFAULT_ROOT_SIZE = 50;
    public static final int DEFAULT_PKG_SIZE = 500;
    public static final int DEFAULT_OPENABLE_SIZE = 500;
    public static final int DEFAULT_CHILDREN_SIZE = 10000;
    protected JavaModelInfo modelInfo;
    protected HashMap projectCache;
    protected ElementCache rootCache;
    protected ElementCache pkgCache;
    protected ElementCache openableCache;
    protected Map childrenCache;

    public JavaModelCache() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        double ratio = maxMemory == Long.MAX_VALUE ? 4.0 : (double)(maxMemory / 64000000L);
        this.projectCache = new HashMap(5);
        this.rootCache = new ElementCache((int)(50.0 * ratio));
        this.pkgCache = new ElementCache((int)(500.0 * ratio));
        this.openableCache = new ElementCache((int)(500.0 * ratio));
        this.childrenCache = new HashMap((int)(10000.0 * ratio));
    }

    public Object getInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return this.rootCache.get(element);
            }
            case 4: {
                return this.pkgCache.get(element);
            }
            case 5: 
            case 6: {
                return this.openableCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected Object peekAtInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return this.rootCache.peek(element);
            }
            case 4: {
                return this.pkgCache.peek(element);
            }
            case 5: 
            case 6: {
                return this.openableCache.peek(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected void putInfo(IJavaElement element, Object info) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = (JavaModelInfo)info;
                break;
            }
            case 2: {
                this.projectCache.put(element, info);
                this.rootCache.ensureSpaceLimit(((JavaElementInfo)info).children.length, element);
                break;
            }
            case 3: {
                this.rootCache.put(element, info);
                this.pkgCache.ensureSpaceLimit(((JavaElementInfo)info).children.length, element);
                break;
            }
            case 4: {
                this.pkgCache.put(element, info);
                this.openableCache.ensureSpaceLimit(((JavaElementInfo)info).children.length, element);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.put(element, info);
                break;
            }
            default: {
                this.childrenCache.put(element, info);
            }
        }
    }

    protected void removeInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = null;
                break;
            }
            case 2: {
                this.projectCache.remove(element);
                this.rootCache.resetSpaceLimit(50, element);
                break;
            }
            case 3: {
                this.rootCache.remove(element);
                this.pkgCache.resetSpaceLimit(500, element);
                break;
            }
            case 4: {
                this.pkgCache.remove(element);
                this.openableCache.resetSpaceLimit(500, element);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.remove(element);
                break;
            }
            default: {
                this.childrenCache.remove(element);
            }
        }
    }

    public String toStringFillingRation(String prefix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        buffer.append("Project cache: ");
        buffer.append(this.projectCache.size());
        buffer.append(" projects\n");
        buffer.append(prefix);
        buffer.append("Root cache[");
        buffer.append(this.rootCache.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.rootCache.fillingRatio()));
        buffer.append("%\n");
        buffer.append(prefix);
        buffer.append("Package cache[");
        buffer.append(this.pkgCache.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.pkgCache.fillingRatio()));
        buffer.append("%\n");
        buffer.append(prefix);
        buffer.append("Openable cache[");
        buffer.append(this.openableCache.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.openableCache.fillingRatio()));
        buffer.append("%\n");
        return buffer.toString();
    }
}

