/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.common.FacetMatcher;
import org.eclipse.jst.ws.internal.consumption.common.FacetSetsByTemplateCache;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class CreateFacetedProjectCommand
extends AbstractDataModelOperation {
    private String projectName;
    private String templateId;
    private RequiredFacetVersion[] requiredFacetVersions;
    private String serverFactoryId;
    private String serverInstanceId;
    private org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime;
    private IProgressMonitor monitor_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        this.monitor_ = monitor;
        IStatus status = Status.OK_STATUS;
        status = this.checkDataReady();
        if (status.getSeverity() == 4) {
            return status;
        }
        IProject project = ProjectUtilities.getProject((String)this.projectName);
        if (!project.exists()) {
            try {
                IFacetedProject fproject = ProjectFacetsManager.create((String)this.projectName, null, (IProgressMonitor)this.monitor_);
                Set facetsToAdd = this.getFacetsToAdd();
                Set actions = FacetUtils.getInstallActions(facetsToAdd);
                fproject.modify(actions, this.monitor_);
                Set newFacetVersions = fproject.getProjectFacets();
                HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
                Iterator iter = newFacetVersions.iterator();
                while (iter.hasNext()) {
                    IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
                    fixedFacets.add(facetVersion.getProjectFacet());
                }
                fproject.setFixedProjectFacets(fixedFacets);
                if (this.facetRuntime != null) {
                    fproject.setRuntime(this.facetRuntime, monitor);
                }
            }
            catch (CoreException coreException) {
                return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{this.projectName}));
            }
        }
        return status;
    }

    private IStatus checkDataReady() {
        if (this.projectName == null || this.serverFactoryId == null) {
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{this.projectName}));
        }
        return Status.OK_STATUS;
    }

    private Set getFacetsToAdd() {
        Set facets = null;
        this.setFacetRuntime();
        Set[] allCombinations = FacetSetsByTemplateCache.getInstance().getFacetVersionCombinationsFromTemplate(this.templateId);
        int n = allCombinations.length;
        if (this.facetRuntime != null) {
            int i = n - 1;
            while (i >= 0) {
                Set combination = allCombinations[i];
                FacetMatcher fm = FacetUtils.match(this.requiredFacetVersions, combination);
                if (fm.isMatch() && FacetUtils.doesRuntimeSupportFacets(this.facetRuntime, combination)) {
                    facets = combination;
                    break;
                }
                --i;
            }
        } else {
            int i = n - 1;
            while (i >= 0) {
                Set combination = allCombinations[i];
                FacetMatcher fm = FacetUtils.match(this.requiredFacetVersions, combination);
                if (fm.isMatch()) {
                    facets = combination;
                    break;
                }
                --i;
            }
        }
        if (facets == null) {
            facets = FacetUtils.getInitialFacetVersionsFromTemplate(this.templateId);
        }
        return facets;
    }

    private void setFacetRuntime() {
        if (this.serverInstanceId != null && this.serverInstanceId.length() > 0) {
            IServer server = ServerCore.findServer((String)this.serverInstanceId);
            IRuntime sRuntime = server.getRuntime();
            this.facetRuntime = FacetUtil.getRuntime((IRuntime)sRuntime);
        } else {
            IRuntime serverRuntime = ServerUtils.getNonStubRuntime((String)this.serverFactoryId);
            if (serverRuntime != null) {
                this.facetRuntime = FacetUtil.getRuntime((IRuntime)serverRuntime);
            } else {
                IServerType st = ServerCore.findServerType((String)this.serverFactoryId);
                String runtimeTypeId = st.getRuntimeType().getId();
                IRuntime[] runtimes = ServerCore.getRuntimes();
                int i = 0;
                while (i < runtimes.length) {
                    IRuntime sRuntime = runtimes[i];
                    if (sRuntime.getRuntimeType().getId().equals(runtimeTypeId)) {
                        this.facetRuntime = FacetUtil.getRuntime((IRuntime)sRuntime);
                    }
                    ++i;
                }
            }
        }
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setRequiredFacetVersions(RequiredFacetVersion[] requiredFacetVersions) {
        this.requiredFacetVersions = requiredFacetVersions;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }
}

